/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.io.IOUtils;

public class LanguagePanel
extends JPanel {
    private final JLabel languageLabel;
    private final ActionListener actionListener;
    private final JComboBox languageOptions;

    public LanguagePanel(ActionListener actionListener) {
        this.setLayout(new BoxLayout(this, 0));
        this.actionListener = actionListener;
        this.languageLabel = new JLabel();
        this.languageOptions = new JComboBox();
        Font font = new Font("Dialog", 0, 11);
        this.languageOptions.setFont(font);
        Locale[] localeArray = LanguageUtils.getLocales(font);
        this.languageOptions.setModel(new DefaultComboBoxModel<Locale>(localeArray));
        this.languageOptions.setRenderer(LanguageFlagFactory.getListRenderer());
        Locale locale = this.guessLocale();
        this.languageOptions.setSelectedItem(locale);
        this.applySettings(false);
        this.languageOptions.addItemListener(new StateListener());
        this.add(this.languageLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.languageOptions);
    }

    public void applySettings(boolean bl) {
        Locale locale = (Locale)this.languageOptions.getSelectedItem();
        LanguageUtils.setLocale(locale);
        ResourceManager.validateLocaleAndFonts(locale);
        this.languageLabel.setText(I18n.tr("Language:"));
    }

    private Locale guessLocale() {
        String[] stringArray = this.guessLanguage();
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String[] guessLanguage() {
        String string = ApplicationSettings.LANGUAGE.getValue();
        String string2 = ApplicationSettings.COUNTRY.getValue();
        String string3 = ApplicationSettings.LOCALE_VARIANT.getValue();
        File file = new File("language.prop");
        if (!file.exists()) {
            return new String[]{string, string2, string3};
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        String string4 = "";
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            string4 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            IOUtils.close(fileInputStream);
            IOUtils.close(bufferedReader);
            catch (Throwable throwable) {
                IOUtils.close(fileInputStream);
                IOUtils.close(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.close(fileInputStream);
        IOUtils.close(bufferedReader);
        String[] stringArray = this.getLCID(string4);
        if (stringArray != null) {
            return stringArray;
        }
        return new String[]{string, string2, string3};
    }

    private String[] getLCID(String string) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("1078", new String[]{"af", "", ""});
        hashMap.put("1052", new String[]{"sq", "", ""});
        hashMap.put("5121", new String[]{"ar", "", ""});
        hashMap.put("15361", new String[]{"ar", "", ""});
        hashMap.put("3073", new String[]{"ar", "", ""});
        hashMap.put("2049", new String[]{"ar", "", ""});
        hashMap.put("11265", new String[]{"ar", "", ""});
        hashMap.put("13313", new String[]{"ar", "", ""});
        hashMap.put("12289", new String[]{"ar", "", ""});
        hashMap.put("4097", new String[]{"ar", "", ""});
        hashMap.put("6145", new String[]{"ar", "", ""});
        hashMap.put("8193", new String[]{"ar", "", ""});
        hashMap.put("16385", new String[]{"ar", "", ""});
        hashMap.put("1025", new String[]{"ar", "", ""});
        hashMap.put("10241", new String[]{"ar", "", ""});
        hashMap.put("7169", new String[]{"ar", "", ""});
        hashMap.put("14337", new String[]{"ar", "", ""});
        hashMap.put("9217", new String[]{"ar", "", ""});
        hashMap.put("1069", new String[]{"eu", "", ""});
        hashMap.put("1059", new String[]{"be", "", ""});
        hashMap.put("1093", new String[]{"bn", "", ""});
        hashMap.put("1027", new String[]{"ca", "", ""});
        hashMap.put("3076", new String[]{"zh", "", ""});
        hashMap.put("5124", new String[]{"zh", "", ""});
        hashMap.put("2052", new String[]{"zh", "", ""});
        hashMap.put("4100", new String[]{"zh", "", ""});
        hashMap.put("1028", new String[]{"zh", "TW", ""});
        hashMap.put("1050", new String[]{"hr", "", ""});
        hashMap.put("1029", new String[]{"cs", "", ""});
        hashMap.put("1030", new String[]{"da", "", ""});
        hashMap.put("2067", new String[]{"nl", "", ""});
        hashMap.put("1043", new String[]{"nl", "", ""});
        hashMap.put("3081", new String[]{"en", "", ""});
        hashMap.put("10249", new String[]{"en", "", ""});
        hashMap.put("4105", new String[]{"en", "", ""});
        hashMap.put("9225", new String[]{"en", "", ""});
        hashMap.put("6153", new String[]{"en", "", ""});
        hashMap.put("8201", new String[]{"en", "", ""});
        hashMap.put("5129", new String[]{"en", "", ""});
        hashMap.put("13321", new String[]{"en", "", ""});
        hashMap.put("7177", new String[]{"en", "", ""});
        hashMap.put("11273", new String[]{"en", "", ""});
        hashMap.put("2057", new String[]{"en", "", ""});
        hashMap.put("1033", new String[]{"en", "", ""});
        hashMap.put("12297", new String[]{"en", "", ""});
        hashMap.put("1061", new String[]{"et", "", ""});
        hashMap.put("1035", new String[]{"fi", "", ""});
        hashMap.put("2060", new String[]{"fr", "", ""});
        hashMap.put("11276", new String[]{"fr", "", ""});
        hashMap.put("3084", new String[]{"fr", "", ""});
        hashMap.put("9228", new String[]{"fr", "", ""});
        hashMap.put("12300", new String[]{"fr", "", ""});
        hashMap.put("1036", new String[]{"fr", "", ""});
        hashMap.put("5132", new String[]{"fr", "", ""});
        hashMap.put("13324", new String[]{"fr", "", ""});
        hashMap.put("6156", new String[]{"fr", "", ""});
        hashMap.put("10252", new String[]{"fr", "", ""});
        hashMap.put("4108", new String[]{"fr", "", ""});
        hashMap.put("7180", new String[]{"fr", "", ""});
        hashMap.put("3079", new String[]{"de", "", ""});
        hashMap.put("1031", new String[]{"de", "", ""});
        hashMap.put("5127", new String[]{"de", "", ""});
        hashMap.put("4103", new String[]{"de", "", ""});
        hashMap.put("2055", new String[]{"de", "", ""});
        hashMap.put("1032", new String[]{"el", "", ""});
        hashMap.put("1037", new String[]{"iw", "", ""});
        hashMap.put("1081", new String[]{"hi", "", ""});
        hashMap.put("1038", new String[]{"hu", "", ""});
        hashMap.put("1039", new String[]{"is", "", ""});
        hashMap.put("1057", new String[]{"id", "", ""});
        hashMap.put("1040", new String[]{"it", "", ""});
        hashMap.put("2064", new String[]{"it", "", ""});
        hashMap.put("1041", new String[]{"ja", "", ""});
        hashMap.put("1042", new String[]{"ko", "", ""});
        hashMap.put("1062", new String[]{"lv", "", ""});
        hashMap.put("2110", new String[]{"ms", "", ""});
        hashMap.put("1086", new String[]{"ms", "", ""});
        hashMap.put("1082", new String[]{"mt", "", ""});
        hashMap.put("1044", new String[]{"no", "", ""});
        hashMap.put("2068", new String[]{"nn", "", ""});
        hashMap.put("1045", new String[]{"pl", "", ""});
        hashMap.put("1046", new String[]{"pt", "BR", ""});
        hashMap.put("2070", new String[]{"pt", "", ""});
        hashMap.put("1048", new String[]{"ro", "", ""});
        hashMap.put("2072", new String[]{"ro", "", ""});
        hashMap.put("1049", new String[]{"ru", "", ""});
        hashMap.put("2073", new String[]{"ru", "", ""});
        hashMap.put("3098", new String[]{"sr", "", ""});
        hashMap.put("2074", new String[]{"sr", "", ""});
        hashMap.put("1051", new String[]{"sk", "", ""});
        hashMap.put("1060", new String[]{"sl", "", ""});
        hashMap.put("11274", new String[]{"es", "", ""});
        hashMap.put("16394", new String[]{"es", "", ""});
        hashMap.put("13322", new String[]{"es", "", ""});
        hashMap.put("9226", new String[]{"es", "", ""});
        hashMap.put("5130", new String[]{"es", "", ""});
        hashMap.put("7178", new String[]{"es", "", ""});
        hashMap.put("12298", new String[]{"es", "", ""});
        hashMap.put("17418", new String[]{"es", "", ""});
        hashMap.put("4106", new String[]{"es", "", ""});
        hashMap.put("18442", new String[]{"es", "", ""});
        hashMap.put("3082", new String[]{"es", "", ""});
        hashMap.put("2058", new String[]{"es", "", ""});
        hashMap.put("19466", new String[]{"es", "", ""});
        hashMap.put("6154", new String[]{"es", "", ""});
        hashMap.put("15370", new String[]{"es", "", ""});
        hashMap.put("10250", new String[]{"es", "", ""});
        hashMap.put("20490", new String[]{"es", "", ""});
        hashMap.put("1034", new String[]{"es", "", ""});
        hashMap.put("14346", new String[]{"es", "", ""});
        hashMap.put("8202", new String[]{"es", "", ""});
        hashMap.put("1053", new String[]{"sv", "", ""});
        hashMap.put("2077", new String[]{"sv", "", ""});
        hashMap.put("1097", new String[]{"ta", "", ""});
        hashMap.put("1054", new String[]{"th", "", ""});
        hashMap.put("1055", new String[]{"tr", "", ""});
        hashMap.put("1058", new String[]{"uk", "", ""});
        hashMap.put("1056", new String[]{"ur", "", ""});
        hashMap.put("2115", new String[]{"uz", "", ""});
        hashMap.put("1091", new String[]{"uz", "", ""});
        hashMap.put("1066", new String[]{"vi", "", ""});
        return (String[])hashMap.get(string);
    }

    private class StateListener
    implements ItemListener {
        private StateListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                LanguagePanel.this.applySettings(false);
                LanguagePanel.this.actionListener.actionPerformed(null);
                LanguagePanel.this.languageOptions.requestFocus();
            }
        }
    }
}

