/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDragSourceListener;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import javax.swing.JComponent;

class BasicDragGestureListener
implements DragGestureListener {
    BasicDragGestureListener() {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
        LimeTransferHandler limeTransferHandler = (LimeTransferHandler)jComponent.getTransferHandler();
        Transferable transferable = limeTransferHandler.createTransferable(jComponent);
        if (transferable != null) {
            boolean bl = jComponent.getAutoscrolls();
            jComponent.setAutoscrolls(false);
            try {
                Image image = null;
                if (DragSource.isDragImageSupported()) {
                    image = limeTransferHandler.getImageRepresentation(transferable);
                }
                if (image != null) {
                    dragGestureEvent.startDrag(null, image, new Point(2, 2), transferable, new BasicDragSourceListener(bl));
                } else {
                    dragGestureEvent.startDrag(null, transferable, new BasicDragSourceListener(bl));
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                jComponent.setAutoscrolls(bl);
            }
        }
        limeTransferHandler.exportDone(jComponent, transferable, 0);
    }
}

