/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.limewire.i18n.I18nMarker;

public class ChatFrame
extends JFrame
implements ThemeObserver {
    private final String BLOCK_BUTTON_LABEL = I18nMarker.marktr("Block Host");
    private final String SEND_BUTTON_LABEL = I18nMarker.marktr("Send Message");
    private final String BLOCK_BUTTON_TIP = I18nMarker.marktr("Block Current Host");
    private final String SEND_BUTTON_TIP = I18nMarker.marktr("Send a Message to a Host");
    private final String WITH_LABEL = I18nMarker.marktr("Chatting with");
    private final String UNAVAILABLE_LABEL = I18nMarker.marktr("Host is unavailable");
    private final String YOU_LABEL = I18nMarker.marktr("You");
    private final int WINDOW_WIDTH = 500;
    private final int WINDOW_HEIGHT = 300;
    private final int WINDOW_MIN_WIDTH = 250;
    private final int WINDOW_MIN_HEIGHT = 200;
    private final int TEXT_FIELD_LIMIT = 500;
    private boolean connected = true;
    JTextArea _area;
    JTextField _field;
    JTextField _connectField;
    InstantMessenger _chat;
    ButtonRow _buttons;

    public ChatFrame(InstantMessenger instantMessenger) {
        this.setTitle(I18n.tr(this.WITH_LABEL) + " " + instantMessenger.getHost());
        this.setSize(500, 300);
        this._chat = instantMessenger;
        JFrame jFrame = GUIMediator.getAppFrame();
        int n = jFrame.getSize().width / 2;
        int n2 = jFrame.getSize().height / 2;
        int n3 = this.getSize().width / 2;
        int n4 = this.getSize().height / 2;
        int n5 = n - n3;
        int n6 = n2 - n4;
        int n7 = jFrame.getLocation().x;
        int n8 = jFrame.getLocation().y;
        int n9 = n7 + n5;
        int n10 = n8 + n6;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n9 < 0 || n10 < 0 || n9 >= dimension.width || n10 >= dimension.height) {
            n9 = (dimension.width - this.getSize().width) / 2;
            n10 = (dimension.height - this.getSize().height) / 2;
        }
        this.setLocation(n9, n10);
        BlockListener blockListener = new BlockListener();
        SendListener sendListener = new SendListener();
        String[] stringArray = new String[]{this.BLOCK_BUTTON_LABEL, this.SEND_BUTTON_LABEL};
        String[] stringArray2 = new String[]{this.BLOCK_BUTTON_TIP, this.SEND_BUTTON_TIP};
        ActionListener[] actionListenerArray = new ActionListener[]{blockListener, sendListener};
        this._buttons = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 14);
        this._buttons.setButtonEnabled(1, false);
        TextPanel textPanel = new TextPanel();
        BoxPanel boxPanel = new BoxPanel(1);
        PaddedPanel paddedPanel = new PaddedPanel();
        paddedPanel.setPreferredSize(new Dimension(1000, 1000));
        paddedPanel.add(textPanel);
        boxPanel.add(paddedPanel);
        boxPanel.add(Box.createVerticalStrut(6));
        boxPanel.add(this._buttons);
        boxPanel.add(Box.createVerticalStrut(6));
        this.getContentPane().add(boxPanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JFrame jFrame = (JFrame)componentEvent.getSource();
                int n = jFrame.getWidth();
                int n2 = jFrame.getHeight();
                int n3 = Math.max(n, 250);
                int n4 = Math.max(n2, 200);
                if (n3 != n || n4 != n2) {
                    jFrame.setSize(n3, n4);
                }
            }
        });
        this.updateTheme();
    }

    public void chatAvailable(InstantMessenger instantMessenger) {
        if (this._chat != instantMessenger) {
            if (this._chat != null) {
                this._chat.stop();
            }
            this._chat = instantMessenger;
        }
        this._area.setForeground(UIManager.getColor("TextArea.foreground"));
        this.connected = true;
        this._buttons.setButtonEnabled(1, true);
    }

    public void updateTheme() {
        ImageIcon imageIcon = GUIMediator.getThemeImage("frosticon");
        this.setIconImage(imageIcon.getImage());
    }

    public void addResponse(String string) {
        String string2 = this._chat.getHost();
        this._area.setText(this._area.getText() + string2 + ": " + string + "\n");
    }

    public void chatUnavailable() {
        this._area.setForeground(Color.red);
        this.appendMessage(I18n.tr(this.UNAVAILABLE_LABEL));
        this.connected = false;
        this._buttons.setButtonEnabled(1, false);
    }

    private void appendMessage(String string) {
        this._area.append(string + "\n");
    }

    public void displayErrorMessage(String string) {
        this._area.setForeground(Color.red);
        if (string == null) {
            string = I18n.tr("A connection error has occurred");
        }
        this.appendMessage(string);
    }

    public void send() {
        if (!this.connected) {
            return;
        }
        String string = this._field.getText();
        if (string.length() == 0) {
            return;
        }
        if (this._chat.send(string)) {
            this.appendMessage(I18n.tr(this.YOU_LABEL) + ": " + string);
            this._field.setText("");
            this._buttons.setButtonEnabled(1, false);
        } else {
            this.displayErrorMessage(I18n.tr("Could not send chat message"));
        }
    }

    public InstantMessenger getChat() {
        return this._chat;
    }

    public void setMessage(String string) {
        this._field.setText(string);
    }

    public String getText() {
        return this._area.getText();
    }

    public String getMessage() {
        return this._field.getText();
    }

    public boolean isConnected() {
        return this.connected;
    }

    private class JTextFieldKeyListener
    implements KeyListener {
        private JTextFieldKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ChatFrame.this.send();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string = ChatFrame.this._field.getText();
            if (string.length() == 0) {
                ChatFrame.this._buttons.setButtonEnabled(1, false);
            } else if (ChatFrame.this.connected) {
                ChatFrame.this._buttons.setButtonEnabled(1, true);
            }
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ChatFrame.this._chat.getHost();
            GuiCoreMediator.getSpamServices().blockHost(string);
            ChatFrame.this._chat.stop();
        }
    }

    private class SendListener
    implements ActionListener {
        private SendListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatFrame.this.send();
        }
    }

    private class TextPanel
    extends JPanel {
        public TextPanel() {
            this.setLayout(new BoxLayout(this, 1));
            BoxPanel boxPanel = new BoxPanel(0);
            ChatFrame.this._area = new JTextArea();
            ChatFrame.this._area.setLineWrap(true);
            ChatFrame.this._field = new JTextField();
            ChatFrame.this._field.setDocument(new JTextFieldLimit(500));
            JScrollPane jScrollPane = new JScrollPane(ChatFrame.this._area);
            ChatFrame.this._area.setEditable(false);
            ChatFrame.this._field.addKeyListener(new JTextFieldKeyListener());
            boxPanel.add(Box.createHorizontalStrut(6));
            boxPanel.add(ChatFrame.this._field);
            boxPanel.add(Box.createHorizontalStrut(6));
            boxPanel.setPreferredSize(new Dimension(1000, 20));
            boxPanel.setMaximumSize(new Dimension(1000, 20));
            this.add(jScrollPane);
            this.add(Box.createVerticalStrut(6));
            this.add(boxPanel);
        }
    }

    private class JTextFieldLimit
    extends PlainDocument {
        private int limit;

        public JTextFieldLimit(int n) {
            this.limit = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.getLength() + string.length() <= this.limit) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

