/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Singleton;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTDownloaderImpl;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.logging.LogEvent;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.sharing.ShareManager;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.iTunesSettings;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.File;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class VisualConnectionCallback
implements ActivityCallback {
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        RoutedConnection routedConnection = connectionLifecycleEvent.getConnection();
        if (routedConnection != null) {
            Runnable runnable;
            if (connectionLifecycleEvent.isConnectionInitializingEvent()) {
                runnable = new ConnectionInitializing(routedConnection);
            } else if (connectionLifecycleEvent.isConnectionInitializedEvent()) {
                runnable = new ConnectionInitialized(routedConnection);
            } else if (connectionLifecycleEvent.isConnectionClosedEvent()) {
                runnable = new ConnectionClosed(routedConnection);
            } else {
                return;
            }
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void handleQueryString(String string) {
        this.HANDLE_QUERY_STRING.addQueryString(string);
    }

    @Override
    public void handleQueryResult(final RemoteFileDesc remoteFileDesc, final HostData hostData, final Set<? extends IpPort> set) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.handleQueryResult(remoteFileDesc, hostData, set);
            }
        });
    }

    @Override
    public boolean isQueryAlive(GUID gUID) {
        return SearchMediator.queryIsAlive(gUID);
    }

    @Override
    public void fileManagerLoaded() {
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoaded();
                }
            };
            BackgroundExecutorService.schedule(runnable);
        }
    }

    @Override
    public void handleSharedFileUpdate(File file) {
        this.mf().getLibraryMediator().updateSharedFile(file);
    }

    @Override
    public void handleFileEvent(final FileManagerEvent fileManagerEvent) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                if (DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isEnabled()) {
                    DaapManager.instance().handleFileManagerEvent(fileManagerEvent);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().handleFileManagerEvent(fileManagerEvent);
            }
        });
    }

    @Override
    public void fileManagerLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().clearLibrary();
            }
        });
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoading();
                }
            };
            BackgroundExecutorService.schedule(runnable);
        }
    }

    @Override
    public void addDownload(Downloader downloader) {
        AddDownload addDownload = new AddDownload(downloader);
        if (downloader instanceof BTDownloaderImpl && ((BTDownloader)downloader).isCompleted()) {
            return;
        }
        SwingUtilities.invokeLater(addDownload);
    }

    @Override
    public void removeDownload(Downloader downloader) {
        RemoveDownload removeDownload = new RemoveDownload(downloader);
        SwingUtilities.invokeLater(removeDownload);
        if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && downloader.getState() == Downloader.DownloadStatus.COMPLETE) {
            iTunesMediator.instance().addSong(downloader.getSaveFile());
        }
    }

    @Override
    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    @Override
    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        });
    }

    @Override
    public void addUpload(Uploader uploader) {
        UploadType uploadType = uploader.getUploadType();
        if (!uploadType.isInternal()) {
            SwingUtilities.invokeLater(new AddUpload(uploader));
        } else if (uploadType == UploadType.BROWSE_HOST) {
            SwingUtilities.invokeLater(new BrowseHosted(uploader));
        }
    }

    @Override
    public void removeUpload(Uploader uploader) {
        UploadType uploadType = uploader.getUploadType();
        if (uploadType != null && !uploadType.isInternal()) {
            SwingUtilities.invokeLater(new RemoveUpload(uploader));
        }
    }

    @Override
    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    @Override
    public void acceptChat(final InstantMessenger instantMessenger) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().acceptChat(instantMessenger);
            }
        });
    }

    @Override
    public void receiveMessage(final InstantMessenger instantMessenger, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().receiveMessage(instantMessenger, string);
            }
        });
    }

    @Override
    public void chatUnavailable(final InstantMessenger instantMessenger) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatUnavailable(instantMessenger);
            }
        });
    }

    @Override
    public void chatErrorMessage(final InstantMessenger instantMessenger, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatErrorMessage(instantMessenger, string);
            }
        });
    }

    @Override
    public void handleAddressStateChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    SearchMediator.addressChanged();
                }
            }
        });
    }

    public void handleNoInternetConnection() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    GUIMediator.disconnected();
                }
            }
        });
    }

    @Override
    public boolean warnAboutSharingSensitiveDirectory(final File file) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                atomicBoolean.set(ShareManager.warnAboutSensitiveDirectory(file));
            }
        });
        return atomicBoolean.get();
    }

    @Override
    public void setAnnotateEnabled(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().setAnnotateEnabled(bl);
            }
        });
    }

    @Override
    public void updateAvailable(UpdateInformation updateInformation) {
        GUIMediator.instance().showUpdateNotification(updateInformation);
    }

    @Override
    public void browseHostFailed(final GUID gUID) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(gUID);
            }
        });
    }

    @Override
    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader downloader2 = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("FrostWire has detected a corruption in the file {0}. Do you want to continue the download?", downloader2.getSaveFile().getName()), QuestionsHandler.CORRUPT_DOWNLOAD, DialogOption.NO);
                downloader2.discardCorruptDownload(dialogOption == DialogOption.NO);
            }
        });
    }

    public boolean promptAboutStopping() {
        DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("If you stop this upload, the torrent download will stop. Are you sure you want to do this?"), DialogOption.NO);
        return dialogOption == DialogOption.YES;
    }

    public boolean promptAboutSeeding() {
        DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("This upload is a torrent and it hasn't seeded enough. You should let it upload some more. Are you sure you want to stop it?"), DialogOption.NO);
        return dialogOption == DialogOption.YES;
    }

    @Override
    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    @Override
    public void componentLoading(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.setSplashScreenString(I18n.tr(string));
            }
        });
    }

    @Override
    public void acceptedIncomingChanged(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().getStatusLine().updateFirewallLabel(bl);
            }
        });
    }

    @Override
    public String getHostValue(String string) {
        return I18n.tr(string);
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    @Override
    public boolean handleMagnets(final MagnetOptions[] magnetOptionsArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = false;
                for (int i = 0; i < magnetOptionsArray.length; ++i) {
                    if (magnetOptionsArray[i].isKeywordTopicOnly() && !bl) {
                        String string = QueryUtils.createQueryString(magnetOptionsArray[i].getKeywordTopic());
                        SearchInformation searchInformation = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
                        if (SearchMediator.validateInfo(searchInformation) != 0) continue;
                        bl = true;
                        SearchMediator.triggerSearch(searchInformation);
                        continue;
                    }
                    DownloaderUtils.createDownloader(magnetOptionsArray[i]);
                }
                if (magnetOptionsArray.length > 0) {
                    GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
                }
            }
        });
        return true;
    }

    @Override
    public void handleTorrent(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().openTorrent(file);
            }
        });
    }

    @Override
    public void installationCorrupted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showWarning(I18n.tr("<html><b>Your FrostWire may have been corrupted by a virus or trojan!</b><br><br>Please visit <a href=\"http://www.frostwire.com/download\">www.frostwire.com</a> and download the newest official version of FrostWire.</html>"));
            }
        });
    }

    @Override
    public void handleTorrentMagnet(String string) {
        GUIMediator.instance().openTorrentMagnet(string);
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader uploader) {
            this.mgr = uploader;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().remove(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader uploader) {
            this.up = uploader;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().add(this.up);
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.up));
        }
    }

    private class BrowseHosted
    implements Runnable {
        private Uploader up;

        public BrowseHosted(Uploader uploader) {
            this.up = uploader;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.up));
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().remove(this.mgr);
            VisualConnectionCallback.this.mf().getLibraryMediator().quickRefresh();
            SearchMediator.updateResults();
            VisualConnectionCallback.this.mf().getLoggingMediator().add(new LogEvent(this.mgr));
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().add(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector<String> list = new Vector();
        private boolean active = false;

        public void addQueryString(String string) {
            this.list.add(string);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String string = this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this.mf().getMonitorView().handleQueryString(string);
            }
            this.active = false;
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private RoutedConnection c;

        public ConnectionClosed(RoutedConnection routedConnection) {
            this.c = routedConnection;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().remove(this.c);
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private RoutedConnection c;

        public ConnectionInitialized(RoutedConnection routedConnection) {
            this.c = routedConnection;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().update(this.c);
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private RoutedConnection c;

        public ConnectionInitializing(RoutedConnection routedConnection) {
            this.c = routedConnection;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().add(this.c);
        }
    }
}

