/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MediaSlider;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class MediaSliderUI
extends BasicSliderUI {
    protected BufferedImage trackImageCache;
    protected boolean isDirty = true;
    protected MediaSlider slider;
    private boolean isPressed = false;
    private ThumbMouse thumbMouseListener;
    private ResizeListener componentListener;

    public MediaSliderUI(MediaSlider mediaSlider) {
        super(mediaSlider);
        this.slider = mediaSlider;
        this.slider.setOpaque(false);
        this.thumbMouseListener = new ThumbMouse();
        this.componentListener = new ResizeListener();
    }

    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.focusInsets = new Insets(0, 0, 0, 0);
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        if (bl) {
            this.slider.repaint();
        }
    }

    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.addMouseListener(this.thumbMouseListener);
        jSlider.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.thumbMouseListener);
        jSlider.removeComponentListener(this.componentListener);
    }

    public Dimension getThumbSize() {
        BufferedImage bufferedImage = this.slider.getThumbImage();
        if (bufferedImage == null) {
            return super.getThumbSize();
        }
        return new Dimension(((Image)bufferedImage).getWidth(this.slider), ((Image)bufferedImage).getHeight(this.slider));
    }

    public void paintTrack(Graphics graphics) {
        if (this.slider.getLeftTrackImage() == null || this.slider.getCenterTrackImage() == null || this.slider.getRightTrackImage() == null) {
            super.paintTrack(graphics);
            return;
        }
        try {
            if (this.trackImageCache == null) {
                this.createTrackCache();
            } else if (this.isDirty) {
                if (this.slider.getOrientation() == 0) {
                    if (this.trackImageCache.getWidth() != this.contentRect.width) {
                        this.createTrackCache();
                    }
                } else if (this.trackImageCache.getHeight() != this.contentRect.height) {
                    this.createTrackCache();
                }
            }
            this.isDirty = false;
        }
        catch (IOException iOException) {
            super.paintTrack(graphics);
            return;
        }
        if (this.slider.getOrientation() == 0) {
            Rectangle rectangle = this.contentRect;
            int n = (rectangle.height - this.trackImageCache.getHeight()) / 2;
            graphics.translate(rectangle.x, rectangle.y + n);
            graphics.drawImage(this.trackImageCache, 0, 0, null);
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            Rectangle rectangle = this.contentRect;
            int n = (rectangle.width - this.trackImageCache.getWidth()) / 2;
            graphics.translate(rectangle.x + n, rectangle.y);
            graphics.drawImage(this.trackImageCache, 0, 0, null);
            graphics.translate(-(rectangle.x + n), -rectangle.y);
        }
    }

    protected void calculateTrackRect() {
        if (this.slider.getLeftTrackImage() == null || this.slider.getCenterTrackImage() == null || this.slider.getRightTrackImage() == null) {
            super.calculateTrackRect();
            return;
        }
        BufferedImage bufferedImage = this.slider.getLeftTrackImage();
        BufferedImage bufferedImage2 = this.slider.getRightTrackImage();
        int n = 0;
        if (this.slider.getOrientation() == 0) {
            n = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + bufferedImage.getWidth() + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackRect.x - bufferedImage2.getWidth() - this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            n = this.thumbRect.width;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    n += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    n -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n - 1) / 2;
            this.trackRect.y = this.contentRect.y + bufferedImage.getHeight() + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackRect.x - this.trackBuffer;
        }
    }

    protected void createTrackCache() throws IOException {
        BufferedImage bufferedImage = this.slider.getLeftTrackImage();
        BufferedImage bufferedImage2 = this.slider.getCenterTrackImage();
        BufferedImage bufferedImage3 = this.slider.getRightTrackImage();
        if (bufferedImage == null || bufferedImage2 == null || bufferedImage3 == null) {
            throw new IOException("null track image");
        }
        if (this.slider.getOrientation() == 0) {
            BufferedImage bufferedImage4 = new BufferedImage(this.contentRect.width, bufferedImage2.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage4.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, this.trackRect.x - bufferedImage.getWidth(), 0, null);
            graphics2D.drawImage(bufferedImage2, this.trackRect.x, 0, this.trackRect.width, bufferedImage2.getHeight(), null);
            graphics2D.drawImage((Image)bufferedImage3, (int)this.trackRect.getWidth() + this.trackRect.x, 0, null);
            this.trackImageCache = bufferedImage4;
            graphics2D.dispose();
        } else {
            BufferedImage bufferedImage5 = new BufferedImage(bufferedImage2.getWidth(), this.contentRect.height, 2);
            Graphics2D graphics2D = bufferedImage5.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, this.trackRect.y - bufferedImage.getHeight(), null);
            graphics2D.drawImage(bufferedImage2, 0, this.trackRect.y, bufferedImage2.getWidth(), this.trackRect.height, null);
            graphics2D.drawImage((Image)bufferedImage3, 0, (int)(this.trackRect.getHeight() + (double)this.trackRect.y), null);
            this.trackImageCache = bufferedImage5;
            graphics2D.dispose();
        }
    }

    public void paintThumb(Graphics graphics) {
        if (this.slider.getThumbImage() == null) {
            super.paintThumb(graphics);
            return;
        }
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y + 1);
        graphics.drawImage(this.isPressed || this.slider.getThumbPressedImage() == null ? this.slider.getThumbPressedImage() : this.slider.getThumbImage(), 0, 0, null);
        graphics.translate(-rectangle.x, -(rectangle.y + 1));
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public BufferedImage getTrackImage() {
        return this.trackImageCache;
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            MediaSliderUI.this.setDirty(true);
        }

        public void componentShown(ComponentEvent componentEvent) {
            MediaSliderUI.this.setDirty(true);
        }
    }

    private class ThumbMouse
    extends MouseAdapter {
        private ThumbMouse() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!MediaSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (MediaSliderUI.this.isPressed) {
                MediaSliderUI.this.isPressed = false;
                MediaSliderUI.this.slider.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!MediaSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (MediaSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                MediaSliderUI.this.isPressed = true;
                MediaSliderUI.this.slider.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

