/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.GuiFrostWireUtils;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.frostwire.gnutella.gui.tabs.AndroidTab;
import com.frostwire.gnutella.gui.tabs.ChatTab;
import com.frostwire.gnutella.gui.tabs.TabRightClickAdapter;
import com.frostwire.updates.UpdateManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PowerManager;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.TransferHandlerDropTargetListener;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.logging.LoggingMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tabs.ConnectionsTab;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.tabs.MonitorUploadTab;
import com.limegroup.gnutella.gui.tabs.SearchDownloadTab;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.SWTBrowserSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

public final class MainFrame
implements RefreshListener,
ThemeObserver {
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final SearchMediator SEARCH_MEDIATOR = new SearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = DownloadMediator.instance();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private UploadMediator UPLOAD_MEDIATOR = UploadMediator.instance();
    private final ConnectionMediator CONNECTION_MEDIATOR = ConnectionMediator.instance();
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final AndroidMediator ANDROID_MEDIATOR = AndroidMediator.instance();
    private final ChatMediator CHAT_MEDIATOR = ChatMediator.instance();
    private final LoggingMediator LOGGING_MEDIATOR = LoggingMediator.instance();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine(GuiCoreMediator.getNetworkManager());
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;
    private boolean isDownloadViewVisible = false;
    private final LogoPanel LOGO_PANEL = new LogoPanel();
    private Map<GUIMediator.Tabs, Tab> TABS = new HashMap<GUIMediator.Tabs, Tab>(7);
    private int height;
    private boolean isSearching = false;
    private WindowState lastState = null;

    MainFrame(JFrame jFrame) {
        Object object2;
        UpdateManager.scheduleUpdateCheckTask(0);
        this.FRAME = jFrame;
        new DropTarget(this.FRAME, new TransferHandlerDropTargetListener(DNDUtils.DEFAULT_TRANSFER_HANDLER));
        this.buildTabs();
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        this.FRAME.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                MainFrame.this.setSearchIconLocation();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                MainFrame.this.lastState = new WindowState();
                MainFrame.this.saveWindowState();
            }

            public void componentResized(ComponentEvent componentEvent) {
                MainFrame.this.saveWindowState();
                MainFrame.this.setSearchIconLocation();
            }
        });
        this.FRAME.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                MainFrame.this.saveWindowState();
            }
        });
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent windowEvent) {
                if (!OSUtils.supportsTray() || !ResourceManager.instance().isTrayIconAvailable()) {
                    GUIMediator.restoreView();
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.saveWindowState();
                SettingsGroupManager.instance().save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Tab tab = (Tab)propertyChangeEvent.getSource();
                int n = MainFrame.this.getTabIndex(tab);
                if (n != -1) {
                    if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        MainFrame.this.TABBED_PANE.setTitleAt(n, (String)propertyChangeEvent.getNewValue());
                    } else if ("tooltip".equals(propertyChangeEvent.getPropertyName())) {
                        MainFrame.this.TABBED_PANE.setToolTipTextAt(n, (String)propertyChangeEvent.getNewValue());
                    }
                }
            }
        };
        for (Object object2 : GUIMediator.Tabs.values()) {
            Tab tab = this.TABS.get(object2);
            if (tab == null) continue;
            this.addTab(tab);
            tab.addPropertyChangeListener(propertyChangeListener);
        }
        this.TABBED_PANE.setRequestFocusEnabled(false);
        this.TABBED_PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Tab tab;
                TabbedPaneUI tabbedPaneUI = MainFrame.this.TABBED_PANE.getUI();
                int n = tabbedPaneUI.tabForCoordinate(MainFrame.this.TABBED_PANE, mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && (tab = MainFrame.this.getTabForIndex(n)) != null) {
                    tab.mouseClicked();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        if (!ApplicationSettings.MONITOR_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.MONITOR, false);
        }
        if (!ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.CONNECTION, false);
        }
        if (!ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.LIBRARY, false);
        }
        if (SWTBrowserSettings.USE_SWT_BROWSER.getValue() && GUIMediator.isBrowserCapable() && !ApplicationSettings.SWT_BROWSER_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.FROSTCLICK, false);
        }
        if (!ApplicationSettings.ANDROID_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.ANDROID, false);
        }
        if (!ApplicationSettings.CHAT_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.CHAT, false);
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        JPanel jPanel = new JPanel();
        this.FRAME.setContentPane(jPanel);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.TABBED_PANE, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.STATUS_LINE.getComponent(), gridBagConstraints);
        JLayeredPane jLayeredPane = JLayeredPane.getLayeredPaneAbove(this.TABBED_PANE);
        jLayeredPane.add(this.LOGO_PANEL, JLayeredPane.PALETTE_LAYER, 0);
        ThemeMediator.addThemeObserver(this);
        GUIMediator.addRefreshListener(this);
        this.updateLogoHeight();
        if (ApplicationSettings.MAGNET_CLIPBOARD_LISTENER.getValue()) {
            this.FRAME.addWindowListener(MagnetClipboardListener.getInstance());
        }
        object2 = new PowerManager();
        this.FRAME.addWindowListener((WindowListener)object2);
        GUIMediator.addRefreshListener((RefreshListener)object2);
        GuiCoreMediator.getCoreBackgroundExecutor().execute(new Runnable(){

            public void run() {
                GuiFrostWireUtils.verifySharedTorrentFolderCorrecteness();
            }
        });
    }

    void saveWindowState() {
        int n = this.FRAME.getExtendedState();
        if (n == 0) {
            Dimension dimension = GUIMediator.getAppSize();
            if (dimension.height > 100 && dimension.width > 100) {
                Point point = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dimension.width);
                ApplicationSettings.APP_HEIGHT.setValue(dimension.height);
                ApplicationSettings.WINDOW_X.setValue(point.x);
                ApplicationSettings.WINDOW_Y.setValue(point.y);
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(false);
            }
        } else if ((n & 6) == 6) {
            ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            if (this.lastState != null && this.lastState.time == System.currentTimeMillis()) {
                ApplicationSettings.WINDOW_X.setValue(this.lastState.x);
                ApplicationSettings.WINDOW_Y.setValue(this.lastState.y);
                this.lastState = null;
            }
        }
    }

    public void updateTheme() {
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        this.LOGO_PANEL.updateTheme();
        this.setSearchIconLocation();
        this.updateLogoHeight();
        for (GUIMediator.Tabs tabs : GUIMediator.Tabs.values()) {
            this.updateTabIcon(tabs);
        }
    }

    private void updateLogoHeight() {
        Rectangle rectangle = this.TABBED_PANE.getUI().getTabBounds(this.TABBED_PANE, 0);
        Dimension dimension = this.LOGO_PANEL.getPreferredSize();
        int n = dimension.height + 4;
        this.height = Math.max(rectangle.height, n);
        if (rectangle.height < n) {
            this.TABBED_PANE.setBorder(BorderFactory.createEmptyBorder(n - rectangle.height, 0, 0, 0));
        } else {
            this.TABBED_PANE.setBorder(null);
        }
    }

    private void buildTabs() {
        this.TABBED_PANE.addMouseListener(TabRightClickAdapter.getInstance());
        this.TABS.put(GUIMediator.Tabs.SEARCH, new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.MONITOR, new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.CONNECTION, new ConnectionsTab(this.CONNECTION_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.LIBRARY, new LibraryPlayListTab(this.LIBRARY_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.ANDROID, new AndroidTab(this.ANDROID_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.CHAT, new ChatTab(this.CHAT_MEDIATOR));
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip());
    }

    private void insertTab(Tab tab, int n) {
        this.TABBED_PANE.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip(), n);
        SwingUtilities.updateComponentTreeUI(this.TABBED_PANE);
        ThemeMediator.updateThemeObservers();
    }

    public final void setSelectedTab(GUIMediator.Tabs tabs) {
        int n = this.getTabIndex(tabs);
        if (n == -1) {
            return;
        }
        this.TABBED_PANE.setSelectedIndex(n);
    }

    void updateTabIcon(GUIMediator.Tabs tabs) {
        Tab tab;
        int n = this.getTabIndex(tabs);
        if (n != -1 && (tab = this.TABS.get((Object)tabs)) != null) {
            this.TABBED_PANE.setIconAt(n, tab.getIcon());
        }
    }

    private final void setFrameDimensions() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(dimension.width - insets.left - insets.right, ApplicationSettings.APP_WIDTH.getValue());
        int n4 = Math.min(dimension.height - insets.top - insets.bottom, ApplicationSettings.APP_HEIGHT.getValue());
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            n = Math.max(insets.left, ApplicationSettings.WINDOW_X.getValue());
            n2 = Math.max(insets.top, ApplicationSettings.WINDOW_Y.getValue());
        } else {
            n = (dimension.width - n3) / 2;
            n2 = (dimension.height - n4) / 2;
        }
        if (n + n3 > dimension.width) {
            n = Math.max(insets.left, dimension.width - insets.left - insets.right - n3);
        }
        if (n2 + n4 > dimension.height) {
            n2 = Math.max(insets.top, dimension.height - insets.top - insets.bottom - n4);
        }
        this.FRAME.setLocation(n, n2);
        this.FRAME.setSize(new Dimension(n3, n4));
        this.FRAME.getContentPane().setSize(new Dimension(n3, n4));
        ((JComponent)this.FRAME.getContentPane()).setPreferredSize(new Dimension(n3, n4));
        if (ApplicationSettings.MAXIMIZE_WINDOW.getValue() && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.FRAME.setExtendedState(6);
        }
    }

    void setTabVisible(GUIMediator.Tabs tabs, boolean bl) {
        Tab tab = this.TABS.get((Object)tabs);
        JComponent jComponent = tab.getComponent();
        int n = this.TABBED_PANE.getTabCount();
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                if (!jComponent.equals(this.TABBED_PANE.getComponentAt(i))) continue;
                this.TABBED_PANE.remove(i);
                break;
            }
        } else {
            int n2 = tabs.ordinal();
            for (int i = 0; i < n; ++i) {
                Component component = this.TABBED_PANE.getComponentAt(i);
                int n3 = this.getOrdinalForTabComponent(component);
                if (n3 > n2) {
                    this.insertTab(tab, i);
                    break;
                }
                if (i != n - 1) continue;
                this.insertTab(tab, i + 1);
            }
            JComponent jComponent2 = jComponent;
            jComponent2.invalidate();
            jComponent2.revalidate();
            jComponent2.repaint();
        }
        tabs.setEnabled(bl);
        tab.storeState(bl);
    }

    private int getOrdinalForTabComponent(Component component) {
        for (Map.Entry<GUIMediator.Tabs, Tab> entry : this.TABS.entrySet()) {
            if (!entry.getValue().getComponent().equals(component)) continue;
            return entry.getKey().ordinal();
        }
        return -1;
    }

    private int getTabIndex(GUIMediator.Tabs tabs) {
        Tab tab = this.TABS.get((Object)tabs);
        if (tab != null) {
            return this.getTabIndex(tab);
        }
        return -1;
    }

    private int getTabIndex(Tab tab) {
        int n = this.TABBED_PANE.getTabCount();
        JComponent jComponent = tab.getComponent();
        for (int i = 0; i < n; ++i) {
            Component component = this.TABBED_PANE.getComponentAt(i);
            if (!component.equals(jComponent)) continue;
            return i;
        }
        return -1;
    }

    private Tab getTabForIndex(int n) {
        Component component = this.TABBED_PANE.getComponentAt(n);
        if (component == null) {
            return null;
        }
        for (Tab tab : this.TABS.values()) {
            if (tab.getComponent() == null || !tab.getComponent().equals(component)) continue;
            return tab;
        }
        return null;
    }

    public void refresh() {
        int n;
        SearchDownloadTab searchDownloadTab;
        if (this.isSearching && (searchDownloadTab = (SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).getDividerLocation() == 0) {
            searchDownloadTab.setDividerLocation(0.5);
            this.isDownloadViewVisible = true;
        }
        if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() == 0 && this.isDownloadViewVisible) {
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).setDividerLocation(1000);
            this.isDownloadViewVisible = false;
        } else if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() > 0 && !this.isDownloadViewVisible && (n = this.DOWNLOAD_MEDIATOR.getActiveDownloads()) > 0) {
            double d = n > 6 ? 0.6 : 0.7;
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).setDividerLocation(d);
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).getComponent().revalidate();
            this.TABBED_PANE.revalidate();
            this.isDownloadViewVisible = true;
        }
    }

    final SearchMediator getSearchMediator() {
        return this.SEARCH_MEDIATOR;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadMediator getUploadMediator() {
        return this.UPLOAD_MEDIATOR;
    }

    final ConnectionMediator getConnectionMediator() {
        return this.CONNECTION_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    final ChatMediator getChatMediator() {
        return this.CHAT_MEDIATOR;
    }

    final LoggingMediator getLoggingMediator() {
        return this.LOGGING_MEDIATOR;
    }

    static final PlaylistMediator getPlaylistMediator() {
        return PlayerSettings.PLAYER_ENABLED.getValue() ? PlaylistMediator.getInstance() : null;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    public final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    public final void setSearching(boolean bl) {
        this.LOGO_PANEL.setSearching(bl);
        this.isSearching = bl;
        this.refresh();
    }

    private void setSearchIconLocation() {
        int n = this.MENU_MEDIATOR.getMenuBarHeight() + (this.height - this.LOGO_PANEL.getPreferredSize().height) / 2;
        this.LOGO_PANEL.setLocation(this.FRAME.getSize().width - this.LOGO_PANEL.getSize().width - 12, n);
    }

    private static class WindowState {
        private final int x = ApplicationSettings.WINDOW_X.getValue();
        private final int y = ApplicationSettings.WINDOW_Y.getValue();
        private final long time = System.currentTimeMillis();

        WindowState() {
        }
    }
}

