/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.AWTSplashWindow;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Main {
    private static URL CHOSEN_SPLASH_URL = null;

    public static void main(String[] stringArray) {
        System.out.println("1: Main.main(" + stringArray + ")");
        Frame frame = null;
        try {
            if (Main.isMacOSX()) {
                Class<?> clazz = Class.forName("com.limegroup.gnutella.gui.GURLHandler");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = object.getClass().getMethod("register", new Class[0]);
                method2.invoke(object, new Object[0]);
                if (Main.isOlderThanLeopard()) {
                    System.setProperty("java.nio.preferSelect", String.valueOf(System.getProperty("java.version").startsWith("1.5")));
                } else {
                    System.setProperty("java.nio.preferSelect", "false");
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                frame = Main.showInitialSplash();
            }
            Class.forName("com.limegroup.gnutella.gui.GUILoader").getMethod("load", String[].class, Frame.class).invoke(null, stringArray, frame);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static Frame showInitialSplash() {
        Frame frame = null;
        Image image = null;
        URL uRL = Main.getChosenSplashURL();
        if (uRL != null && (image = Toolkit.getDefaultToolkit().createImage(uRL)) != null) {
            frame = AWTSplashWindow.splash(image);
        }
        return frame;
    }

    public static final URL getChosenSplashURL() {
        if (CHOSEN_SPLASH_URL != null) {
            return CHOSEN_SPLASH_URL;
        }
        int n = Main.countSplashesInSplashJar();
        int n2 = 1 + Calendar.getInstance().get(12) % n;
        CHOSEN_SPLASH_URL = ClassLoader.getSystemResource("com/frostwire/splash/" + n2 + ".jpg");
        return CHOSEN_SPLASH_URL;
    }

    private static int countSplashesInSplashJar() {
        String[] stringArray;
        int n = 0;
        File file = new File("splash.jar");
        if (file.exists() && file.isFile()) {
            return Main.countImagesInJar("splash.jar");
        }
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("java.class.path");
        String[] stringArray2 = string2.split(string);
        try {
            stringArray = stringArray2;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String string3 = stringArray[i];
                System.out.println("class path entry = " + string3);
                if (!string3.endsWith("splash.jar")) continue;
                n = Main.countImagesInJar(string3);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0 && string2.toLowerCase().contains("frostwire.app") && System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            for (String string4 : stringArray = string2.split(":")) {
                if (!string4.contains("FrostWire.app") || !string4.endsWith("jar")) continue;
                string2 = string4.substring(0, string4.lastIndexOf("/"));
                return Main.countImagesInJar(string2 + "/splash.jar");
            }
        }
        return n;
    }

    private static int countImagesInJar(String string) {
        int n = 0;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(string));
        }
        catch (Exception exception) {
            return 0;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (!string2.endsWith("png") && !string2.endsWith("jpg") && !string2.endsWith("gif")) continue;
            System.out.println("one more image inside jar - " + string2 + " (" + ++n + ")");
        }
        return n;
    }

    private static boolean isMacOSX() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("mac os") && string.endsWith("x");
    }

    private static boolean isOlderThanLeopard() {
        String string = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        return n == 10 && n2 < 6;
    }

    private static int countSplashes() {
        int n = 0;
        try {
            JarFile jarFile = new JarFile("splash.jar");
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.endsWith("jpg") && !string.endsWith("png") && !string.endsWith("gif")) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }
}

