/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class LicenseWindow
extends JDialog
implements VerificationListener {
    protected final URN URN;
    protected final LimeXMLDocument DOCUMENT;
    protected final License LICENSE;
    protected final JPanel DETAILS;
    protected final VerificationListener LISTENER;
    protected final String KEY_VALUE;

    public static LicenseWindow create(License license, URN uRN, LimeXMLDocument limeXMLDocument, VerificationListener verificationListener) {
        String string = license.getLicenseName();
        if ("Creative Commons License".equals(string)) {
            return new CCWindow(license, uRN, limeXMLDocument, verificationListener);
        }
        if ("Weed License".equals(string)) {
            return new WeedWindow(license, uRN, limeXMLDocument, verificationListener);
        }
        return new UnknownWindow(license, uRN, limeXMLDocument, verificationListener);
    }

    private LicenseWindow(License license, URN uRN, LimeXMLDocument limeXMLDocument, VerificationListener verificationListener, String string) {
        super(GUIMediator.getAppFrame());
        this.URN = uRN;
        this.LICENSE = license;
        this.DETAILS = new JPanel(new GridBagLayout());
        this.LISTENER = verificationListener;
        this.KEY_VALUE = string;
        this.DOCUMENT = limeXMLDocument;
        this.setModal(false);
        this.setResizable(false);
        this.setTitle(this.getTitleString());
        this.setDefaultCloseOperation(2);
        JComponent jComponent = (JComponent)this.getContentPane();
        GUIUtils.addHideAction(jComponent);
        jComponent.setPreferredSize(new Dimension(400, 230));
        this.DETAILS.setPreferredSize(new Dimension(400, 210));
        this.getContentPane().setLayout(new GridBagLayout());
        this.constructDialog(this.getContentPane());
        this.validate();
    }

    public void licenseVerified(License license) {
        if (license == this.LICENSE) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LicenseWindow.this.buildDetails();
                }
            });
        }
        if (this.LISTENER != null) {
            this.LISTENER.licenseVerified(license);
        }
    }

    protected void createVerifying() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = this.newTextArea(this.getLocatingString());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.DETAILS.add((Component)jTextArea, gridBagConstraints);
    }

    protected void createNotVerified() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = this.newTextArea(this.getNotVerifiedString());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.DETAILS.add((Component)jTextArea, gridBagConstraints);
        JButton jButton = new JButton(this.getVerifyString());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiCoreMediator.getLicenseVerifier().verify(LicenseWindow.this.LICENSE, LicenseWindow.this);
                LicenseWindow.this.buildDetails();
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        this.DETAILS.add((Component)jButton, gridBagConstraints);
    }

    protected void createNotValid() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        URI uRI = this.LICENSE.getLicenseURI();
        JComponent jComponent = new JLabel(this.getWarningIcon());
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.DETAILS.add((Component)jComponent, gridBagConstraints);
        String string = this.getInvalidString();
        if (uRI != null && this.allowRetryLink()) {
            string = string + "  " + this.getRetryString();
        }
        jComponent = this.newTextArea(string);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.DETAILS.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.DETAILS.add(Box.createGlue(), gridBagConstraints);
        JButton jButton = new JButton(this.getVerifyString());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiCoreMediator.getLicenseVerifier().verify(LicenseWindow.this.LICENSE, LicenseWindow.this);
                LicenseWindow.this.buildDetails();
            }
        });
        jButton.setVisible(uRI != null && this.allowVerifyLookup());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 100);
        this.DETAILS.add((Component)jButton, gridBagConstraints);
        if (this.LICENSE.getLicenseDeed(this.URN) == null || !this.allowClaimedDeedLink()) {
            jComponent = new JLabel();
            jComponent.setVisible(false);
        } else {
            jComponent = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), this.getClaimedDeedString());
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)jComponent, gridBagConstraints);
        if (uRI == null || !this.allowVerificationLink()) {
            jComponent = new JLabel();
            jComponent.setVisible(false);
        } else {
            jComponent = new URLLabel(uRI, this.getVerificationString());
        }
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)jComponent, gridBagConstraints);
    }

    protected void createValid() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.getDetailsString());
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.DETAILS.add((Component)jLabel, gridBagConstraints);
        JTextArea jTextArea = this.newTextArea(this.LICENSE.getLicenseDescription(this.URN));
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.DETAILS.add((Component)jTextArea, gridBagConstraints);
        if (this.LICENSE.getLicenseDeed(this.URN) != null) {
            jLabel = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), this.getDeedString());
        } else {
            jLabel = new JLabel();
            jLabel.setVisible(false);
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)jLabel, gridBagConstraints);
        jLabel = new URLLabel(this.LICENSE.getLicenseURI(), this.getVerificationString());
        this.DETAILS.add((Component)jLabel, gridBagConstraints);
    }

    protected void buildDetails() {
        this.DETAILS.removeAll();
        if (this.LICENSE.isVerifying()) {
            this.createVerifying();
        } else if (!this.LICENSE.isVerified()) {
            this.createNotVerified();
        } else if (!this.LICENSE.isValid(this.URN)) {
            this.createNotValid();
        } else {
            this.createValid();
        }
        this.validate();
        this.repaint();
    }

    protected void createTopOfWindow(Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        URLLabel uRLLabel = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
        gridBagConstraints.insets = new Insets(4, 4, 2, 0);
        container.add((Component)uRLLabel, gridBagConstraints);
        Line line = new Line();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 3;
        container.add((Component)line, gridBagConstraints);
        JTextArea jTextArea = this.newTextArea(this.LICENSE.getLicense());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 4);
        container.add((Component)jTextArea, gridBagConstraints);
    }

    protected void constructDialog(Container container) {
        this.createTopOfWindow(container);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Line line = new Line();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        container.add((Component)line, gridBagConstraints);
        this.buildDetails();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.DETAILS, gridBagConstraints);
        line = new Line();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        container.add((Component)line, gridBagConstraints);
        JButton jButton = new JButton(I18n.tr("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseWindow.this.dispose();
                LicenseWindow.this.setVisible(false);
            }
        });
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        container.add((Component)jButton, gridBagConstraints);
        this.pack();
    }

    private JTextArea newTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(UIManager.getFont("Table.font"));
        JLabel jLabel = new JLabel();
        jTextArea.setForeground(jLabel.getForeground());
        jTextArea.setBackground(jLabel.getBackground());
        jTextArea.setText(string);
        return jTextArea;
    }

    protected abstract String getTitleString();

    protected abstract String getLocatingString();

    protected abstract String getNotVerifiedString();

    protected String getVerifyString() {
        return I18n.tr("Verify");
    }

    protected Icon getWarningIcon() {
        return GUIMediator.getThemeImage("warning");
    }

    protected abstract String getInvalidString();

    protected abstract String getRetryString();

    protected abstract String getClaimedDeedString();

    protected abstract String getVerificationString();

    protected abstract String getDetailsString();

    protected abstract String getDeedString();

    protected Icon getLargeLicenseIcon() {
        return GUIMediator.getThemeImage(this.KEY_VALUE.toLowerCase() + "_window");
    }

    protected boolean allowRetryLink() {
        return true;
    }

    protected boolean allowVerificationLink() {
        return true;
    }

    protected boolean allowClaimedDeedLink() {
        return true;
    }

    protected boolean allowVerifyLookup() {
        return true;
    }

    protected abstract String getLargeLicenseURLString();

    private static class UnknownWindow
    extends LicenseWindow {
        UnknownWindow(License license, URN uRN, LimeXMLDocument limeXMLDocument, VerificationListener verificationListener) {
            super(license, uRN, limeXMLDocument, verificationListener, "UNKNOWN");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.frostwire.com";
        }

        protected String getInvalidString() {
            return I18n.tr("This file may require a license in order to open and view.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try validating this license again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Claimed License Deed");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View License Deed");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is currently locating the details of this license.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this Creative Commons license.");
        }

        protected String getTitleString() {
            return I18n.tr("License Details");
        }

        protected Icon getLargeLicenseIcon() {
            return GUIMediator.getThemeImage("logo");
        }

        protected void createTopOfWindow(Container container) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            URLLabel uRLLabel = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
            gridBagConstraints.insets = new Insets(4, 4, 2, 4);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            container.add((Component)uRLLabel, gridBagConstraints);
        }

        protected void buildDetails() {
            this.DETAILS.removeAll();
            this.createNotValid();
            this.validate();
            this.repaint();
        }

        protected boolean allowRetryLink() {
            return false;
        }

        protected boolean allowVerificationLink() {
            return false;
        }

        protected boolean allowClaimedDeedLink() {
            return false;
        }

        protected boolean allowVerifyLookup() {
            return false;
        }
    }

    private static class WeedWindow
    extends LicenseWindow {
        WeedWindow(License license, URN uRN, LimeXMLDocument limeXMLDocument, VerificationListener verificationListener) {
            super(license, uRN, limeXMLDocument, verificationListener, "WEED");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.weedshare.com";
        }

        protected String getInvalidString() {
            return I18n.tr("FrostWire was unable to locate the details of this Weed file.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try looking up the details again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Weedshare Usage Rights");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View Usage Rights");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is contacting www.weedshare.com for the details of this file.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this file.");
        }

        protected String getTitleString() {
            return I18n.tr("Weedshare Details");
        }

        protected void createTopOfWindow(Container container) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            URLLabel uRLLabel = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
            gridBagConstraints.insets = new Insets(4, 4, 2, 4);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            container.add((Component)uRLLabel, gridBagConstraints);
        }
    }

    private static class CCWindow
    extends LicenseWindow {
        CCWindow(License license, URN uRN, LimeXMLDocument limeXMLDocument, VerificationListener verificationListener) {
            super(license, uRN, limeXMLDocument, verificationListener, "CC");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.creativecommons.org";
        }

        protected String getInvalidString() {
            return I18n.tr("FrostWire was unable to locate the details of this license.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try validating this license again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Claimed License Deed");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View License Deed");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is currently locating the details of this license.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this Creative Commons license.");
        }

        protected String getTitleString() {
            return I18n.tr("Creative Commons Details");
        }
    }
}

