/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.frostwire.updates.UpdateManager;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LanguageWindow
extends JDialog {
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final String TRANSLATE_URL = "http://www.frostwire.com/forum/viewforum.php?f=9";
    private JCheckBox showLanguageCheckbox;
    private JComboBox localeComboBox;
    private JPanel mainPanel;
    private OkayAction okayAction;
    private CancelAction cancelAction;
    private Locale currentLocale = GUIMediator.getLocale();
    private URLLabel helpTranslateLabel;
    private boolean defaultLocaleSelectable;

    public LanguageWindow() {
        super(GUIMediator.getAppFrame());
        this.initializeWindow();
        Font font = new Font("Dialog", 0, 11);
        Locale[] localeArray = LanguageUtils.getLocales(font);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.initializeContent(localeArray);
        this.initializeButtons();
        this.initializeWindow();
        this.updateLabels(this.currentLocale);
        this.pack();
        if (this.getWidth() < 350) {
            this.setSize(350, this.getHeight());
            this.setResizable(false);
        }
    }

    private void initializeWindow() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction(this);
    }

    private void initializeContent(Locale[] localeArray) {
        FormLayout formLayout = new FormLayout("pref:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        DefaultComboBoxModel<Locale> defaultComboBoxModel = new DefaultComboBoxModel<Locale>();
        int n = -1;
        int n2 = -1;
        Locale locale = Locale.getDefault();
        for (int i = 0; i < localeArray.length; ++i) {
            defaultComboBoxModel.addElement(localeArray[i]);
            int n3 = LanguageUtils.getMatchScore(this.currentLocale, localeArray[i]);
            if (n3 > n) {
                n = n3;
                n2 = i;
            }
            if (!localeArray[i].equals(locale)) continue;
            this.defaultLocaleSelectable = true;
        }
        this.localeComboBox = new JComboBox(defaultComboBoxModel);
        this.localeComboBox.setRenderer(LanguageFlagFactory.getListRenderer());
        this.localeComboBox.setMaximumRowCount(15);
        if (n2 != -1) {
            this.localeComboBox.setSelectedIndex(n2);
        }
        defaultFormBuilder.append(this.localeComboBox);
        defaultFormBuilder.nextLine();
        this.localeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Locale locale;
                if (itemEvent.getStateChange() == 1 && (locale = (Locale)itemEvent.getItem()) != null && !LanguageWindow.this.currentLocale.equals(locale)) {
                    LanguageWindow.this.updateLabels(locale);
                    LanguageWindow.this.showLanguageCheckbox.setSelected(!LanguageUtils.isEnglishLocale(locale));
                    LanguageWindow.this.currentLocale = locale;
                }
            }
        });
        this.helpTranslateLabel = new URLLabel(TRANSLATE_URL, "");
        defaultFormBuilder.append(this.helpTranslateLabel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalStrut(15));
        defaultFormBuilder.nextLine();
        this.showLanguageCheckbox = new JCheckBox();
        this.showLanguageCheckbox.setSelected(StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.getValue());
        defaultFormBuilder.append(this.showLanguageCheckbox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalStrut(5));
        defaultFormBuilder.nextLine();
        this.mainPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
    }

    private void initializeButtons() {
        this.okayAction = new OkayAction();
        this.cancelAction = new CancelAction();
        JPanel jPanel = new JPanel(new FlowLayout(4));
        jPanel.add(new JButton(this.okayAction));
        if (!LanguageUtils.isEnglishLocale(this.currentLocale)) {
            jPanel.add(new JButton(new UseEnglishAction()));
        }
        jPanel.add(new JButton(this.cancelAction));
        this.mainPanel.add((Component)jPanel, "South");
    }

    private void switchLanguage(Locale locale, boolean bl) {
        if (!this.defaultLocaleSelectable && LanguageUtils.matchesDefaultLocale(locale)) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(GUIMediator.getLocale())) {
            LanguageUtils.setLocale(locale);
            GUIMediator.instance().getStatusLine().updateLanguage();
            String string = I18n.trl("FrostWire must be restarted for the new language to take effect.", locale);
            UpdateManager.getInstance().checkForUpdates();
            GUIMediator.showMessage(string);
        }
        StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(bl);
        if (LanguageUtils.isEnglishLocale(locale)) {
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(bl);
        }
        GUIMediator.instance().getStatusLine().refresh();
        this.dispose();
        ChatMediator.instance().reloadConfiguration();
    }

    private void updateLabels(Locale locale) {
        this.setTitle(I18n.trl("Change Language", locale));
        this.okayAction.putValue("Name", I18n.trl("OK", locale));
        this.cancelAction.putValue("Name", I18n.trl("Cancel", locale));
        this.helpTranslateLabel.setText(I18n.trl("Help Translate FrostWire", locale));
        this.showLanguageCheckbox.setText(I18n.trl("Show Language in status bar", locale));
    }

    private class UseEnglishAction
    extends AbstractAction {
        public UseEnglishAction() {
            this.putValue("Name", "Use English");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LanguageWindow.this.switchLanguage(Locale.ENGLISH, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            GUIUtils.getDisposeAction().actionPerformed(actionEvent);
        }
    }

    private class OkayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Locale locale = (Locale)LanguageWindow.this.localeComboBox.getSelectedItem();
            LanguageWindow.this.switchLanguage(locale, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }
}

