/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.AzureusStarter;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.DeadlockSupport;
import com.limegroup.gnutella.gui.DefaultErrorCatcher;
import com.limegroup.gnutella.gui.ErrorHandler;
import com.limegroup.gnutella.gui.FileManagerWarningManager;
import com.limegroup.gnutella.gui.FirewallUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GURLHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LimeWireGUI;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MessageHandler;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SettingsWarningManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;
import org.limewire.util.Stopwatch;
import org.limewire.util.SystemUtils;

public final class Initializer {
    private final Log LOG;
    private final long EXPIRATION_DATE = Long.MAX_VALUE;
    private volatile boolean isStartup = false;
    private long startMemory;
    private final Stopwatch stopwatch;

    Initializer() {
        this.LOG = LogFactory.getLog(Initializer.class);
        if (this.LOG.isTraceEnabled()) {
            this.startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("START Initializer, using: " + this.startMemory + " memory");
        }
        this.stopwatch = new Stopwatch(this.LOG);
    }

    void initialize(String[] stringArray, Frame frame) throws Throwable {
        this.preinit();
        this.setupCallbacksAndListeners();
        this.validateStartup(stringArray);
        LimeWireGUI limeWireGUI = this.createLimeWire();
        LimeWireCore limeWireCore = limeWireGUI.getLimeWireCore();
        this.glueCore(limeWireCore);
        this.validateEarlyCore(limeWireCore);
        this.runExternalChecks(limeWireCore, stringArray);
        DeadlockSupport.startDeadlockMonitoring();
        this.installProperties();
        this.installResources();
        SetupManager setupManager = new SetupManager();
        this.switchSplashes(frame);
        this.startEarlyCore(setupManager, limeWireCore);
        this.initializeEarlyUI();
        this.startSetupManager(setupManager);
        this.validateSaveDirectory();
        this.loadUI();
        this.loadTrayAndNotifications();
        this.hideSplashAndShowUI();
        this.loadLateTasksForUI();
        this.installListenersForUI(limeWireCore);
        this.startCore(limeWireCore);
        this.runQueuedRequests(limeWireCore);
        this.startDAAP();
        this.startAzureusCore();
        this.postinit();
    }

    private void tryMigratingOldPreferences() {
        File file = CommonUtils.getUserHomeDir();
        File file2 = new File(file, ".frostwire4.20");
        if (!OSUtils.isWindows() || file2.exists() && file2.list() != null) {
            return;
        }
        File file3 = new File(file, ".frostwire4.18");
        if ((!file2.exists() || file2.list() == null) && file3.exists() && file3.isDirectory() && file3.list() != null) {
            FileUtils.copyDirectoryRecursively(file3, file2);
            FileUtils.deleteRecursive(new File(file2, "overlays"));
            FileUtils.delete(new File(file2, "overlays.dat"), false);
        }
    }

    private void preinit() {
        try {
            this.tryMigratingOldPreferences();
            LimeCoreGlue.preinstall();
        }
        catch (LimeCoreGlue.InstallFailedException installFailedException) {
            this.failPreferencesPermissions();
        }
    }

    private void setupCallbacksAndListeners() {
        ErrorService.setErrorCallback(new ErrorHandler());
        MessageService.setCallback(new MessageHandler());
        DefaultErrorCatcher.install();
        if (OSUtils.isMacOSX()) {
            SystemUtils.setOpenFileLimit(1024);
            this.stopwatch.resetAndLog("Open file limit raise");
            if (ThemeSettings.isBrushedMetalTheme()) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            MacEventHandler.instance();
            this.stopwatch.resetAndLog("MacEventHandler instance");
        }
    }

    private void validateStartup(String[] stringArray) {
        if (System.currentTimeMillis() > Long.MAX_VALUE) {
            this.failExpired();
        }
        if (stringArray.length >= 2 && "-pmf".equals(stringArray[0])) {
            PackagedMediaFileLauncher.launchFile(stringArray[1], false);
            System.exit(0);
        }
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            this.stopwatch.reset();
            Thread.yield();
        }
        if (stringArray.length >= 1 && "-startup".equals(stringArray[0])) {
            this.isStartup = true;
        }
        if (this.isStartup && !StartupSettings.RUN_ON_STARTUP.getValue()) {
            System.exit(0);
        }
    }

    private LimeWireGUI createLimeWire() {
        Injector injector = Guice.createInjector(new LimeWireModule());
        LimeWireGUI limeWireGUI = injector.getInstance(LimeWireGUI.class);
        return limeWireGUI;
    }

    private void glueCore(LimeWireCore limeWireCore) {
        limeWireCore.getLimeCoreGlue().install();
    }

    private void validateEarlyCore(LimeWireCore limeWireCore) {
        if (!limeWireCore.getNIODispatcher().isRunning()) {
            this.failInternetBlocked();
        }
    }

    private void runExternalChecks(LimeWireCore limeWireCore, String[] stringArray) {
        ExternalControl externalControl = limeWireCore.getExternalControl();
        if (OSUtils.isMacOSX()) {
            GURLHandler.getInstance().enable(externalControl);
            MacEventHandler.instance().enable(externalControl, this);
        }
        if (stringArray.length > 0 && !stringArray[0].equals("-startup")) {
            String string = externalControl.preprocessArgs(stringArray);
            externalControl.checkForActiveLimeWire(string);
            externalControl.enqueueControlRequest(string);
        } else if (!StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue()) {
            externalControl.checkForActiveLimeWire();
        }
    }

    private void installProperties() {
        System.setProperty("http.agent", LimeWireUtils.getHttpServer());
        this.stopwatch.resetAndLog("set system properties");
        if (OSUtils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.stopwatch.resetAndLog("set OSX properties");
        }
    }

    private void installResources() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                ResourceManager.instance();
            }
        });
    }

    private void startEarlyCore(SetupManager setupManager, LimeWireCore limeWireCore) {
        boolean bl = FirewallUtils.addToFirewall();
        if (!bl && !setupManager.shouldShowFirewallWindow()) {
            limeWireCore.getLifecycleManager().loadBackgroundTasks();
        }
    }

    private void switchSplashes(Frame frame) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                if (!Initializer.this.isStartup) {
                    SplashWindow.instance().begin();
                }
            }
        });
        if (frame != null) {
            frame.dispose();
        }
    }

    private void initializeEarlyUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading HTML Engine..."));
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                JLabel jLabel = new JLabel();
                jLabel.setFont(null);
                jLabel.setForeground(null);
                BasicHTML.createHTMLView(jLabel, "<html>.</html>");
            }
        });
        BugManager.instance();
    }

    private void startSetupManager(final SetupManager setupManager) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                setupManager.createIfNeeded();
            }
        });
    }

    private void validateSaveDirectory() {
        SaveDirectoryHandler.handleSaveDirectory();
    }

    private void loadUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading User Interface..."));
        this.stopwatch.resetAndLog("update splash for UI");
        if (OSUtils.isMacOSX()) {
            GUIMediator.instance();
            this.stopwatch.resetAndLog("OSX GUIMediator instance");
        } else {
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    GUIMediator.instance();
                }
            });
        }
        GUIMediator.setSplashScreenString(I18n.tr("Loading Core Components..."));
    }

    private void loadTrayAndNotifications() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                NotifyUserProxy.instance();
                if (!ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                    NotifyUserProxy.instance().hideTrayIcon();
                }
                SettingsWarningManager.checkTemporaryDirectoryUsage();
                SettingsWarningManager.checkSettingsLoadSaveFailure();
            }
        });
    }

    private void hideSplashAndShowUI() {
        if (!this.isStartup) {
            SplashWindow.instance().dispose();
            this.stopwatch.resetAndLog("hide splash");
        }
        GUIMediator.allowVisibility();
        this.stopwatch.resetAndLog("allow viz");
        if (!this.isStartup) {
            GUIMediator.setAppVisible(true);
            this.stopwatch.resetAndLog("set app visible TRUE");
        } else {
            GUIMediator.startupHidden();
            this.stopwatch.resetAndLog("start hidden");
        }
    }

    private void loadLateTasksForUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Icons..."));
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                IconManager.instance();
            }
        });
        this.stopwatch.resetAndLog("IconManager instance");
        GUIMediator.setSplashScreenString(I18n.tr("Loading Internationalization Support..."));
        I18NConvert.instance();
        this.stopwatch.resetAndLog("I18nConvert instance");
    }

    private void installListenersForUI(LimeWireCore limeWireCore) {
        limeWireCore.getFileManager().addFileEventListener(new FileManagerWarningManager(NotifyUserProxy.instance()));
    }

    private void startCore(LimeWireCore limeWireCore) {
        limeWireCore.getLifecycleManager().start();
        this.stopwatch.resetAndLog("lifecycle manager start");
        if (!ConnectionSettings.DISABLE_UPNP.getValue()) {
            limeWireCore.getUPnPManager().start();
            this.stopwatch.resetAndLog("start UPnPManager");
        }
        GUIMediator.instance().coreInitialized();
        this.stopwatch.resetAndLog("core initialized");
    }

    private void startAzureusCore() {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                AzureusStarter.start();
            }
        });
    }

    private void runQueuedRequests(LimeWireCore limeWireCore) {
        limeWireCore.getExternalControl().runQueuedControlRequest();
        this.stopwatch.resetAndLog("run queued control req");
    }

    private void startDAAP() {
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            try {
                GUIMediator.setSplashScreenString(I18n.tr("Loading Digital Audio Access Protocol..."));
                DaapManager.instance().start();
                this.stopwatch.resetAndLog("daap start");
                DaapManager.instance().init();
                this.stopwatch.resetAndLog("daap init");
            }
            catch (IOException iOException) {
                GUIMediator.showError(I18n.tr("FrostWire was unable to start the Digital Audio Access Protocol Service (for sharing files in iTunes). This feature will be turned off. You can turn it back on in options, under iTunes -> Sharing."));
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
        }
    }

    private void postinit() {
        GUIMediator.instance().loadFinished();
        this.stopwatch.resetAndLog("load finished");
        if (OSUtils.isMacOSX()) {
            UIManager.put("ProgressBar.repaintInterval", new Integer(500));
        }
        if (this.LOG.isTraceEnabled()) {
            long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("STOP Initializer, using: " + l + " memory, consumed: " + (l - this.startMemory));
        }
    }

    void setStartup() {
        this.isStartup = true;
    }

    private void failExpired() {
        this.fail(I18nMarker.marktr("This Alpha version has expired.  Press Ok to exit. "));
    }

    private void failInternetBlocked() {
        this.fail(I18nMarker.marktr("FrostWire was unable to initialize and start. This is usually due to a firewall program blocking FrostWire's access to the internet or loopback connections on the local machine. Please allow FrostWire access to the internet and restart FrostWire."));
    }

    private void failPreferencesPermissions() {
        this.fail(I18nMarker.marktr("FrostWire could not create a temporary preferences folder.\n\nThis is generally caused by a lack of permissions.  Please make sure that FrostWire (and you) have access to create files/folders on your computer.  If the problem persists, please visit www.frostwire.com and click the 'Support' link.\n\nFrostWire will now exit.  Thank You."));
    }

    private void fail(final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, new MultiLineLabel(I18n.tr(string), 400), I18n.tr("Error"), 0);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        System.exit(1);
    }
}

