/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.plaf.IconUIResource;

public class ImageManipulator
extends RGBImageFilter {
    private boolean brighter;
    private int percent;

    private ImageManipulator(boolean bl, int n) {
        this.brighter = bl;
        this.percent = n;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        return n3 & 0xFF000000 | this.filter(n3 >> 16) << 16 | this.filter(n3 >> 8) << 8 | this.filter(n3);
    }

    private int filter(int n) {
        n &= 0xFF;
        n = this.brighter ? 255 - (255 - n) * (100 - this.percent) / 100 : n * (100 - this.percent) / 100;
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    public static Icon brighten(Icon icon) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = ImageManipulator.brighten(image);
        return new IconUIResource(new ImageIcon(image));
    }

    public static Icon darken(Icon icon) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = ImageManipulator.darken(image);
        return new IconUIResource(new ImageIcon(image));
    }

    public static Icon gray(Icon icon) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = ImageManipulator.gray(image);
        return new IconUIResource(new ImageIcon(image));
    }

    public static Icon manipulate(Icon icon, boolean bl, int n) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = ImageManipulator.manipulate(image, bl, n);
        return new IconUIResource(new ImageIcon(image));
    }

    public static Image brighten(Image image) {
        return ImageManipulator.manipulate(image, true, 20);
    }

    public static Image darken(Image image) {
        return ImageManipulator.manipulate(image, false, 10);
    }

    public static Image gray(Image image) {
        return GrayFilter.createDisabledImage(image);
    }

    public static Image manipulate(Image image, boolean bl, int n) {
        ImageManipulator imageManipulator = new ImageManipulator(bl, n);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageManipulator);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Icon resize(Icon icon, int n, int n2) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = image.getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    private static Image getImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(new JLabel(), graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }
}

