/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.MySharedFilesAction;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.limewire.setting.BooleanSetting;

public final class FileManagerWarningManager
implements FileEventListener {
    private boolean showDepth = true;
    private final NotifyUser notifier;
    BooleanSetting numberSwitch;
    BooleanSetting depthSwitch;

    public FileManagerWarningManager(NotifyUser notifyUser, BooleanSetting booleanSetting, BooleanSetting booleanSetting2) {
        this.notifier = notifyUser;
        this.numberSwitch = booleanSetting;
        this.depthSwitch = booleanSetting2;
    }

    public FileManagerWarningManager(NotifyUser notifyUser) {
        this(notifyUser, QuestionsHandler.DONT_WARN_SHARING_NUMBER, QuestionsHandler.DONT_WARN_SHARING_DEPTH);
    }

    private void doWarning(final String string, final BooleanSetting booleanSetting) {
        if (!booleanSetting.getValue()) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    Notification notification = new Notification(string, null, true, new MySharedFilesAction(I18n.tr("View My Shared Files.")), new IgnoreAction(booleanSetting));
                    FileManagerWarningManager.this.notifier.showMessage(notification);
                }
            });
        }
    }

    public synchronized void handleFileEvent(FileManagerEvent fileManagerEvent) {
        switch (fileManagerEvent.getType()) {
            case FILEMANAGER_LOADING: {
                this.showDepth = true;
                break;
            }
            case ADD_FILE: {
                break;
            }
            case ADD_FOLDER: {
                if (this.showDepth && fileManagerEvent.getRelativeDepth() == SharingSettings.DEPTH_FOR_WARNING.getValue()) {
                    this.showDepth = false;
                    this.doWarning(I18n.tr("You are sharing many subfolders within your shared folder: {0}. This indicates a potential security problem, so please review your \"My Shared Files\" to ensure you aren't sharing any sensitive files.", fileManagerEvent.getRootShare()), this.depthSwitch);
                }
            }
            default: {
                return;
            }
        }
        if (fileManagerEvent.getFileManager().getNumFiles() == SharingSettings.FILES_FOR_WARNING.getValue()) {
            this.doWarning(I18n.tr("You are sharing a lot of files through FrostWire, {0} files and counting. Do you mean to share all these files? Please review your sharing settings and which files are shared to ensure you aren't sharing any sensitive files.", SharingSettings.FILES_FOR_WARNING.getValue()), this.numberSwitch);
        }
    }

    private static class IgnoreAction
    extends AbstractAction {
        BooleanSetting ignoreSwitch;

        public IgnoreAction(BooleanSetting booleanSetting) {
            this.ignoreSwitch = booleanSetting;
            this.putValue("Name", I18n.tr("Do not display this message again."));
            this.putValue("ShortDescription", I18n.tr("Do not display this message again."));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.ignoreSwitch.setValue(true);
        }
    }
}

