/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.security.AddressSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OnDemandUnicaster {
    private static final Log LOG = LogFactory.getLog(OnDemandUnicaster.class);
    private static final int CLEAR_TIME = 300000;
    private static final int QUERIED_HOSTS_CLEAR_TIME = 30000;
    private final Map<GUID.TimedGUID, Set<IpPort>> _queriedHosts;
    private final Map<GUESSEndpoint, AddressSecurityToken> _queryKeys;
    private final Map<GUESSEndpoint, SendLaterBundle> _bufferedURNs;
    private final QueryRequestFactory queryRequestFactory;
    private final UDPService udpService;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    @InspectionPoint(value="Unicaster class C stats")
    private final Inspectable classCQueried = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            ClassCNetworks classCNetworks = new ClassCNetworks();
            HashMap<String, byte[]> hashMap = OnDemandUnicaster.this._queriedHosts;
            synchronized (hashMap) {
                for (Set set : OnDemandUnicaster.this._queriedHosts.values()) {
                    classCNetworks.addAll(set);
                }
            }
            hashMap = new HashMap<String, byte[]>();
            hashMap.put("queried", classCNetworks.getTopInspectable(10));
            return hashMap;
        }
    };

    @Inject
    public OnDemandUnicaster(QueryRequestFactory queryRequestFactory, UDPService uDPService, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, PingRequestFactory pingRequestFactory) {
        this.queryRequestFactory = queryRequestFactory;
        this.udpService = uDPService;
        this.messageRouter = provider;
        this.pingRequestFactory = pingRequestFactory;
        this._queryKeys = new Hashtable<GUESSEndpoint, AddressSecurityToken>();
        this._bufferedURNs = new Hashtable<GUESSEndpoint, SendLaterBundle>();
        this._queriedHosts = new HashMap<GUID.TimedGUID, Set<IpPort>>();
        scheduledExecutorService.scheduleWithFixedDelay(new Expirer(), 300000L, 300000L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleWithFixedDelay(new QueriedHostsExpirer(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void handleQueryKeyPong(PingReply pingReply) throws NullPointerException, IllegalArgumentException {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        AddressSecurityToken addressSecurityToken = pingReply.getQueryKey();
        if (addressSecurityToken == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress inetAddress = pingReply.getInetAddress();
        int n = pingReply.getPort();
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
        this._queryKeys.put(gUESSEndpoint, addressSecurityToken);
        SendLaterBundle sendLaterBundle = this._bufferedURNs.remove(gUESSEndpoint);
        if (sendLaterBundle != null) {
            this.sendQuery(sendLaterBundle._queryURN, addressSecurityToken, gUESSEndpoint);
        }
    }

    public void query(GUESSEndpoint gUESSEndpoint, URN uRN) throws IllegalArgumentException {
        if (gUESSEndpoint == null) {
            throw new IllegalArgumentException("No Endpoint!");
        }
        if (uRN == null) {
            throw new IllegalArgumentException("No urn to look for!");
        }
        AddressSecurityToken addressSecurityToken = this._queryKeys.get(gUESSEndpoint);
        if (addressSecurityToken == null) {
            GUESSEndpoint gUESSEndpoint2 = new GUESSEndpoint(gUESSEndpoint.getInetAddress(), gUESSEndpoint.getPort());
            SendLaterBundle sendLaterBundle = new SendLaterBundle(uRN);
            this._bufferedURNs.put(gUESSEndpoint2, sendLaterBundle);
            PingRequest pingRequest = this.pingRequestFactory.createQueryKeyRequest();
            this.udpService.send(pingRequest, gUESSEndpoint.getInetAddress(), gUESSEndpoint.getPort());
        } else {
            this.sendQuery(uRN, addressSecurityToken, gUESSEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostQueriedForGUID(GUID gUID, IpPort ipPort) {
        Map<GUID.TimedGUID, Set<IpPort>> map = this._queriedHosts;
        synchronized (map) {
            Set<IpPort> set = this._queriedHosts.get(new GUID.TimedGUID(gUID));
            return set != null ? set.contains(ipPort) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(URN uRN, AddressSecurityToken addressSecurityToken, IpPort ipPort) {
        QueryRequest queryRequest = this.queryRequestFactory.createQueryKeyQuery(uRN, addressSecurityToken);
        GUID gUID = new GUID(queryRequest.getGUID());
        Map<GUID.TimedGUID, Set<IpPort>> map = this._queriedHosts;
        synchronized (map) {
            GUID.TimedGUID timedGUID = new GUID.TimedGUID(gUID, 30000L);
            IpPortSet ipPortSet = this._queriedHosts.get(timedGUID);
            if (ipPortSet == null) {
                ipPortSet = new IpPortSet();
            }
            ipPortSet.add((IpPort)ipPort);
            this._queriedHosts.put(timedGUID, ipPortSet);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending query with GUID: " + gUID + " for URN: " + uRN + " to host: " + ipPort);
        }
        this.messageRouter.get().originateQueryGUID(queryRequest.getGUID());
        this.udpService.send(queryRequest, ipPort.getInetAddress(), ipPort.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearDataStructures(long l, long l2) {
        boolean bl = false;
        if (System.currentTimeMillis() - l > l2) {
            bl = true;
            this._queryKeys.clear();
        }
        Map<GUESSEndpoint, SendLaterBundle> map = this._bufferedURNs;
        synchronized (map) {
            Iterator<SendLaterBundle> iterator = this._bufferedURNs.values().iterator();
            while (iterator.hasNext()) {
                SendLaterBundle sendLaterBundle = iterator.next();
                if (!sendLaterBundle.shouldExpire()) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    private class QueriedHostsExpirer
    implements Runnable {
        private QueriedHostsExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = OnDemandUnicaster.this._queriedHosts;
            synchronized (map) {
                long l = System.currentTimeMillis();
                Iterator iterator = OnDemandUnicaster.this._queriedHosts.keySet().iterator();
                while (iterator.hasNext()) {
                    GUID.TimedGUID timedGUID = (GUID.TimedGUID)iterator.next();
                    if (!timedGUID.shouldExpire(l)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private class Expirer
    implements Runnable {
        private static final int QUERY_KEY_CLEAR_TIME = 86400000;
        private long _lastQueryKeyClearTime = System.currentTimeMillis();

        public void run() {
            if (OnDemandUnicaster.this.clearDataStructures(this._lastQueryKeyClearTime, 86400000L)) {
                this._lastQueryKeyClearTime = System.currentTimeMillis();
            }
        }
    }

    private class SendLaterBundle {
        private static final int MAX_LIFETIME = 60000;
        public final URN _queryURN;
        private final long _creationTime;

        public SendLaterBundle(URN uRN) {
            this._queryURN = uRN;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._creationTime > 60000L;
        }
    }
}

