/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.filters.AbstractIPFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.filters.MultiIPList;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.io.IP;

@Singleton
public final class LocalIPFilter
extends AbstractIPFilter {
    private static final Log LOG = LogFactory.getLog(LocalIPFilter.class);
    private volatile IPList badHosts;
    private volatile IPList goodHosts;
    private final IPList hostilesTXTHosts = new IPList();
    private final IPFilter hostileNetworkFilter;
    private final ScheduledExecutorService ipLoader;
    private volatile boolean shouldLoadHostiles;
    private volatile long whitelistings;
    private volatile long blacklistings;
    private volatile long netblockings;
    private volatile long implicitings;

    @Inject
    public LocalIPFilter(@Named(value="hostileFilter") IPFilter iPFilter, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        this.hostileNetworkFilter = iPFilter;
        this.ipLoader = scheduledExecutorService;
        File file = new File(LimeWireUtils.getRequestedUserSettingsLocation(), "hostiles.txt");
        this.shouldLoadHostiles = file.exists();
        iPFilter.refreshHosts();
        this.refreshHosts();
    }

    public void refreshHosts() {
        this.refreshHosts(null);
    }

    public void forceRefreshHosts() {
        File file = new File(LimeWireUtils.getRequestedUserSettingsLocation(), "hostiles.txt");
        this.shouldLoadHostiles = file.exists();
        this.refreshHosts(null);
    }

    public void refreshHosts(final IPFilter.IPFilterCallback iPFilterCallback) {
        Runnable runnable = new Runnable(){

            public void run() {
                LocalIPFilter.this.hostileNetworkFilter.refreshHosts();
                LocalIPFilter.this.refreshHostsImpl();
                if (iPFilterCallback != null) {
                    iPFilterCallback.ipFiltersLoaded();
                }
            }
        };
        if (!this.shouldLoadHostiles) {
            runnable.run();
        } else {
            this.ipLoader.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshHostsImpl() {
        LOG.debug("refreshing hosts");
        IPList iPList = new IPList();
        String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            iPList.add(stringArray[i]);
        }
        IPList iPList2 = new IPList();
        stringArray = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            iPList2.add(stringArray[i]);
        }
        if (this.shouldLoadHostiles) {
            this.shouldLoadHostiles = false;
            LOG.debug("loading hostiles");
            System.out.println("Loading hostiles");
            File file = new File(LimeWireUtils.getRequestedUserSettingsLocation(), "hostiles.txt");
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.hostilesTXTHosts.add(string);
                }
            }
            catch (IOException iOException) {
                try {
                    LOG.debug("iox loading hostiles", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.close(bufferedReader);
                    throw throwable;
                }
                IOUtils.close(bufferedReader);
            }
            IOUtils.close(bufferedReader);
        }
        this.badHosts = new MultiIPList(iPList, this.hostilesTXTHosts);
        System.out.println("LocalIPFilter.refreshHostsImpl() - BadHosts -> " + this.badHosts.size());
        this.goodHosts = iPList2;
    }

    public boolean hasBlacklistedHosts() {
        return FilterSettings.USE_NETWORK_FILTER.getValue() && this.hostileNetworkFilter.hasBlacklistedHosts() || !this.badHosts.isEmpty();
    }

    public int logMinDistanceTo(IP iP) {
        int n = this.badHosts.logMinDistanceTo(iP);
        if (FilterSettings.USE_NETWORK_FILTER.getValue()) {
            n = Math.min(n, this.hostileNetworkFilter.logMinDistanceTo(iP));
        }
        return n;
    }

    protected boolean allowImpl(IP iP) {
        if (this.goodHosts != null && this.goodHosts.contains(iP)) {
            ++this.whitelistings;
            return true;
        }
        if (this.badHosts != null && this.badHosts.contains(iP)) {
            ++this.blacklistings;
            return false;
        }
        if (FilterSettings.USE_NETWORK_FILTER.getValue() && !this.hostileNetworkFilter.allow(iP)) {
            ++this.netblockings;
            return false;
        }
        ++this.implicitings;
        return true;
    }

    @InspectableContainer
    private class IPFilterInspectable {
        @InspectionPoint(value="ip filter counts")
        private final Inspectable counts = new Inspectable(){

            public Object inspect() {
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("white", LocalIPFilter.this.whitelistings);
                hashMap.put("block", LocalIPFilter.this.blacklistings);
                hashMap.put("netblock", LocalIPFilter.this.netblockings);
                hashMap.put("implicit", LocalIPFilter.this.implicitings);
                return hashMap;
            }
        };

        private IPFilterInspectable() {
        }
    }
}

