/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMemento;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMementoImpl;
import com.limegroup.gnutella.downloader.serial.BTDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMementoImpl;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.OldDownloadConverter;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMemento;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMementoImpl;
import com.limegroup.gnutella.downloader.serial.conversion.DownloadConverterObjectInputStream;
import com.limegroup.gnutella.downloader.serial.conversion.SerialBTDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialBTMetaInfo;
import com.limegroup.gnutella.downloader.serial.conversion.SerialDiskManagerData;
import com.limegroup.gnutella.downloader.serial.conversion.SerialInNetworkDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialIncompleteFileManager;
import com.limegroup.gnutella.downloader.serial.conversion.SerialMagnetDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialManagedDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRequeryDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialResumeDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialTorrentFileSystem;
import com.limegroup.gnutella.downloader.serial.conversion.SerialUrlRemoteFileDesc;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldDownloadConverterImpl
implements OldDownloadConverter {
    private static Log LOG = LogFactory.getLog(OldDownloadConverterImpl.class);

    /*
     * Loose catch block
     */
    @Override
    public List<DownloadMemento> readAndConvertOldDownloads(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("file " + file + " doesn't exist!");
        }
        DownloadConverterObjectInputStream downloadConverterObjectInputStream = null;
        List list = null;
        SerialIncompleteFileManager serialIncompleteFileManager = null;
        DownloadConverterObjectInputStream.Version[] versionArray = DownloadConverterObjectInputStream.Version.values();
        for (int i = 0; i < versionArray.length; ++i) {
            try {
                downloadConverterObjectInputStream = new DownloadConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                downloadConverterObjectInputStream.deserializeVersion(versionArray[i]);
                list = (List)downloadConverterObjectInputStream.readObject();
                serialIncompleteFileManager = (SerialIncompleteFileManager)downloadConverterObjectInputStream.readObject();
            }
            catch (StreamCorruptedException streamCorruptedException) {
                LOG.debug("Unable to deserialize from version: " + (Object)((Object)versionArray[i]), streamCorruptedException);
                IOUtils.close(downloadConverterObjectInputStream);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException().initCause(classNotFoundException);
                {
                    catch (Throwable throwable) {
                        IOUtils.close(downloadConverterObjectInputStream);
                        throw throwable;
                    }
                }
            }
            IOUtils.close(downloadConverterObjectInputStream);
            break;
        }
        if (list != null && serialIncompleteFileManager != null) {
            return this.convertSerialRootsToMementos(list, serialIncompleteFileManager);
        }
        return Collections.emptyList();
    }

    private List<DownloadMemento> convertSerialRootsToMementos(List list, SerialIncompleteFileManager serialIncompleteFileManager) throws IOException {
        ArrayList<DownloadMemento> arrayList = new ArrayList<DownloadMemento>(list.size());
        for (Object e : list) {
            if (e instanceof SerialBTDownloader) {
                this.addBTDownloader(arrayList, (SerialBTDownloader)e, serialIncompleteFileManager);
                continue;
            }
            if (e instanceof SerialInNetworkDownloader) continue;
            if (e instanceof SerialMagnetDownloader) {
                this.addMagnet(arrayList, (SerialMagnetDownloader)e, serialIncompleteFileManager);
                continue;
            }
            if (e instanceof SerialResumeDownloader) {
                this.addResume(arrayList, (SerialResumeDownloader)e, serialIncompleteFileManager);
                continue;
            }
            if (e instanceof SerialRequeryDownloader) continue;
            if (e instanceof SerialManagedDownloader) {
                this.addManaged(arrayList, (SerialManagedDownloader)e, serialIncompleteFileManager);
                continue;
            }
            LOG.warn("Unable to convert read object: " + e);
        }
        return arrayList;
    }

    private void addGnutellaProperties(GnutellaDownloadMemento gnutellaDownloadMemento, Map<String, Serializable> map, List<Range> list, File file, Set<SerialRemoteFileDesc> set) {
        gnutellaDownloadMemento.setSavedBlocks(list);
        gnutellaDownloadMemento.setIncompleteFile(file);
        gnutellaDownloadMemento.setRemoteHosts(this.convertToMementos(set));
        gnutellaDownloadMemento.setContentLength(map.get("fileSize") == null ? -1L : ((Number)map.get("fileSize")).longValue());
        gnutellaDownloadMemento.setSha1Urn((URN)map.get("sha1Urn"));
        this.addCommonProperties(gnutellaDownloadMemento, map);
    }

    private void addCommonProperties(DownloadMemento downloadMemento, Map<String, Serializable> map) {
        downloadMemento.setAttributes((Map)((Object)map.get("attributes")));
        downloadMemento.setDefaultFileName((String)((Object)map.get("defaultFileName")));
        downloadMemento.setSaveFile((File)map.get("saveFile"));
    }

    private void addManaged(List<DownloadMemento> list, SerialManagedDownloader serialManagedDownloader, SerialIncompleteFileManager serialIncompleteFileManager) {
        File file = this.getIncompleteFile(serialManagedDownloader, serialIncompleteFileManager);
        List<Range> list2 = this.getRanges(file, serialIncompleteFileManager);
        GnutellaDownloadMementoImpl gnutellaDownloadMementoImpl = new GnutellaDownloadMementoImpl();
        gnutellaDownloadMementoImpl.setDownloadType(DownloaderType.MANAGED);
        this.addGnutellaProperties(gnutellaDownloadMementoImpl, serialManagedDownloader.getProperties(), list2, file, serialManagedDownloader.getRemoteFileDescs());
        list.add(gnutellaDownloadMementoImpl);
    }

    private void addResume(List<DownloadMemento> list, SerialResumeDownloader serialResumeDownloader, SerialIncompleteFileManager serialIncompleteFileManager) {
        File file = this.getIncompleteFile(serialResumeDownloader, serialIncompleteFileManager);
        List<Range> list2 = this.getRanges(file, serialIncompleteFileManager);
        serialResumeDownloader.getProperties().put("fileSize", Long.valueOf(serialResumeDownloader.getSize()));
        serialResumeDownloader.getProperties().put("sha1Urn", serialResumeDownloader.getUrn());
        serialResumeDownloader.getProperties().put("defaultFileName", (Serializable)((Object)serialResumeDownloader.getName()));
        GnutellaDownloadMementoImpl gnutellaDownloadMementoImpl = new GnutellaDownloadMementoImpl();
        gnutellaDownloadMementoImpl.setDownloadType(DownloaderType.MANAGED);
        this.addGnutellaProperties(gnutellaDownloadMementoImpl, serialResumeDownloader.getProperties(), list2, file, serialResumeDownloader.getRemoteFileDescs());
        list.add(gnutellaDownloadMementoImpl);
    }

    private void addMagnet(List<DownloadMemento> list, SerialMagnetDownloader serialMagnetDownloader, SerialIncompleteFileManager serialIncompleteFileManager) {
        File file = this.getIncompleteFile(serialMagnetDownloader, serialIncompleteFileManager);
        List<Range> list2 = this.getRanges(file, serialIncompleteFileManager);
        if (serialMagnetDownloader.getUrn() != null) {
            serialMagnetDownloader.getProperties().put("sha1Urn", serialMagnetDownloader.getUrn());
        }
        MagnetDownloadMementoImpl magnetDownloadMementoImpl = new MagnetDownloadMementoImpl();
        magnetDownloadMementoImpl.setDownloadType(DownloaderType.MAGNET);
        magnetDownloadMementoImpl.setMagnet((MagnetOptions)serialMagnetDownloader.getProperties().get("MAGNET"));
        this.addGnutellaProperties(magnetDownloadMementoImpl, serialMagnetDownloader.getProperties(), list2, file, serialMagnetDownloader.getRemoteFileDescs());
        list.add(magnetDownloadMementoImpl);
    }

    private void addBTDownloader(List<DownloadMemento> list, SerialBTDownloader serialBTDownloader, SerialIncompleteFileManager serialIncompleteFileManager) throws IOException {
        BTDownloadMementoImpl bTDownloadMementoImpl = new BTDownloadMementoImpl();
        bTDownloadMementoImpl.setDownloadType(DownloaderType.BTDOWNLOADER);
        bTDownloadMementoImpl.setBtMetaInfoMemento(this.toBTMetaInfoMemento((SerialBTMetaInfo)serialBTDownloader.getProperties().get("metainfo")));
        this.addCommonProperties(bTDownloadMementoImpl, serialBTDownloader.getProperties());
        list.add(bTDownloadMementoImpl);
    }

    private BTMetaInfoMemento toBTMetaInfoMemento(SerialBTMetaInfo serialBTMetaInfo) throws IOException {
        BTMetaInfoMementoImpl bTMetaInfoMementoImpl = new BTMetaInfoMementoImpl();
        bTMetaInfoMementoImpl.setFileSystem(this.toFileSystemMemento(serialBTMetaInfo.getFileSystem()));
        bTMetaInfoMementoImpl.setFolderData(this.toBTDiskManagerMemento(serialBTMetaInfo.getDiskManagerData()));
        bTMetaInfoMementoImpl.setHashes(serialBTMetaInfo.getHashes());
        bTMetaInfoMementoImpl.setInfoHash(serialBTMetaInfo.getInfoHash());
        bTMetaInfoMementoImpl.setPieceLength(serialBTMetaInfo.getPieceLength());
        bTMetaInfoMementoImpl.setPrivate(serialBTMetaInfo.isPrivate());
        bTMetaInfoMementoImpl.setRatio(serialBTMetaInfo.getHistoricRatio());
        try {
            bTMetaInfoMementoImpl.setTrackers(serialBTMetaInfo.getTrackers());
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException();
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        return bTMetaInfoMementoImpl;
    }

    private BTDiskManagerMemento toBTDiskManagerMemento(SerialDiskManagerData serialDiskManagerData) {
        BTDiskManagerMementoImpl bTDiskManagerMementoImpl = new BTDiskManagerMementoImpl();
        bTDiskManagerMementoImpl.setPartialBlocks(serialDiskManagerData.getPartialBlocks());
        bTDiskManagerMementoImpl.setVerifiedBlocks(serialDiskManagerData.getVerifiedBlocks());
        bTDiskManagerMementoImpl.setVerifying(serialDiskManagerData.isVerifying());
        return bTDiskManagerMementoImpl;
    }

    private TorrentFileSystemMemento toFileSystemMemento(SerialTorrentFileSystem serialTorrentFileSystem) {
        TorrentFileSystemMementoImpl torrentFileSystemMementoImpl = new TorrentFileSystemMementoImpl();
        torrentFileSystemMementoImpl.setCompleteFile(serialTorrentFileSystem.getCompleteFile());
        torrentFileSystemMementoImpl.setFiles(serialTorrentFileSystem.getFiles());
        torrentFileSystemMementoImpl.setFolders(serialTorrentFileSystem.getFolders());
        torrentFileSystemMementoImpl.setIncompleteFile(serialTorrentFileSystem.getIncompleteFile());
        torrentFileSystemMementoImpl.setName(serialTorrentFileSystem.getName());
        torrentFileSystemMementoImpl.setTotalSize(serialTorrentFileSystem.getTotalSize());
        return torrentFileSystemMementoImpl;
    }

    private List<Range> getRanges(File file, SerialIncompleteFileManager serialIncompleteFileManager) {
        List<Range> list = serialIncompleteFileManager.getBlocks().get(file);
        if (list != null) {
            ArrayList<Range> arrayList = new ArrayList<Range>(list.size());
            for (Range range : list) {
                arrayList.add(Range.createRange(range.getLow(), range.getHigh() - 1L));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private File getIncompleteFile(SerialManagedDownloader serialManagedDownloader, SerialIncompleteFileManager serialIncompleteFileManager) {
        URN uRN = this.getSha1(serialManagedDownloader);
        File file = null;
        if (serialManagedDownloader instanceof SerialResumeDownloader) {
            file = ((SerialResumeDownloader)serialManagedDownloader).getIncompleteFile();
        }
        if (uRN != null) {
            file = serialIncompleteFileManager.getHashes().get(uRN);
        }
        if (file == null) {
            Object object;
            File file2 = (File)serialManagedDownloader.getProperties().get("saveFile");
            if (file2 != null && (object = (String)((Object)serialManagedDownloader.getProperties().get("defaultFileName"))) != null) {
                file2 = new File(SharingSettings.getSaveDirectory((String)object), (String)object);
            }
            object = (Number)serialManagedDownloader.getProperties().get("fileSize");
            if (serialManagedDownloader instanceof SerialResumeDownloader) {
                object = ((SerialResumeDownloader)serialManagedDownloader).getSize();
            }
            if (file2 != null && object != null) {
                String string = CommonUtils.convertFileName(file2.getName());
                file = new File(SharingSettings.INCOMPLETE_DIRECTORY.getValue(), "T-" + ((Number)object).longValue() + "-" + string);
            }
        }
        return file;
    }

    private URN getSha1(SerialManagedDownloader serialManagedDownloader) {
        URN uRN = null;
        if (serialManagedDownloader instanceof SerialMagnetDownloader) {
            uRN = ((SerialMagnetDownloader)serialManagedDownloader).getUrn();
        } else if (serialManagedDownloader instanceof SerialResumeDownloader) {
            uRN = ((SerialResumeDownloader)serialManagedDownloader).getUrn();
        }
        if (uRN != null && !uRN.isSHA1()) {
            uRN = null;
        }
        block0: for (SerialRemoteFileDesc serialRemoteFileDesc : serialManagedDownloader.getRemoteFileDescs()) {
            if (uRN != null) break;
            for (URN uRN2 : serialRemoteFileDesc.getUrns()) {
                if (!uRN2.isSHA1()) continue;
                uRN = uRN2;
                continue block0;
            }
        }
        return uRN;
    }

    private Set<RemoteHostMemento> convertToMementos(Set<SerialRemoteFileDesc> set) {
        HashSet<RemoteHostMemento> hashSet = new HashSet<RemoteHostMemento>(set.size());
        for (SerialRemoteFileDesc serialRemoteFileDesc : set) {
            RemoteHostMemento remoteHostMemento = new RemoteHostMemento(serialRemoteFileDesc.getHost(), serialRemoteFileDesc.getPort(), serialRemoteFileDesc.getFilename(), serialRemoteFileDesc.getIndex(), serialRemoteFileDesc.getClientGUID(), serialRemoteFileDesc.getSpeed(), serialRemoteFileDesc.getSize(), serialRemoteFileDesc.isChatEnabled(), serialRemoteFileDesc.getQuality(), serialRemoteFileDesc.isReplyToMulticast(), serialRemoteFileDesc.getXml(), serialRemoteFileDesc.getUrns(), serialRemoteFileDesc.isBrowseHostEnabled(), serialRemoteFileDesc.isFirewalled(), serialRemoteFileDesc.getVendor(), serialRemoteFileDesc.isHttp11(), serialRemoteFileDesc.isTlsCapable(), serialRemoteFileDesc.getHttpPushAddr());
            if (serialRemoteFileDesc instanceof SerialUrlRemoteFileDesc) {
                remoteHostMemento.setCustomUrl(((SerialUrlRemoteFileDesc)serialRemoteFileDesc).getUrl());
            }
            hashSet.add(remoteHostMemento);
        }
        return hashSet;
    }
}

