/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueForSelf;
import com.limegroup.gnutella.messages.GGEP;
import java.util.Arrays;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.util.ByteOrder;

public abstract class AbstractAltLocValue
implements AltLocValue {
    public static final DHTValueType ALT_LOC = DHTValueType.valueOf("Gnutella Alternate Location", "ALOC");
    public static final Version VERSION_ONE;
    public static final Version VERSION;
    static final String CLIENT_ID = "client-id";
    static final String PORT = "port";
    static final String FIREWALLED = "firewalled";
    static final String LENGTH = "length";
    static final String TTROOT = "ttroot";
    static final String TLS = "tls";
    protected final Version version;

    public AbstractAltLocValue(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public DHTValueType getValueType() {
        return ALT_LOC;
    }

    public int size() {
        return this.getValue().length;
    }

    public abstract byte[] getGUID();

    public abstract int getPort();

    public abstract long getFileSize();

    public abstract byte[] getRootHash();

    public abstract boolean isFirewalled();

    public abstract boolean supportsTLS();

    public boolean equals(Object object) {
        if (!(object instanceof AltLocValue)) {
            return false;
        }
        AltLocValue altLocValue = (AltLocValue)object;
        return this.getFileSize() == altLocValue.getFileSize() && Arrays.equals(this.getGUID(), altLocValue.getGUID()) && this.getPort() == altLocValue.getPort() && Arrays.equals(this.getRootHash(), altLocValue.getRootHash()) && Arrays.equals(this.getValue(), altLocValue.getValue()) && this.getValueType().equals(altLocValue.getValueType()) && this.getVersion().equals(altLocValue.getVersion());
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (int)this.getFileSize();
        n = 31 * n + this.getPort();
        n = 31 * n + this.getGUID().hashCode();
        n = 31 * n + this.getRootHash().hashCode();
        n = 31 * n + this.getValue().hashCode();
        n = 31 * n + this.getValueType().hashCode();
        n = 31 * n + this.getVersion().hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AltLoc: guid=").append(new GUID(this.getGUID())).append(", port=").append(this.getPort()).append(", firewalled=").append(this.isFirewalled()).append(", tls=").append(this.supportsTLS()).append(", fileSize=").append(this.getFileSize()).append(", ttroot=").append(this.getRootHash() != null ? ArrayUtils.toHexString(this.getRootHash()) : "null");
        if (this instanceof AltLocValueForSelf) {
            stringBuilder.append(", local=true");
        }
        return stringBuilder.toString();
    }

    protected static byte[] serialize(AbstractAltLocValue abstractAltLocValue) {
        Version version = abstractAltLocValue.getVersion();
        GGEP gGEP = new GGEP();
        gGEP.put(CLIENT_ID, abstractAltLocValue.getGUID());
        byte[] byArray = new byte[2];
        ByteOrder.short2beb((short)abstractAltLocValue.getPort(), byArray, 0);
        gGEP.put(PORT, byArray);
        byte[] byArray2 = new byte[]{(byte)(abstractAltLocValue.isFirewalled() ? 1 : 0)};
        gGEP.put(FIREWALLED, byArray2);
        if (version.compareTo(VERSION_ONE) >= 0) {
            gGEP.put(LENGTH, abstractAltLocValue.getFileSize());
            byte[] byArray3 = abstractAltLocValue.getRootHash();
            if (byArray3 != null) {
                gGEP.put(TTROOT, byArray3);
            }
            if (abstractAltLocValue.supportsTLS()) {
                gGEP.put(TLS);
            }
        }
        return gGEP.toByteArray();
    }

    static {
        VERSION = VERSION_ONE = Version.valueOf(1);
    }
}

