/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.messages.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;

public class MessageWriter
implements ChannelWriter,
OutputRunner {
    private final MessageQueue queue;
    private final ByteBufferOutputStream out;
    private final ConnectionStats stats;
    private final SentMessageHandler sendHandler;
    private InterestWritableByteChannel channel;
    private boolean flipped = false;
    private boolean shutdown = false;

    public MessageWriter(ConnectionStats connectionStats, MessageQueue messageQueue, SentMessageHandler sentMessageHandler) {
        this(connectionStats, messageQueue, sentMessageHandler, null);
    }

    public MessageWriter(ConnectionStats connectionStats, MessageQueue messageQueue, SentMessageHandler sentMessageHandler, InterestWritableByteChannel interestWritableByteChannel) {
        this.stats = connectionStats;
        this.queue = messageQueue;
        this.sendHandler = sentMessageHandler;
        this.channel = interestWritableByteChannel;
        this.out = new ByteBufferOutputStream();
    }

    public synchronized InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public synchronized void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.channel = interestWritableByteChannel;
        interestWritableByteChannel.interestWrite(this, true);
    }

    public synchronized void send(Message message) {
        if (this.shutdown) {
            return;
        }
        this.stats.addSent(message);
        this.queue.add(message);
        int n = this.queue.resetDropped();
        this.stats.addSentDropped(n);
        if (this.channel != null) {
            this.channel.interestWrite(this, true);
        }
    }

    public synchronized boolean handleWrite() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        if (this.writeRemaining()) {
            return true;
        }
        do {
            Message message = this.queue.removeNext();
            int n = this.queue.resetDropped();
            this.stats.addSentDropped(n);
            if (message == null) {
                this.channel.interestWrite(this, false);
                return false;
            }
            message.writeQuickly(this.out);
            this.sendHandler.processSentMessage(message);
        } while (!this.writeRemaining());
        return true;
    }

    private boolean writeRemaining() throws IOException {
        if (this.shutdown) {
            throw new IOException("connection shut down.");
        }
        ByteBuffer byteBuffer = this.out.getBuffer();
        if (this.flipped || byteBuffer.position() > 0) {
            if (!this.flipped) {
                byteBuffer.flip();
                this.flipped = true;
            }
            this.channel.write(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            byteBuffer.clear();
        }
        return false;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public Object inspect() {
        return this.queue.getDroppedStats();
    }
}

