/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.SimpleReadHeaderState;
import com.limegroup.gnutella.http.SimpleWriteHeaderState;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.limewire.io.IOUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.channel.AbstractBufferChannelWriter;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantMessengerImpl
implements InstantMessenger {
    private static final Log LOG = LogFactory.getLog(InstantMessengerImpl.class);
    private static final String CHAT_CONNECT = "CHAT CONNECT/0.1";
    private static final String CHAT_OK = "CHAT/0.1 200 OK";
    private static final String CONNECT = "CONNECT/0.1";
    private static final String CHARSET = "UTF-8";
    private final String host;
    private final int port;
    private final boolean outgoing;
    private final ActivityCallback callback;
    private final Object connectionLock = new Object();
    private Socket socket;
    private MessageReceiver receiver;
    private MessageSender sender;
    private boolean stopped;
    private final SocketsManager socketsManager;

    InstantMessengerImpl(Socket socket, ActivityCallback activityCallback) {
        if (socket == null || activityCallback == null) {
            throw new IllegalArgumentException();
        }
        this.socket = socket;
        this.port = socket.getPort();
        this.host = socket.getInetAddress().getHostAddress();
        this.callback = activityCallback;
        this.socketsManager = null;
        this.outgoing = false;
    }

    InstantMessengerImpl(String string, int n, ActivityCallback activityCallback, SocketsManager socketsManager) {
        if (string == null || activityCallback == null) {
            throw new IllegalArgumentException();
        }
        this.host = string;
        this.port = n;
        this.callback = activityCallback;
        this.socketsManager = socketsManager;
        this.outgoing = true;
    }

    @Override
    public void start() {
        if (this.outgoing) {
            try {
                this.socketsManager.connect(new InetSocketAddress(this.host, this.port), 8000, new ConnectObserver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleConnect(Socket socket) throws IOException {
                        Object object = InstantMessengerImpl.this.connectionLock;
                        synchronized (object) {
                            InstantMessengerImpl.this.socket = socket;
                            InstantMessengerImpl.this.shake(InstantMessengerImpl.this.createOutgoingShakeStates());
                        }
                    }

                    public void handleIOException(IOException iOException) {
                        LOG.error("Unexpected exception", iOException);
                        InstantMessengerImpl.this.handleException(iOException);
                    }

                    public void shutdown() {
                        LOG.warn("Could not establish chat connection to " + InstantMessengerImpl.this.host + ":" + InstantMessengerImpl.this.port);
                        InstantMessengerImpl.this.stop();
                    }
                });
            }
            catch (IOException iOException) {
                LOG.warn("Unexpected exception", iOException);
                this.handleException(iOException);
            }
        } else {
            this.shake(this.createIncomingShakeStates());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(String string) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.stopped || this.sender == null) {
                return false;
            }
        }
        try {
            this.sender.sendMessage(string + "\n");
        }
        catch (BufferOverflowException bufferOverflowException) {
            return false;
        }
        catch (IOException iOException) {
            this.stop();
            return false;
        }
        return true;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private List<IOState> createIncomingShakeStates() {
        ArrayList<IOState> arrayList = new ArrayList<IOState>(3);
        List list = Collections.emptyList();
        arrayList.add(new ReadChatConnectHeaderState());
        arrayList.add(new SimpleWriteHeaderState(CHAT_OK, list, null));
        arrayList.add(new ReadChatHeaderState());
        return arrayList;
    }

    private List<IOState> createOutgoingShakeStates() {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        arrayList.add(HTTPHeaderName.USER_AGENT.create(LimeWireUtils.getVendor()));
        List list = Collections.emptyList();
        ArrayList<IOState> arrayList2 = new ArrayList<IOState>(3);
        arrayList2.add(new SimpleWriteHeaderState(CHAT_CONNECT, arrayList, null));
        arrayList2.add(new ReadChatHeaderState());
        arrayList2.add(new SimpleWriteHeaderState(CHAT_OK, list, null));
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeCompleted() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.socket.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                LOG.warn("Could not set socket timeout", socketException);
            }
            this.receiver = new MessageReceiver();
            this.sender = new MessageSender();
            ((NIOMultiplexor)((Object)this.socket)).setReadObserver(this.receiver);
            ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(this.sender);
        }
        this.callback.acceptChat(this);
        object = this.connectionLock;
        synchronized (object) {
            this.connectionLock.notifyAll();
        }
    }

    private void handleException(IOException iOException) {
        this.callback.chatErrorMessage(this, iOException.getMessage());
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shake(List<IOState> list) {
        IOStateMachine iOStateMachine = new IOStateMachine(new IOStateObserver(){

            public void handleStatesFinished() {
                InstantMessengerImpl.this.handshakeCompleted();
            }

            public void handleIOException(IOException iOException) {
                InstantMessengerImpl.this.handleException(iOException);
            }

            public void shutdown() {
                InstantMessengerImpl.this.stop();
            }
        }, list);
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            try {
                this.socket.setSoTimeout(8000);
            }
            catch (SocketException socketException) {
                LOG.warn("Could not set socket timeout", socketException);
            }
            ((NIOMultiplexor)((Object)this.socket)).setReadObserver(iOStateMachine);
            ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(iOStateMachine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnect(long l) throws InterruptedException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (!(this.stopped || this.socket != null && this.socket.isConnected())) {
                this.connectionLock.wait(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.socket != null && !this.socket.isClosed()) {
                IOUtils.close(this.socket);
            }
            this.connectionLock.notifyAll();
        }
        this.callback.chatUnavailable(this);
    }

    @Override
    public boolean isOutgoing() {
        return this.outgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.connectionLock;
        synchronized (object) {
            return !this.stopped;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[host=" + this.host + ":" + this.port + ",outgoing=" + this.outgoing + "]";
    }

    private class ReadChatHeaderState
    extends SimpleReadHeaderState {
        public ReadChatHeaderState() {
            super(null, ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue(), ConnectionSettings.MAX_HANDSHAKE_LINE_SIZE.getValue());
        }

        protected void processConnectLine() throws IOException {
            if (!InstantMessengerImpl.CHAT_OK.equals(this.connectLine)) {
                throw new IOException("Invalid handshake: " + this.connectLine);
            }
        }
    }

    private class ReadChatConnectHeaderState
    extends SimpleReadHeaderState {
        public ReadChatConnectHeaderState() {
            super(null, ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue(), ConnectionSettings.MAX_HANDSHAKE_LINE_SIZE.getValue());
        }

        protected void processConnectLine() throws IOException {
            if (!InstantMessengerImpl.CONNECT.equals(this.connectLine)) {
                throw new IOException("Invalid handshake: " + this.connectLine);
            }
        }
    }

    private class MessageSender
    extends AbstractBufferChannelWriter {
        public MessageSender() {
            super(1024);
        }

        public void handleIOException(IOException iOException) {
            InstantMessengerImpl.this.handleException(iOException);
        }

        public void sendMessage(String string) throws IOException {
            this.put(string.getBytes(InstantMessengerImpl.CHARSET));
        }

        public void shutdown() {
            super.shutdown();
            InstantMessengerImpl.this.stop();
        }
    }

    private class MessageReceiver
    extends AbstractChannelInterestReader {
        public MessageReceiver() {
            super(1024);
        }

        public void handleIOException(IOException iOException) {
            InstantMessengerImpl.this.handleException(iOException);
        }

        public void handleRead() throws IOException {
            int n = 0;
            while (this.buffer.hasRemaining() && (n = this.source.read(this.buffer)) > 0) {
            }
            this.flushBuffer();
            if (n == -1) {
                InstantMessengerImpl.this.stop();
            }
        }

        private void flushBuffer() {
            this.buffer.flip();
            StringBuilder stringBuilder = new StringBuilder();
            while (BufferUtils.readLine(this.buffer, stringBuilder)) {
                InstantMessengerImpl.this.callback.receiveMessage(InstantMessengerImpl.this, stringBuilder.toString());
            }
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
        }

        public void shutdown() {
            super.shutdown();
            InstantMessengerImpl.this.stop();
        }
    }
}

