/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.DeadlockException;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class DeadlockBugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;

    private DeadlockBugManager() {
    }

    public static void handleDeadlock(DeadlockException deadlockException, String string, String string2) {
        deadlockException.printStackTrace();
        System.err.println("Detail: " + string2);
        LocalClientInfo localClientInfo = localClientInfoFactory.createLocalClientInfo(deadlockException, string, string2, false);
        if (DeadlockBugManager.isSendableVersion() && (LimeWireUtils.isBetaRelease() || BugSettings.SEND_DEADLOCK_BUGS.getValue())) {
            DeadlockBugManager.sendToServlet(localClientInfo);
        }
    }

    private static boolean isSendableVersion() {
        Version version;
        Version version2;
        try {
            version2 = new Version(LimeWireUtils.getFrostWireVersion());
            version = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException versionFormatException) {
            return false;
        }
        return version2.compareTo(version) >= 0;
    }

    private static void sendToServlet(LocalClientInfo localClientInfo) {
        new ServletAccessor(false).getRemoteBugInfo(localClientInfo);
    }
}

