/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.MagnetHTML;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.BasicHttpAcceptor;

@Singleton
public class LocalHTTPAcceptor
extends BasicHttpAcceptor {
    private static final Log LOG = LogFactory.getLog(LocalHTTPAcceptor.class);
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "HEAD"};
    private static final String MAGNET = "magnet:?";
    private static final String MAGNET_DETAIL = "magcmd/detail?";
    private String lastCommand;
    private long lastCommandTime;
    private long MIN_REQUEST_INTERVAL = 1500L;
    private final ExternalControl externalControl;

    @Inject
    public LocalHTTPAcceptor(ExternalControl externalControl) {
        super(LocalHTTPAcceptor.createDefaultParams(LimeWireUtils.getHttpServer(), 8000), SUPPORTED_METHODS);
        this.externalControl = externalControl;
        this.registerHandler("magnet:", new MagnetCommandRequestHandler());
        this.registerHandler("/magnet10/default.js", new MagnetCommandRequestHandler());
        this.registerHandler("/magnet10/pause", new MagnetPauseRequestHandler());
        this.registerHandler("/magcmd/detail", new MagnetDetailRequestHandler());
    }

    private synchronized void triggerMagnetHandling(String string) throws IOException {
        int n = string.indexOf("?");
        if (n == -1) {
            throw new IOException("Invalid command");
        }
        String string2 = string.substring(n + 1);
        long l = System.currentTimeMillis();
        if (!string2.equals(this.lastCommand) || l - this.lastCommandTime >= this.MIN_REQUEST_INTERVAL) {
            this.externalControl.handleMagnetRequest(MAGNET + string2);
            this.lastCommand = string2;
            this.lastCommandTime = l;
        } else {
            LOG.warn("Ignoring duplicate request: " + string2);
        }
    }

    private class MagnetDetailRequestHandler
    extends SimpleNHttpRequestHandler {
        private MagnetDetailRequestHandler() {
        }

        public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
            return null;
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            String string = httpRequest.getRequestLine().getUri();
            int n = string.indexOf(LocalHTTPAcceptor.MAGNET_DETAIL);
            String string2 = string.substring(n + LocalHTTPAcceptor.MAGNET_DETAIL.length());
            String string3 = MagnetHTML.buildMagnetDetailPage(string2);
            StringEntity stringEntity = new StringEntity(string3);
            stringEntity.setContentType("text/html");
            httpResponse.setEntity(stringEntity);
        }
    }

    private class MagnetPauseRequestHandler
    extends SimpleNHttpRequestHandler {
        private MagnetPauseRequestHandler() {
        }

        public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
            return null;
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            httpResponse.setStatusCode(204);
        }
    }

    private class MagnetCommandRequestHandler
    extends SimpleNHttpRequestHandler {
        private MagnetCommandRequestHandler() {
        }

        public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
            return null;
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            LocalHTTPAcceptor.this.triggerMagnetHandling(httpRequest.getRequestLine().getUri());
        }
    }
}

