/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageHandlerBinder;
import com.limegroup.gnutella.MessageRouterImpl;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messagehandlers.InspectionRequestHandler;
import com.limegroup.gnutella.messagehandlers.OOBHandler;
import com.limegroup.gnutella.messagehandlers.UDPCrawlerPingHandler;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessageFactory;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandlerFactory;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Connectable;
import org.limewire.io.IPPortCombo;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class StandardMessageRouter
extends MessageRouterImpl {
    private static final Log LOG = LogFactory.getLog(StandardMessageRouter.class);
    private final Statistics statistics;
    private final ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory;

    @Inject
    public StandardMessageRouter(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, QueryHandlerFactory queryHandlerFactory, OnDemandUnicaster onDemandUnicaster, HeadPongFactory headPongFactory, PingReplyFactory pingReplyFactory, ConnectionManager connectionManager, @Named(value="forMeReplyHandler") ReplyHandler replyHandler, QueryUnicaster queryUnicaster, FileManager fileManager, ContentManager contentManager, DHTManager dHTManager, UploadManager uploadManager, DownloadManager downloadManager, UDPService uDPService, SearchResultHandler searchResultHandler, SocketsManager socketsManager, HostCatcher hostCatcher, QueryReplyFactory queryReplyFactory, StaticMessages staticMessages, Provider<MessageDispatcher> provider, MulticastService multicastService, QueryDispatcher queryDispatcher, Provider<ActivityCallback> provider2, ConnectionServices connectionServices, ApplicationServices applicationServices, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<PongCacher> provider3, Provider<UpdateHandler> provider4, GuidMapManager guidMapManager, UDPReplyHandlerCache uDPReplyHandlerCache, Provider<InspectionRequestHandler> provider5, Provider<UDPCrawlerPingHandler> provider6, Statistics statistics, ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory, PingRequestFactory pingRequestFactory, MessageHandlerBinder messageHandlerBinder, Provider<OOBHandler> provider7, Provider<MACCalculatorRepositoryManager> provider8) {
        super(networkManager, queryRequestFactory, queryHandlerFactory, onDemandUnicaster, headPongFactory, pingReplyFactory, connectionManager, replyHandler, queryUnicaster, fileManager, contentManager, dHTManager, uploadManager, downloadManager, uDPService, searchResultHandler, socketsManager, hostCatcher, queryReplyFactory, staticMessages, provider, multicastService, queryDispatcher, provider2, connectionServices, applicationServices, scheduledExecutorService, provider3, provider4, guidMapManager, uDPReplyHandlerCache, provider5, provider6, pingRequestFactory, messageHandlerBinder, provider7, provider8);
        this.statistics = statistics;
        this.replyNumberVendorMessageFactory = replyNumberVendorMessageFactory;
    }

    @Override
    protected void respondToPingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        Object object;
        byte by;
        byte by2 = pingRequest.getHops();
        if (by2 + (by = pingRequest.getTTL()) > 2 && !this.connectionManager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(this.networkManager.getAddress()) && NetworkUtils.isValidPort(this.networkManager.getPort())) {
            if (by2 == 1 && by == 1) {
                this.handleCrawlerPing(pingRequest, replyHandler);
                return;
            }
            if (pingRequest.isHeartbeat()) {
                this.sendPingReply(this.pingReplyFactory.create(pingRequest.getGUID(), (byte)1), replyHandler);
                return;
            }
            int n = by2 + 1;
            if (by2 + by <= 2) {
                n = 1;
            }
            if (this.connectionManager.hasFreeSlots() || this.statistics.calculateDailyUptime() > 1800) {
                object = this.pingReplyFactory.create(pingRequest.getGUID(), (byte)n);
                this.sendPingReply((PingReply)object, replyHandler);
            }
        }
        List<PingReply> list = ((PongCacher)this.pongCacher.get()).getBestPongs(pingRequest.getLocale());
        object = pingRequest.getGUID();
        InetAddress inetAddress = replyHandler.getInetAddress();
        for (PingReply pingReply : list) {
            if (pingReply.getInetAddress().equals(inetAddress)) continue;
            this.sendPingReply(this.pingReplyFactory.mutateGUID(pingReply, (byte[])object), replyHandler);
        }
    }

    @Override
    protected void respondToUDPPingRequest(PingRequest pingRequest, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        if (!this.networkManager.isIpPortValid()) {
            return;
        }
        IPPortCombo iPPortCombo = null;
        if (pingRequest.requestsIP()) {
            try {
                iPPortCombo = new IPPortCombo(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        List<Object> list = Collections.emptyList();
        int n = ConnectionSettings.NUM_RETURN_PONGS.getValue();
        if (pingRequest.requestsDHTIPP() && this.dhtManager.isRunning()) {
            list = this.dhtManager.getActiveDHTNodes(n);
        }
        int n2 = list.size();
        byte[] byArray = pingRequest.getSupportsCachedPongData();
        Collection<Object> collection = Collections.emptyList();
        if (byArray != null) {
            boolean bl = byArray.length >= 1 && (byArray[0] & 1) == 1;
            int n3 = ConnectionSettings.DHT_TO_GNUT_HOSTS_PONG.getValue();
            int n4 = Math.round((float)n3 / 100.0f * (float)n);
            collection = this.connectionServices.getPreferencedHosts(bl, pingRequest.getLocale(), n - Math.min(n2, n4));
            list = list.subList(0, Math.min(n2, n - collection.size()));
        }
        PingReply pingReply = iPPortCombo != null ? this.pingReplyFactory.create(pingRequest.getGUID(), (byte)1, iPPortCombo, collection, list) : this.pingReplyFactory.create(pingRequest.getGUID(), (byte)1, collection, list);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Responding to UDPPingRequest " + (pingRequest.requestsDHTIPP() ? "with DHTIPP " : "") + "from : " + inetSocketAddress + " with Gnutella hosts: \n" + collection + "\n and DHT hosts: \n" + list);
        }
        this.sendPingReply(pingReply, replyHandler);
    }

    private void handleCrawlerPing(PingRequest pingRequest, ReplyHandler replyHandler) {
        List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
        for (RoutedConnection routedConnection : list) {
            PingReply pingReply = this.pingReplyFactory.createExternal(pingRequest.getGUID(), (byte)2, routedConnection.getPort(), routedConnection.getInetAddress().getAddress(), false);
            pingReply.hop();
            this.sendPingReply(pingReply, replyHandler);
        }
    }

    @Override
    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] byArray, ReplyHandler replyHandler) {
        if (!FeatureSearchData.supportsFeature(queryRequest.getFeatureSelector())) {
            return false;
        }
        if (!this.uploadManager.mayBeServiceable()) {
            return false;
        }
        if (!NetworkUtils.isValidPort(this.networkManager.getPort()) || !NetworkUtils.isValidAddress(this.networkManager.getAddress())) {
            return false;
        }
        Response[] responseArray = this.fileManager.query(queryRequest);
        return this.sendResponses(responseArray, queryRequest, replyHandler);
    }

    private boolean sendResponses(Response[] responseArray, QueryRequest queryRequest, ReplyHandler replyHandler) {
        Object object;
        if (responseArray == null || responseArray.length < 1) {
            return false;
        }
        if (!this.uploadManager.isServiceable()) {
            object = new ArrayList(responseArray.length);
            for (Response object2 : responseArray) {
                if (!object2.isMetaFile() || !this.fileManager.isFileApplicationShared(object2.getName())) continue;
                object.add((Object)object2);
            }
            if (object.isEmpty()) {
                return false;
            }
            if (object.size() != responseArray.length) {
                responseArray = object.toArray((Response[])new Response[object.size()]);
            }
        }
        if (queryRequest.desiresOutOfBandReplies() && !this.isConnectedTo(queryRequest, replyHandler) && this.networkManager.canReceiveSolicited() && NetworkUtils.isValidAddressAndPort(queryRequest.getReplyAddress(), queryRequest.getReplyPort())) {
            if (this.bufferResponsesForLaterDelivery(queryRequest, responseArray)) {
                object = null;
                try {
                    object = InetAddress.getByName(queryRequest.getReplyAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                int n = queryRequest.getReplyPort();
                if (object != null) {
                    int n2 = responseArray.length > 255 ? 255 : responseArray.length;
                    final ReplyNumberVendorMessage replyNumberVendorMessage = queryRequest.desiresOutOfBandRepliesV3() ? this.replyNumberVendorMessageFactory.createV3ReplyNumberVendorMessage(new GUID(queryRequest.getGUID()), n2) : this.replyNumberVendorMessageFactory.createV2ReplyNumberVendorMessage(new GUID(queryRequest.getGUID()), n2);
                    this.udpService.send(replyNumberVendorMessage, (InetAddress)object, n);
                    if (MessageSettings.OOB_REDUNDANCY.getValue() && queryRequest.desiresOutOfBandRepliesV3()) {
                        Object object2 = object;
                        this.backgroundExecutor.schedule(new Runnable((InetAddress)object2, n){
                            final /* synthetic */ InetAddress val$addrf;
                            final /* synthetic */ int val$port;
                            {
                                this.val$addrf = inetAddress;
                                this.val$port = n;
                            }

                            public void run() {
                                StandardMessageRouter.this.udpService.send(replyNumberVendorMessage, this.val$addrf, this.val$port);
                            }
                        }, 100L, TimeUnit.MILLISECONDS);
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        object = this.responsesToQueryReplies(responseArray, queryRequest);
        try {
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private final boolean isConnectedTo(QueryRequest queryRequest, ReplyHandler replyHandler) {
        return queryRequest.matchesReplyAddress(replyHandler.getInetAddress().getAddress());
    }

    @Override
    protected List<QueryReply> createQueryReply(byte[] byArray, byte by, long l, Response[] responseArray, byte[] byArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, SecurityToken securityToken) {
        Set<Connectable> set;
        String string;
        ArrayList<QueryReply> arrayList = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int n = -1;
        byte[] byArray3 = null;
        if (bl4) {
            byArray3 = this.networkManager.getNonForcedAddress();
            n = this.networkManager.getNonForcedPort();
            if (!NetworkUtils.isValidPort(n) || !NetworkUtils.isValidAddress(byArray3)) {
                bl4 = false;
            }
        }
        if (!bl4) {
            if (bl5) {
                n = this.udpService.getStableUDPPort();
                byArray3 = this.networkManager.getExternalAddress();
                if (!NetworkUtils.isValidAddress(byArray3) || !NetworkUtils.isValidPort(n)) {
                    bl5 = false;
                }
            }
            if (!bl5) {
                byArray3 = this.networkManager.getAddress();
                n = this.networkManager.getPort();
                if (!NetworkUtils.isValidAddress(byArray3) || !NetworkUtils.isValidPort(n)) {
                    return Collections.emptyList();
                }
            }
        }
        if ((string = LimeXMLDocumentHelper.getAggregateString(responseArray)) == null) {
            string = "";
        }
        byte[] byArray4 = null;
        try {
            byArray4 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        boolean bl6 = !this.networkManager.acceptedIncomingConnection();
        Set<Connectable> set2 = set = bl6 ? this.connectionManager.getPushProxies() : null;
        if (byArray4.length > 32768) {
            LinkedList<Response[]> linkedList = new LinkedList<Response[]>();
            this.splitAndAddResponses(linkedList, responseArray);
            while (!linkedList.isEmpty()) {
                Response[] responseArray2 = (Response[])linkedList.remove(0);
                String string2 = LimeXMLDocumentHelper.getAggregateString(responseArray2);
                byte[] byArray5 = null;
                try {
                    byArray5 = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException(unsupportedEncodingException);
                }
                if (byArray5.length > 32768 && responseArray2.length > 1) {
                    this.splitAndAddResponses(linkedList, responseArray2);
                    continue;
                }
                byte[] byArray6 = null;
                byArray6 = !string2.equals("") ? LimeXMLUtils.compress(byArray5) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = this.queryReplyFactory.createQueryReply(byArray, by, n, byArray3, l, responseArray2, this._clientGUID, byArray6, bl6, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, bl5, set, securityToken);
                arrayList.add(queryReply);
            }
        } else {
            byte[] byArray7 = null;
            byArray7 = !string.equals("") ? LimeXMLUtils.compress(byArray4) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = this.queryReplyFactory.createQueryReply(byArray, by, n, byArray3, l, responseArray, this._clientGUID, byArray7, bl6, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, bl5, set, securityToken);
            arrayList.add(queryReply);
        }
        return arrayList;
    }

    private Response[][] splitResponses(Response[] responseArray) {
        int n;
        int n2 = responseArray.length / 2;
        Response[][] responseArray2 = new Response[][]{new Response[n2], new Response[responseArray.length - n2]};
        for (n = 0; n < n2; ++n) {
            responseArray2[0][n] = responseArray[n];
        }
        for (n = 0; n < responseArray.length - n2; ++n) {
            responseArray2[1][n] = responseArray[n + n2];
        }
        return responseArray2;
    }

    private void splitAndAddResponses(List<Response[]> list, Response[] responseArray) {
        Response[][] responseArray2 = this.splitResponses(responseArray);
        list.add(responseArray2[0]);
        list.add(responseArray2[1]);
    }
}

