/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;

@Singleton
public class LimeCoreGlue {
    private static final Log LOG = LogFactory.getLog(LimeCoreGlue.class);
    private static AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);

    @Inject
    public LimeCoreGlue() {
    }

    public static void preinstall() throws InstallFailedException {
        LimeCoreGlue.preinstall(LimeWireUtils.getRequestedUserSettingsLocation());
    }

    public static void preinstall(File file) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        try {
            CommonUtils.setUserSettingsDir(file);
        }
        catch (IOException iOException) {
            try {
                File file2;
                LimeWireUtils.clearTemporarySettingsDirectories();
                try {
                    file2 = LimeWireUtils.getTemporarySettingsDirectory();
                }
                catch (IOException iOException2) {
                    iOException2.initCause(iOException);
                    throw iOException2;
                }
                file2.deleteOnExit();
                try {
                    CommonUtils.setUserSettingsDir(file2);
                }
                catch (IOException iOException3) {
                    iOException3.initCause(iOException);
                    throw iOException3;
                }
                LimeWireUtils.setTemporaryDirectoryInUse(true);
            }
            catch (IOException iOException4) {
                throw new InstallFailedException("Settings Directory Failure", iOException4);
            }
        }
    }

    public void install() {
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
    }

    public static class InstallFailedException
    extends RuntimeException {
        public InstallFailedException() {
        }

        public InstallFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InstallFailedException(String string) {
            super(string);
        }

        public InstallFailedException(Throwable throwable) {
            super(throwable);
        }
    }
}

