/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RequestCache;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.http.HttpContextParams;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.uploader.FileRequestHandler;
import com.limegroup.gnutella.uploader.FreeLoaderRequestHandler;
import com.limegroup.gnutella.uploader.HTTPUploadSession;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.PushProxyRequestHandler;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.Buffer;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.util.FileLocker;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HTTPUploadManager
implements FileLocker,
BandwidthTracker,
UploadManager,
HTTPUploadSessionManager {
    private static final String SESSION_KEY = "org.limewire.session";
    private static final Log LOG = LogFactory.getLog(HTTPUploadManager.class);
    private List<HTTPUploader> activeUploadList = new LinkedList<HTTPUploader>();
    private final UploadSlotManager slotManager;
    private volatile boolean hadSuccesfulUpload = false;
    private int forcedUploads;
    private final FreeLoaderRequestHandler freeLoaderRequestHandler;
    private final ResponseListener responseListener = new ResponseListener();
    private final Set<HTTPUploader> localUploads = new CopyOnWriteArraySet<HTTPUploader>();
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    public static final int TRANSFER_SOCKET_TIMEOUT = 120000;
    private Buffer<Integer> speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private final Map<String, RequestCache> REQUESTS = new FixedsizeForgetfulHashMap<String, RequestCache>(250);
    private volatile Provider<ActivityCallback> activityCallback;
    private volatile Provider<FileManager> fileManager;
    private volatile boolean started;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<ContentManager> contentManager;
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;

    @Inject
    public HTTPUploadManager(UploadSlotManager uploadSlotManager, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<ContentManager> provider, Provider<HTTPAcceptor> provider2, Provider<FileManager> provider3, Provider<ActivityCallback> provider4, TcpBandwidthStatistics tcpBandwidthStatistics) {
        this.slotManager = Objects.nonNull(uploadSlotManager, "slotManager");
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.contentManager = provider;
        this.freeLoaderRequestHandler = httpRequestHandlerFactory.createFreeLoaderRequestHandler();
        this.httpAcceptor = Objects.nonNull(provider2, "httpAcceptor");
        this.fileManager = Objects.nonNull(provider3, "fileManager");
        this.activityCallback = Objects.nonNull(provider4, "activityCallback");
        this.tcpBandwidthStatistics = Objects.nonNull(tcpBandwidthStatistics, "tcpBandwidthStatistics");
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException();
        }
        FileUtils.addFileLocker(this);
        this.httpAcceptor.get().addAcceptorListener(this.responseListener);
        this.httpAcceptor.get().registerHandler("/", this.httpRequestHandlerFactory.createBrowseRequestHandler());
        PushProxyRequestHandler pushProxyRequestHandler = this.httpRequestHandlerFactory.createPushProxyRequestHandler();
        this.httpAcceptor.get().registerHandler("/gnutella/push-proxy", pushProxyRequestHandler);
        this.httpAcceptor.get().registerHandler("/gnet/push-proxy", pushProxyRequestHandler);
        FileRequestHandler fileRequestHandler = this.httpRequestHandlerFactory.createFileRequestHandler();
        this.httpAcceptor.get().registerHandler("/get*", fileRequestHandler);
        this.httpAcceptor.get().registerHandler("/uri-res/*", fileRequestHandler);
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        this.httpAcceptor.get().unregisterHandler("/");
        this.httpAcceptor.get().unregisterHandler("/update.xml");
        this.httpAcceptor.get().unregisterHandler("/gnutella/push-proxy");
        this.httpAcceptor.get().unregisterHandler("/gnet/push-proxy");
        this.httpAcceptor.get().unregisterHandler("/get*");
        this.httpAcceptor.get().unregisterHandler("/uri-res/*");
        this.httpAcceptor.get().removeAcceptorListener(this.responseListener);
        FileUtils.removeFileLocker(this);
        this.started = false;
    }

    @Override
    public void handleFreeLoader(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext, HTTPUploader hTTPUploader) throws HttpException, IOException {
        assert (this.started);
        hTTPUploader.setState(Uploader.UploadStatus.FREELOADER);
        this.freeLoaderRequestHandler.handle(httpRequest, httpResponse, httpContext);
    }

    private boolean shouldBypassQueue(HttpRequest httpRequest, HTTPUploader hTTPUploader) {
        assert (hTTPUploader.getState() == Uploader.UploadStatus.CONNECTING);
        return "HEAD".equals(httpRequest.getRequestLine().getMethod()) || hTTPUploader.isForcedShare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupFinishedUploader(HTTPUploader hTTPUploader) {
        assert (this.started);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cleaning uploader " + hTTPUploader);
        }
        Uploader.UploadStatus uploadStatus = hTTPUploader.getState();
        Uploader.UploadStatus uploadStatus2 = hTTPUploader.getLastTransferState();
        long l = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            if (hTTPUploader.getStartTime() > 0L) {
                this.reportUploadSpeed(l - hTTPUploader.getStartTime(), hTTPUploader.getTotalAmountUploaded());
            }
            this.removeFromList(hTTPUploader);
            this.localUploads.remove(hTTPUploader);
        }
        if (!(hTTPUploader.getUploadType() == null || hTTPUploader.getUploadType().isInternal() || (object = hTTPUploader.getFileDesc()) == null || uploadStatus != Uploader.UploadStatus.COMPLETE || uploadStatus2 != Uploader.UploadStatus.UPLOADING && uploadStatus2 != Uploader.UploadStatus.THEX_REQUEST)) {
            ((FileDesc)object).incrementCompletedUploads();
            this.activityCallback.get().handleSharedFileUpdate(((FileDesc)object).getFile());
        }
        this.activityCallback.get().removeUpload(hTTPUploader);
    }

    @Override
    public synchronized void addAcceptedUploader(HTTPUploader hTTPUploader, HttpContext httpContext) {
        assert (this.started);
        if (hTTPUploader.isForcedShare()) {
            ++this.forcedUploads;
        } else if (HttpContextParams.isLocal(httpContext)) {
            this.localUploads.add(hTTPUploader);
        }
        this.activeUploadList.add(hTTPUploader);
        hTTPUploader.setStartTime(System.currentTimeMillis());
    }

    @Override
    public void sendResponse(HTTPUploader hTTPUploader, HttpResponse httpResponse) {
        FileDesc fileDesc;
        assert (this.started);
        hTTPUploader.setLastResponse(httpResponse);
        if (hTTPUploader.isVisible()) {
            return;
        }
        this.activityCallback.get().addUpload(hTTPUploader);
        hTTPUploader.setVisible(true);
        if (!hTTPUploader.getUploadType().isInternal() && (fileDesc = hTTPUploader.getFileDesc()) != null) {
            fileDesc.incrementAttemptedUploads();
            this.activityCallback.get().handleSharedFileUpdate(fileDesc.getFile());
        }
    }

    @Override
    public synchronized boolean isServiceable() {
        if (!this.started) {
            return false;
        }
        return this.slotManager.hasHTTPSlot(this.uploadsInProgress() + this.getNumQueuedUploads());
    }

    @Override
    public synchronized boolean mayBeServiceable() {
        if (!this.started) {
            return false;
        }
        if (this.fileManager.get().hasApplicationSharedFiles()) {
            return this.slotManager.hasHTTPSlotForMeta(this.uploadsInProgress() + this.getNumQueuedUploads());
        }
        return this.isServiceable();
    }

    @Override
    public synchronized int uploadsInProgress() {
        return this.activeUploadList.size() - this.forcedUploads;
    }

    @Override
    public synchronized int getNumQueuedUploads() {
        return this.slotManager.getNumQueued();
    }

    @Override
    public boolean hadSuccesfulUpload() {
        return this.hadSuccesfulUpload;
    }

    @Override
    public synchronized boolean isConnectedTo(InetAddress inetAddress) {
        if (this.slotManager.getNumUsersForHost(inetAddress.getHostAddress()) > 0) {
            return true;
        }
        for (HTTPUploader hTTPUploader : this.activeUploadList) {
            InetAddress inetAddress2 = hTTPUploader.getConnectedHost();
            if (inetAddress2 == null || !inetAddress2.equals(inetAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean releaseLock(File file) {
        assert (this.started);
        FileDesc fileDesc = this.fileManager.get().getFileDescForFile(file);
        if (fileDesc != null) {
            return this.killUploadsForFileDesc(fileDesc);
        }
        return false;
    }

    @Override
    public synchronized boolean killUploadsForFileDesc(FileDesc fileDesc) {
        boolean bl = false;
        for (HTTPUploader hTTPUploader : this.activeUploadList) {
            FileDesc fileDesc2 = hTTPUploader.getFileDesc();
            if (fileDesc2 == null || !fileDesc2.equals(fileDesc)) continue;
            bl = true;
            hTTPUploader.stop();
        }
        return bl;
    }

    private synchronized HTTPUploadSessionManager.QueueStatus checkAndQueue(HTTPUploadSession hTTPUploadSession) {
        URN uRN;
        RequestCache requestCache = this.REQUESTS.get(hTTPUploadSession.getHost());
        if (requestCache == null) {
            requestCache = new RequestCache();
        }
        this.REQUESTS.put(hTTPUploadSession.getHost(), requestCache);
        requestCache.countRequest();
        if (requestCache.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(hTTPUploadSession.getUploader() + " banned.");
            }
            return HTTPUploadSessionManager.QueueStatus.BANNED;
        }
        FileDesc fileDesc = hTTPUploadSession.getUploader().getFileDesc();
        if (!this.contentManager.get().isVerified(fileDesc.getSHA1Urn())) {
            this.fileManager.get().validate(fileDesc);
        }
        if (requestCache.isDupe(uRN = fileDesc.getSHA1Urn())) {
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        if (this.slotManager.positionInQueue(hTTPUploadSession) == -1 && this.hostLimitReached(hTTPUploadSession.getHost())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("host limit reached for " + hTTPUploadSession.getHost());
            }
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        int n = this.slotManager.pollForSlot(hTTPUploadSession, hTTPUploadSession.getUploader().supportsQueueing(), hTTPUploadSession.getUploader().isPriorityShare());
        if (LOG.isDebugEnabled()) {
            LOG.debug("queued at " + n);
        }
        if (n == -1) {
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        if (n > 0 && hTTPUploadSession.poll()) {
            this.slotManager.cancelRequest(hTTPUploadSession);
            return HTTPUploadSessionManager.QueueStatus.BANNED;
        }
        if (n > 0) {
            return HTTPUploadSessionManager.QueueStatus.QUEUED;
        }
        requestCache.startedTransfer(uRN);
        return HTTPUploadSessionManager.QueueStatus.ACCEPTED;
    }

    private synchronized void removeFromList(HTTPUploader hTTPUploader) {
        if (this.activeUploadList.remove(hTTPUploader)) {
            RequestCache requestCache;
            if (hTTPUploader.isForcedShare()) {
                --this.forcedUploads;
            }
            if ((requestCache = this.REQUESTS.get(hTTPUploader.getHost())) != null && hTTPUploader.getFileDesc() != null) {
                requestCache.transferDone(hTTPUploader.getFileDesc().getSHA1Urn());
            }
        }
        if (this.activeUploadList.size() == 0) {
            this.activityCallback.get().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String string) {
        return this.slotManager.getNumUsersForHost(string) >= UploadSettings.UPLOADS_PER_PERSON.getValue();
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        float f = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float f2 = UploadSettings.UPLOAD_SPEED.getValue();
        float f3 = f * f2 / 100.0f;
        return f3;
    }

    @Override
    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        Buffer<Integer> buffer = this.speeds;
        synchronized (buffer) {
            this.speeds.add(n);
            if (this.speeds.size() >= 5) {
                int n2 = 0;
                for (int i = 0; i < this.speeds.size(); ++i) {
                    n2 = Math.max(n2, this.speeds.get(i));
                }
                this.highestSpeed = n2;
            }
        }
    }

    @Override
    public void measureBandwidth() {
        this.slotManager.measureBandwidth();
        for (HTTPUploader hTTPUploader : this.localUploads) {
            hTTPUploader.measureBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMeasuredBandwidth() {
        float f = 0.0f;
        try {
            f += this.slotManager.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            // empty catch block
        }
        for (HTTPUploader hTTPUploader : this.localUploads) {
            try {
                f += hTTPUploader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {}
        }
        HTTPUploadManager hTTPUploadManager = this;
        synchronized (hTTPUploadManager) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
        this.lastMeasuredBandwidth = f;
        return f;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    public UploadSlotManager getSlotManager() {
        return this.slotManager;
    }

    public HTTPUploadSession getOrCreateSession(HttpContext httpContext) {
        assert (this.started);
        HTTPUploadSession hTTPUploadSession = (HTTPUploadSession)httpContext.getAttribute(SESSION_KEY);
        if (hTTPUploadSession == null) {
            InetAddress inetAddress;
            HttpInetConnection httpInetConnection = (HttpInetConnection)httpContext.getAttribute("http.connection");
            if (httpInetConnection != null) {
                inetAddress = httpInetConnection.getRemoteAddress();
            } else {
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    throw new RuntimeException(unknownHostException);
                }
            }
            hTTPUploadSession = new HTTPUploadSession(this.getSlotManager(), inetAddress, HttpContextParams.getIOSession(httpContext));
            httpContext.setAttribute(SESSION_KEY, hTTPUploadSession);
        }
        return hTTPUploadSession;
    }

    public HTTPUploadSession getSession(HttpContext httpContext) {
        assert (this.started);
        HTTPUploadSession hTTPUploadSession = (HTTPUploadSession)httpContext.getAttribute(SESSION_KEY);
        return hTTPUploadSession;
    }

    @Override
    public HTTPUploader getOrCreateUploader(HttpRequest httpRequest, HttpContext httpContext, UploadType uploadType, String string) {
        assert (this.started);
        HTTPUploadSession hTTPUploadSession = this.getOrCreateSession(httpContext);
        HTTPUploader hTTPUploader = hTTPUploadSession.getUploader();
        if (hTTPUploader != null) {
            if (!hTTPUploader.getFileName().equals(string) || !hTTPUploader.getMethod().equals(httpRequest.getRequestLine().getMethod())) {
                this.slotManager.requestDone(hTTPUploadSession);
                if (hTTPUploadSession.isQueued()) {
                    hTTPUploader.setState(Uploader.UploadStatus.INTERRUPTED);
                } else {
                    this.slotManager.requestDone(hTTPUploadSession);
                }
                this.cleanupFinishedUploader(hTTPUploader);
                hTTPUploader = new HTTPUploader(string, hTTPUploadSession, this.tcpBandwidthStatistics);
            } else {
                hTTPUploader.reinitialize();
            }
        } else {
            hTTPUploader = new HTTPUploader(string, hTTPUploadSession);
        }
        String string2 = httpRequest.getRequestLine().getMethod();
        hTTPUploader.setMethod(string2);
        hTTPUploader.setUploadType("HEAD".equals(string2) ? UploadType.HEAD_REQUEST : uploadType);
        hTTPUploadSession.setUploader(hTTPUploader);
        return hTTPUploader;
    }

    public HTTPUploader getUploader(HttpContext httpContext) {
        assert (this.started);
        HTTPUploadSession hTTPUploadSession = this.getSession(httpContext);
        HTTPUploader hTTPUploader = hTTPUploadSession.getUploader();
        assert (hTTPUploader != null);
        return hTTPUploader;
    }

    @Override
    public HTTPUploadSessionManager.QueueStatus enqueue(HttpContext httpContext, HttpRequest httpRequest) {
        assert (this.started);
        HTTPUploadSession hTTPUploadSession = this.getSession(httpContext);
        assert (!hTTPUploadSession.isAccepted());
        if (this.shouldBypassQueue(httpRequest, hTTPUploadSession.getUploader())) {
            hTTPUploadSession.setQueueStatus(HTTPUploadSessionManager.QueueStatus.BYPASS);
        } else if (HttpContextParams.isLocal(httpContext)) {
            hTTPUploadSession.setQueueStatus(HTTPUploadSessionManager.QueueStatus.ACCEPTED);
        } else {
            hTTPUploadSession.setQueueStatus(this.checkAndQueue(hTTPUploadSession));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued upload: " + hTTPUploadSession);
        }
        return hTTPUploadSession.getQueueStatus();
    }

    public void cleanup() {
        assert (this.started);
        for (HTTPUploader hTTPUploader : this.activeUploadList.toArray(new HTTPUploader[0])) {
            hTTPUploader.stop();
            this.slotManager.cancelRequest(hTTPUploader.getSession());
            this.removeFromList(hTTPUploader);
        }
        this.slotManager.cleanup();
        this.REQUESTS.clear();
    }

    private class ResponseListener
    implements HttpAcceptorListener {
        private ResponseListener() {
        }

        public void connectionOpen(NHttpConnection nHttpConnection) {
        }

        public void connectionClosed(NHttpConnection nHttpConnection) {
            HTTPUploader hTTPUploader;
            assert (HTTPUploadManager.this.started);
            HTTPUploadSession hTTPUploadSession = HTTPUploadManager.this.getSession(nHttpConnection.getContext());
            if (hTTPUploadSession != null && (hTTPUploader = hTTPUploadSession.getUploader()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing session for " + hTTPUploadSession.getHost());
                }
                boolean bl = HTTPUploadManager.this.slotManager.positionInQueue(hTTPUploadSession) > -1;
                HTTPUploadManager.this.slotManager.cancelRequest(hTTPUploadSession);
                if (bl) {
                    hTTPUploader.setState(Uploader.UploadStatus.INTERRUPTED);
                } else if (hTTPUploader.getState() != Uploader.UploadStatus.COMPLETE) {
                    hTTPUploader.setState(Uploader.UploadStatus.COMPLETE);
                }
                hTTPUploader.setLastResponse(null);
                HTTPUploadManager.this.cleanupFinishedUploader(hTTPUploader);
                hTTPUploadSession.setUploader(null);
            }
        }

        public void requestReceived(NHttpConnection nHttpConnection, HttpRequest httpRequest) {
        }

        public void responseSent(NHttpConnection nHttpConnection, HttpResponse httpResponse) {
            assert (HTTPUploadManager.this.started);
            HTTPUploadSession hTTPUploadSession = HTTPUploadManager.this.getSession(nHttpConnection.getContext());
            if (hTTPUploadSession != null) {
                HTTPUploader hTTPUploader = hTTPUploadSession.getUploader();
                if (hTTPUploader != null && hTTPUploader.getLastResponse() == httpResponse) {
                    hTTPUploader.setLastResponse(null);
                    hTTPUploader.setState(Uploader.UploadStatus.COMPLETE);
                }
                if (hTTPUploadSession.getQueueStatus() == HTTPUploadSessionManager.QueueStatus.QUEUED) {
                    hTTPUploadSession.getIOSession().setSocketTimeout(120000);
                }
            }
        }
    }
}

