/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class ConnectionWatchdog {
    private static final Log LOG = LogFactory.getLog(ConnectionWatchdog.class);
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionManager> connectionManager;
    private final ConnectionServices connectionServices;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public ConnectionWatchdog(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<ConnectionManager> provider2, ConnectionServices connectionServices, PingRequestFactory pingRequestFactory) {
        this.backgroundExecutor = scheduledExecutorService;
        this.messageRouter = provider;
        this.connectionManager = provider2;
        this.connectionServices = connectionServices;
        this.pingRequestFactory = pingRequestFactory;
    }

    public void start() {
        this.findDuds();
    }

    private void findDuds() {
        HashMap<RoutedConnection, ConnectionState> hashMap = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection routedConnection : this.allConnections()) {
            if (!routedConnection.isKillable()) continue;
            hashMap.put(routedConnection, new ConnectionState(routedConnection));
        }
        this.backgroundExecutor.schedule(new DudChecker(hashMap, false), 30000L, TimeUnit.MILLISECONDS);
    }

    private void killIfStillDud(List<? extends RoutedConnection> list) {
        HashMap<RoutedConnection, ConnectionState> hashMap = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection routedConnection : list) {
            if (!routedConnection.isKillable()) continue;
            hashMap.put(routedConnection, new ConnectionState(routedConnection));
            this.messageRouter.get().sendPingRequest(this.pingRequestFactory.createPingRequest((byte)1), routedConnection);
        }
        this.backgroundExecutor.schedule(new DudChecker(hashMap, true), 15000L, TimeUnit.MILLISECONDS);
    }

    private Iterable<RoutedConnection> allConnections() {
        List<RoutedConnection> list = this.connectionManager.get().getInitializedConnections();
        List<RoutedConnection> list2 = this.connectionManager.get().getInitializedClientConnections();
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DudChecker
    implements Runnable {
        private Map<RoutedConnection, ConnectionState> snapshots;
        private boolean kill;

        DudChecker(Map<RoutedConnection, ConnectionState> map, boolean bl) {
            this.snapshots = map;
            this.kill = bl;
        }

        @Override
        public void run() {
            List list = this.kill ? Collections.emptyList() : new ArrayList();
            for (RoutedConnection routedConnection : ConnectionWatchdog.this.allConnections()) {
                ConnectionState connectionState;
                ConnectionState connectionState2;
                if (!routedConnection.isKillable() || (connectionState2 = this.snapshots.get(routedConnection)) == null || !(connectionState = new ConnectionState(routedConnection)).notProgressedSince(connectionState2)) continue;
                if (this.kill) {
                    if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Killing connection: " + routedConnection);
                    }
                    ConnectionWatchdog.this.connectionServices.removeConnection(routedConnection);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Potential dud: " + routedConnection);
                }
                list.add(routedConnection);
            }
            if (list.isEmpty()) {
                ConnectionWatchdog.this.findDuds();
            } else {
                ConnectionWatchdog.this.killIfStillDud(list);
            }
        }
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(RoutedConnection routedConnection) {
            this.sentDropped = routedConnection.getConnectionMessageStatistics().getNumSentMessagesDropped();
            this.sent = routedConnection.getConnectionMessageStatistics().getNumMessagesSent();
            this.received = routedConnection.getConnectionMessageStatistics().getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState connectionState) {
            long l = this.sent - connectionState.sent;
            long l2 = this.sentDropped - connectionState.sentDropped;
            long l3 = this.received - connectionState.received;
            if (l == l2 && l != 0L) {
                return true;
            }
            return l3 == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

