/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.messages.BTCancel;
import com.limegroup.bittorrent.messages.BTChoke;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.bittorrent.messages.BTInterested;
import com.limegroup.bittorrent.messages.BTNotInterested;
import com.limegroup.bittorrent.messages.BTRequest;
import com.limegroup.bittorrent.messages.BTUnchoke;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import java.nio.ByteBuffer;

public abstract class BTMessage {
    public static final byte KEEP_ALIVE = -1;
    public static final byte CHOKE = 0;
    public static final byte UNCHOKE = 1;
    public static final byte INTERESTED = 2;
    public static final byte NOT_INTERESTED = 3;
    public static final byte HAVE = 4;
    public static final byte BITFIELD = 5;
    public static final byte REQUEST = 6;
    public static final byte PIECE = 7;
    public static final byte CANCEL = 8;
    public static final ByteBuffer EMPTY_PAYLOAD = ByteBuffer.allocate(0);
    private final byte _type;

    BTMessage(byte by) {
        this._type = by;
    }

    public byte getType() {
        return this._type;
    }

    public abstract ByteBuffer getPayload();

    public boolean isUrgent() {
        return false;
    }

    public static BTMessage parseMessage(ByteBuffer byteBuffer, int n) throws BadBTMessageException {
        switch (n) {
            case 0: {
                return BTChoke.createMessage();
            }
            case 1: {
                return BTUnchoke.createMessage();
            }
            case 2: {
                return BTInterested.createMessage();
            }
            case 3: {
                return BTNotInterested.createMessage();
            }
            case 4: {
                return BTHave.readMessage(byteBuffer);
            }
            case 5: {
                throw new BadBTMessageException("unexpected bitfield");
            }
            case 6: {
                return BTRequest.readMessage(byteBuffer);
            }
            case 7: {
                throw new IllegalArgumentException("do not parse pieces here");
            }
            case 8: {
                return BTCancel.readMessage(byteBuffer);
            }
        }
        throw new BadBTMessageException("unknown message, type " + n);
    }
}

