/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.handshaking;

import com.limegroup.bittorrent.BTConnectionFactory;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.handshaking.BTHandshakeObserver;
import com.limegroup.bittorrent.handshaking.BTHandshaker;
import com.limegroup.bittorrent.handshaking.IncomingBTHandshaker;
import com.limegroup.bittorrent.handshaking.OutgoingBTHandshaker;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.service.ErrorService;

public class BTConnectionFetcher
implements BTHandshakeObserver,
Runnable,
Shutdownable {
    private static final Log LOG = LogFactory.getLog(BTConnectionFetcher.class);
    private static final String BITTORRENT_PROTOCOL = "BitTorrent protocol";
    public static byte[] BITTORRENT_PROTOCOL_BYTES;
    private static final byte[] EXTENSION_BYTES;
    private final StrictIpPortSet<TorrentConnector> connecting = new StrictIpPortSet();
    private final StrictIpPortSet<BTHandshaker> handshaking = new StrictIpPortSet();
    private final ManagedTorrent _torrent;
    private final ByteBuffer _handshake;
    private volatile boolean shutdown;
    private final Periodic scheduled;
    private volatile int _triedHosts;
    private final SocketsManager socketsManager;
    private final BTConnectionFactory btcFactory;

    BTConnectionFetcher(ManagedTorrent managedTorrent, ScheduledExecutorService scheduledExecutorService, ApplicationServices applicationServices, SocketsManager socketsManager, BTConnectionFactory bTConnectionFactory) {
        this.socketsManager = socketsManager;
        this.btcFactory = bTConnectionFactory;
        this._torrent = managedTorrent;
        ByteBuffer byteBuffer = ByteBuffer.allocate(68);
        byteBuffer.put((byte)BITTORRENT_PROTOCOL.length());
        byteBuffer.put(BITTORRENT_PROTOCOL_BYTES);
        byteBuffer.put(EXTENSION_BYTES);
        byteBuffer.put(this._torrent.getInfoHash());
        byteBuffer.put(applicationServices.getMyBTGUID());
        byteBuffer.flip();
        this._handshake = byteBuffer.asReadOnlyBuffer();
        this.scheduled = new Periodic(this, scheduledExecutorService);
    }

    public synchronized void fetch() {
        if (this.shutdown || !this._torrent.needsMoreConnections()) {
            return;
        }
        long l = this._torrent.getNextLocationRetryTime();
        if (l != Long.MAX_VALUE) {
            this.scheduled.rescheduleIfSooner(l);
        }
    }

    public void run() {
        this.fetchImpl();
    }

    private void fetchImpl() {
        if (this.shutdown) {
            return;
        }
        while (this._torrent.needsMoreConnections() && this.connecting.size() < this.socketsManager.getNumAllowedSockets() && this._torrent.hasNonBusyLocations()) {
            this.fetchConnection();
        }
        if (this.connecting.size() < this.socketsManager.getNumAllowedSockets()) {
            this.fetch();
        }
    }

    private void fetchConnection() {
        TorrentLocation torrentLocation = null;
        do {
            if ((torrentLocation = this._torrent.getTorrentLocation()) != null) continue;
            LOG.debug("no hosts to connect to");
            return;
        } while (this.connecting.contains(torrentLocation) || this.handshaking.contains(torrentLocation));
        TorrentConnector torrentConnector = new TorrentConnector(torrentLocation);
        this.connecting.add(torrentConnector);
        ++this._triedHosts;
        try {
            torrentConnector.toCancel = this.socketsManager.connect(new InetSocketAddress(torrentLocation.getAddress(), torrentLocation.getPort()), 8000, torrentConnector);
        }
        catch (IOException iOException) {
            this.connecting.remove(torrentConnector);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting a connector to " + torrentLocation.getAddress() + " total " + this.connecting.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.scheduled.unschedule();
        object = new ArrayList(this.connecting.size() + this.handshaking.size());
        object.addAll(this.connecting);
        object.addAll(this.handshaking);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Shutdownable shutdownable = (Shutdownable)iterator.next();
            shutdownable.shutdown();
        }
    }

    public ByteBuffer getOutgoingHandshake() {
        return this._handshake.duplicate();
    }

    public void handshakerStarted(IncomingBTHandshaker incomingBTHandshaker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incoming handshaker from " + incomingBTHandshaker.getInetAddress() + ":" + incomingBTHandshaker.getPort());
        }
        if (this.shutdown || this.handshaking.contains(incomingBTHandshaker)) {
            LOG.debug("rejecting it");
            incomingBTHandshaker.shutdown();
        } else {
            this.handshaking.add(incomingBTHandshaker);
        }
        if (this.connecting.contains(incomingBTHandshaker)) {
            for (TorrentConnector torrentConnector : this.connecting) {
                if (IpPort.COMPARATOR.compare(torrentConnector, incomingBTHandshaker) != 0) continue;
                LOG.debug("stopping a connection attempt to same location");
                torrentConnector.shutdown();
                return;
            }
        }
    }

    public void handshakerDone(BTHandshaker bTHandshaker) {
        assert (this.shutdown || this.handshaking.contains(bTHandshaker)) : "unknown shaker " + bTHandshaker;
        this.handshaking.remove(bTHandshaker);
    }

    public int getTriedHostCount() {
        return this._triedHosts;
    }

    static {
        try {
            BITTORRENT_PROTOCOL_BYTES = BITTORRENT_PROTOCOL.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        EXTENSION_BYTES = new byte[8];
    }

    private class TorrentConnector
    implements ConnectObserver,
    IpPort {
        private final TorrentLocation destination;
        private final AtomicBoolean shutdown = new AtomicBoolean(false);
        volatile Socket toCancel;

        TorrentConnector(TorrentLocation torrentLocation) {
            this.destination = torrentLocation;
        }

        public void handleConnect(Socket socket) {
            if (this.shutdown.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("established transport to " + socket.getInetAddress());
            }
            BTConnectionFetcher.this.connecting.remove(this);
            if (BTConnectionFetcher.this.handshaking.contains(this)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshaker for this location exists");
                }
                IOUtils.close(socket);
                return;
            }
            OutgoingBTHandshaker outgoingBTHandshaker = new OutgoingBTHandshaker(this.destination, BTConnectionFetcher.this._torrent, (AbstractNBSocket)socket, BTConnectionFetcher.this.btcFactory);
            BTConnectionFetcher.this.handshaking.add(outgoingBTHandshaker);
            ((BTHandshaker)outgoingBTHandshaker).startHandshaking();
            BTConnectionFetcher.this.fetch();
        }

        public void handleIOException(IOException iOException) {
            this.shutdown();
        }

        public void shutdown() {
            if (this.shutdown.getAndSet(true)) {
                return;
            }
            IOUtils.close(this.toCancel);
            BTConnectionFetcher.this.connecting.remove(this);
            BTConnectionFetcher.this.fetch();
        }

        public String getAddress() {
            return this.destination.getAddress();
        }

        public InetAddress getInetAddress() {
            return this.destination.getInetAddress();
        }

        public int getPort() {
            return this.destination.getPort();
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.destination.getInetSocketAddress();
        }
    }
}

