/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;

public class BitTorrentDownloadSpeedPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("BitTorrent download speed");
    public static final String LABEL = I18n.tr("Set the Maximum BitTorrent download speed in KB/s.");
    private final String LABEL_SPEED = I18n.tr("Download Speed:");
    private JSlider DOWNLOAD_SLIDER = new JSlider(56, 103424);
    private final JLabel SLIDER_LABEL = new JLabel();
    private int storedDownloadSpeed;
    private String configKey = "Max Download Speed KBs";

    public BitTorrentDownloadSpeedPaneItem() {
        super(TITLE, LABEL);
        this.DOWNLOAD_SLIDER.setMajorTickSpacing(1024);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel(I18n.tr("Min speed"));
        JLabel jLabel2 = new JLabel(I18n.tr("Max speed"));
        Font font = new Font("Helvetica", 1, 10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        hashtable.put(56, jLabel);
        hashtable.put(103424, jLabel2);
        this.DOWNLOAD_SLIDER.setLabelTable(hashtable);
        this.DOWNLOAD_SLIDER.setPaintLabels(true);
        this.DOWNLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BitTorrentDownloadSpeedPaneItem.this.updateSpeedLabel();
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent(this.LABEL_SPEED, this.SLIDER_LABEL, 120, 10);
        this.add(this.DOWNLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent.getComponent());
    }

    private void updateSpeedLabel() {
        float f = this.DOWNLOAD_SLIDER.getValue();
        System.out.println("updateSpeedLabel: " + f);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = String.valueOf(numberFormat.format(f)) + " KB/s";
        if (f > 102400.0f) {
            this.SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.SLIDER_LABEL.setText(string);
        }
    }

    public void initOptions() {
        this.storedDownloadSpeed = COConfigurationManager.getIntParameter(this.configKey);
        if (this.storedDownloadSpeed == 0) {
            this.DOWNLOAD_SLIDER.setValue(103424);
            this.SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.DOWNLOAD_SLIDER.setValue(this.storedDownloadSpeed);
        }
        this.updateSpeedLabel();
    }

    public boolean applyOptions() throws IOException {
        int n = this.DOWNLOAD_SLIDER.getValue();
        int n2 = 0;
        if (n <= 102400) {
            n2 = (Integer)new TransferSpeedValidator(this.configKey, new Integer(n)).getValue();
        }
        COConfigurationManager.setParameter(this.configKey, n2);
        COConfigurationManager.save();
        return false;
    }

    public boolean isDirty() {
        return this.storedDownloadSpeed != this.DOWNLOAD_SLIDER.getValue();
    }
}

