/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui;

import com.frostwire.bittorrent.BTFilesManagerFactory;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import java.io.File;
import java.io.IOException;
import org.limewire.util.FileUtils;

public class TorrentDownloadFactory
implements GuiDownloaderFactory {
    private BTMetaInfo info;
    private boolean useBTFilesManager = false;

    public TorrentDownloadFactory(File file) throws IOException {
        byte[] byArray = FileUtils.readFileFully(file);
        if (byArray == null) {
            throw new IOException();
        }
        if (this.useBTFilesManager) {
            BTFilesManagerFactory bTFilesManagerFactory = new BTFilesManagerFactory(byArray, this.info, file);
            bTFilesManagerFactory.loadFiles();
            this.info = bTFilesManagerFactory.info;
        } else {
            this.info = BTMetaInfo.readFromBytes(byArray);
        }
    }

    public TorrentDownloadFactory(BTMetaInfo bTMetaInfo) {
        this.info = bTMetaInfo;
    }

    public Downloader createDownloader(boolean bl) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().downloadTorrent(this.info, bl);
    }

    public long getFileSize() {
        return this.info.getFileSystem().getTotalSize();
    }

    public File getSaveFile() {
        return this.info.getFileSystem().getCompleteFile();
    }

    public URN getURN() {
        if (this.info != null) {
            return this.info.getURN();
        }
        return null;
    }

    public BTMetaInfo getBTMetaInfo() {
        return this.info;
    }

    public void setSaveFile(File file) {
        this.info.getFileSystem().setCompleteFile(file);
    }
}

