/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.InsufficientDataException;

public class SimpleBandwidthTracker
implements BandwidthTracker {
    private static final int DEFAULT_INTERVAL = 500;
    private final int _interval;
    private long _lastAmount = 0L;
    private long _lastTimeMeasured = 0L;
    private long _firstTimeMeasured = 0L;
    private long _amount = 0L;
    private float _measuredBandwidth = -1.0f;

    public SimpleBandwidthTracker() {
        this(500);
    }

    public SimpleBandwidthTracker(int n) {
        this._interval = n;
    }

    public synchronized void count(int n) {
        this.startCounting(-1L);
        this._amount += (long)n;
    }

    private void startCounting(long l) {
        if (this._firstTimeMeasured == 0L) {
            if (l == -1L) {
                l = System.currentTimeMillis();
            }
            this._lastTimeMeasured = this._firstTimeMeasured = l;
        }
    }

    public synchronized long getTotalAmount() {
        return this._amount;
    }

    public synchronized void measureBandwidth() {
        long l = System.currentTimeMillis();
        this.startCounting(l);
        if (l - this._lastTimeMeasured < (long)this._interval) {
            return;
        }
        this._measuredBandwidth = (this._amount - this._lastAmount) / (l - this._lastTimeMeasured);
        this._lastAmount = this._amount;
        this._lastTimeMeasured = l;
    }

    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this._measuredBandwidth < 0.0f) {
            throw new InsufficientDataException();
        }
        return this._measuredBandwidth;
    }

    public synchronized float getAverageBandwidth() {
        long l = System.currentTimeMillis() - this._firstTimeMeasured;
        return l <= 0L ? 0.0f : (float)(this._amount / l);
    }
}

