/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.frostwire.bittorrent.AzureusStarter;
import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.BTLinkListener;
import com.limegroup.bittorrent.BTLinkManager;
import com.limegroup.bittorrent.BTLinkManagerFactory;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.Torrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.choking.ChokerFactory;
import com.limegroup.bittorrent.disk.DiskManagerListener;
import com.limegroup.bittorrent.handshaking.BTConnectionFetcher;
import com.limegroup.bittorrent.handshaking.BTConnectionFetcherFactory;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.bittorrent.tracking.TrackerManagerFactory;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.SyncWrapper;
import org.limewire.io.DiskException;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTorrent
implements Torrent,
DiskManagerListener,
BTLinkListener {
    private static final Log LOG = LogFactory.getLog(ManagedTorrent.class);
    private static final ExecutorService DEFAULT_DISK_INVOKER = ExecutorsHelper.newProcessingQueue("ManagedTorrent");
    private ExecutorService diskInvoker = DEFAULT_DISK_INVOKER;
    private BTMetaInfo _info;
    private final BTLinkManager linkManager;
    private final SyncWrapper<Torrent.TorrentState> state = new SyncWrapper<Torrent.TorrentState>(Torrent.TorrentState.QUEUED);
    private final EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher;
    private final TorrentManager torrentManager;
    private final FileManager fileManager;
    private AzureusCore _azureusCore;
    private DownloadManager _manager;
    private File _torrentFile;
    private boolean _ignoreStopped = true;
    private boolean _changedSaveDir = false;
    private String _newSaveDir;
    private boolean _overwrite;
    private long _totalDownloaded;
    private boolean _hasBeenPaused;
    private Boolean _shuttingdown = false;

    ManagedTorrent(TorrentContext torrentContext, EventDispatcher<TorrentEvent, TorrentEventListener> eventDispatcher, ScheduledExecutorService scheduledExecutorService, NetworkManager networkManager, TrackerManagerFactory trackerManagerFactory, ChokerFactory chokerFactory, BTLinkManagerFactory bTLinkManagerFactory, BTConnectionFetcherFactory bTConnectionFetcherFactory, ContentManager contentManager, IPFilter iPFilter, TorrentManager torrentManager, FileManager fileManager, NetworkInstanceUtils networkInstanceUtils, boolean bl) {
        this.dispatcher = eventDispatcher;
        this.torrentManager = torrentManager;
        this.fileManager = fileManager;
        this._info = torrentContext.getMetaInfo();
        this.linkManager = bTLinkManagerFactory.getLinkManager();
        this._overwrite = bl;
        this._hasBeenPaused = false;
        this.azureusInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScraping() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.WAITING_FOR_TRACKER) {
                this.state.set(Torrent.TorrentState.SCRAPING);
            }
        }
    }

    public byte[] getInfoHash() {
        return this._info.getInfoHash();
    }

    public byte[] getSha1() {
        return this.getInfoHash();
    }

    public URN getURN() {
        return this._info.getURN();
    }

    public BTMetaInfo getMetaInfo() {
        return this._info;
    }

    public TorrentContext getContext() {
        LOG.debug("getContext() invoked, returning null");
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.state.get() != Torrent.TorrentState.DISK_PROBLEM && this._manager != null && this._manager.isDownloadComplete(false) && !this._overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this._hasBeenPaused) {
            return;
        }
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() != Torrent.TorrentState.QUEUED) {
                throw new IllegalStateException("torrent should be queued but is " + (Object)((Object)this.state.get()));
            }
        }
        this.dispatchEvent(TorrentEvent.Type.STARTING);
        this.diskInvoker.execute(new Runnable(){

            public void run() {
                if (ManagedTorrent.this.state.get() != Torrent.TorrentState.QUEUED) {
                    return;
                }
                LOG.debug("executing torrent start");
                ManagedTorrent.this.initializeAzureusTorrent();
                ManagedTorrent.this.initializeFolder();
                if (ManagedTorrent.this.state.get() == Torrent.TorrentState.DISK_PROBLEM) {
                    return;
                }
                ManagedTorrent.this.dispatchEvent(TorrentEvent.Type.STARTED);
                Torrent.TorrentState torrentState = (Torrent.TorrentState)((Object)ManagedTorrent.this.state.get());
                if (torrentState == Torrent.TorrentState.SEEDING || torrentState == Torrent.TorrentState.VERIFYING) {
                    return;
                }
                ManagedTorrent.this.validateTorrent();
                ManagedTorrent.this.startConnecting();
            }
        });
    }

    private void initializeTorrentFile() {
        if (this.getTorrentDataFile().exists() && this.getTorrentDataFile().length() > 0L && this.getTorrentDataFile().isFile()) {
            this._torrentFile = this.getTorrentDataFile();
        } else {
            this.createTorrentFile();
        }
    }

    private void azureusInit() {
        if (this._azureusCore == null) {
            try {
                this._azureusCore = AzureusStarter.getAzureusCore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createAzureusDownloadManager() throws Exception {
        if (this._azureusCore == null) {
            this.azureusInit();
        }
        while (!this._azureusCore.isStarted()) {
            LOG.debug("createAzureusDownloadManager: Waiting for azureusCore to start - sleeping...");
            Thread.sleep(500L);
        }
        this.initializeTorrentFile();
        int n = 20;
        do {
            if (!SharingSettings.DEFAULT_SAVE_DIR.exists()) {
                SharingSettings.DEFAULT_SAVE_DIR.mkdirs();
            }
            TOTorrent tOTorrent = TorrentUtils.readFromFile(this._torrentFile, false);
            this._manager = this._azureusCore.getGlobalManager().getDownloadManager(tOTorrent);
            if (this._manager == null) {
                this._manager = this._azureusCore.getGlobalManager().addDownloadManager(this._torrentFile.getCanonicalPath(), SharingSettings.DEFAULT_SAVE_DIR.getCanonicalPath());
            }
            LOG.debug("createdAzureusDownloadManger - Azureus Save Location is:\n>> " + this._manager.getSaveLocation().getCanonicalPath());
            if (this._manager == null) {
                LOG.debug("createAzureusDownloadManager We still don't have a manager - sleeping...");
                Thread.sleep(500L);
                --n;
            }
            if (n != 0 || this._manager != null) continue;
            LOG.debug("createAzureusDownloadManager() - Tried too many times to get a download manager, get me out of here.");
            return;
        } while (this._manager == null);
    }

    private void initializeAzureusTorrent() {
        try {
            boolean bl;
            this.createAzureusDownloadManager();
            File file = this._manager.getSaveLocation();
            boolean bl2 = !file.exists();
            boolean bl3 = bl = file.list() == null;
            if (bl2 || bl || this._overwrite) {
                this._overwrite = false;
            }
            if (this._manager == null) {
                throw new Exception("_manager was null (from azureusCore)");
            }
            this._manager.addListener(new DownloadManagerListener(){

                public void stateChanged(DownloadManager downloadManager, int n) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }

                public void positionChanged(DownloadManager downloadManager, int n, int n2) {
                }

                public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadComplete(DownloadManager downloadManager) {
                    LOG.debug("(Az)DownloadManagerListener - downloadComplete() - dispatch COMPLETE");
                    Object object = ManagedTorrent.this.state.getLock();
                    synchronized (object) {
                        ManagedTorrent.this.state.set(Torrent.TorrentState.SEEDING);
                        ManagedTorrent.this.dispatchEvent(TorrentEvent.Type.COMPLETE);
                    }
                    ManagedTorrent.this.addToLibrary();
                }

                public void completionChanged(DownloadManager downloadManager, boolean bl) {
                    LOG.debug("(Az)DownloadManagerListener - completionChanged - " + downloadManager.getStats().getCompleted() + "% completed.");
                }
            });
            this._manager.addPeerListener(new DownloadManagerPeerListener(){

                public void peerRemoved(PEPeer pEPeer) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }

                public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }

                public void peerManagerRemoved(PEPeerManager pEPeerManager) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }

                public void peerManagerAdded(PEPeerManager pEPeerManager) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }

                public void peerAdded(PEPeer pEPeer) {
                    ManagedTorrent.this.onStateChanged(ManagedTorrent.this._manager, ManagedTorrent.this._manager.getState());
                }
            });
            this._manager.addPieceListener(new DownloadManagerPieceListener(){

                public void pieceRemoved(PEPiece pEPiece) {
                }

                public void pieceAdded(PEPiece pEPiece) {
                }
            });
            this._azureusCore.addLifecycleListener(new AzureusCoreLifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stopping(AzureusCore azureusCore) {
                    if (!ManagedTorrent.this._shuttingdown.booleanValue()) {
                        LOG.debug("Nobody else will be able to pause, but me now...");
                        Boolean bl = ManagedTorrent.this._shuttingdown;
                        synchronized (bl) {
                            ManagedTorrent.this._shuttingdown = true;
                        }
                        ManagedTorrent.this.pause();
                    }
                }

                public boolean syncInvokeRequired() {
                    return false;
                }

                public void stopped(AzureusCore azureusCore) {
                }

                public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public void started(AzureusCore azureusCore) {
                }

                public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                    return false;
                }

                public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                }
            });
            this._manager.setStateWaiting();
        }
        catch (Exception exception) {
            LOG.error("Error starting torrent download", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStateChanged(DownloadManager downloadManager, int n) {
        if (this._shuttingdown.booleanValue()) {
            LOG.debug("onStateChanged(" + n + ") - Talk to the hand!");
            return;
        }
        if (n == 40) {
            LOG.debug("State READY (setting state to WAITING_FOR_TRACKER)");
            this._manager.startDownload();
            this.dispatchEvent(TorrentEvent.Type.STARTED);
        } else if (n == 20 || n == 5) {
            Object object = this.state.getLock();
            synchronized (object) {
                this.state.set(Torrent.TorrentState.CONNECTING);
            }
            this.dispatchEvent(TorrentEvent.Type.STARTING);
        } else if (n == 10) {
            Object object = this.state.getLock();
            synchronized (object) {
                this.state.set(Torrent.TorrentState.WAITING_FOR_TRACKER);
            }
            this.dispatchEvent(TorrentEvent.Type.STARTED);
        } else if (n == 60) {
            Object object = this.state.getLock();
            synchronized (object) {
                this.state.set(Torrent.TorrentState.SEEDING);
            }
            this.dispatchEvent(TorrentEvent.Type.STARTED);
        } else if (n == 70 && !this._ignoreStopped) {
            if (!this.state.get().equals((Object)Torrent.TorrentState.PAUSED)) {
                Object object = this.state.getLock();
                synchronized (object) {
                    this.state.set(Torrent.TorrentState.STOPPED);
                }
                this.dispatchEvent(TorrentEvent.Type.STOPPED);
            }
        } else if (n == 50) {
            this._ignoreStopped = false;
            Object object = this.state.getLock();
            synchronized (object) {
                this.state.set(Torrent.TorrentState.DOWNLOADING);
            }
            this.dispatchEvent(TorrentEvent.Type.DOWNLOADING);
        } else if (n == 100) {
            Object object = this.state.getLock();
            synchronized (object) {
                this.state.set(Torrent.TorrentState.STOPPED);
            }
            this.dispatchEvent(TorrentEvent.Type.STOPPED);
        } else if (n == 0) {
            this._manager.initialize();
        }
    }

    private void printAzTorrentDownloadStats() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Completed:");
        DownloadManagerStats downloadManagerStats = this._manager.getStats();
        int n = downloadManagerStats.getCompleted();
        stringBuffer.append(n / 10);
        stringBuffer.append('.');
        stringBuffer.append(n % 10);
        stringBuffer.append('%');
        stringBuffer.append(" Seeds:");
        stringBuffer.append(this._manager.getNbSeeds());
        stringBuffer.append(" Peers:");
        stringBuffer.append(this._manager.getNbPeers());
        stringBuffer.append(" Downloaded:");
        stringBuffer.append(DisplayFormatters.formatDownloaded(downloadManagerStats));
        stringBuffer.append(" Uploaded:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(downloadManagerStats.getTotalDataBytesSent()));
        stringBuffer.append(" DSpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataReceiveRate()));
        stringBuffer.append(" USpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataSendRate()));
        stringBuffer.append(" TrackerStatus:");
        stringBuffer.append(this._manager.getTrackerStatus());
        while (stringBuffer.length() < 80) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(" TO:");
        stringBuffer.append(this._info.getName());
        System.out.println(stringBuffer.toString());
    }

    private void validateTorrent() {
        LOG.debug("validateTorrent() invoked, doing nothing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnecting() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.getNumPeers() > 0) {
                this.state.set(Torrent.TorrentState.CONNECTING);
            } else {
                this.state.set(Torrent.TorrentState.SCRAPING);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isActive()) {
            throw new IllegalStateException("torrent cannot be stopped in state " + (Object)((Object)this.state.get()));
        }
        this.state.set(Torrent.TorrentState.STOPPED);
        this.stopImpl();
    }

    private void stopImpl() {
        this.stopImpl(false);
    }

    private synchronized void stopImpl(boolean bl) {
        if (this._manager != null) {
            this._manager.stopIt(70, false, false);
        }
        this.dispatchEvent(TorrentEvent.Type.STOPPED);
        LOG.debug("Torrent stopped on stopImpl()!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void diskExceptionHappened(DiskException diskException) {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.DISK_PROBLEM) {
                return;
            }
            this.state.set(Torrent.TorrentState.DISK_PROBLEM);
        }
        this.stopImpl();
        if (BittorrentSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            ErrorService.error(diskException);
        }
    }

    private void dispatchEvent(TorrentEvent.Type type, String string) {
        TorrentEvent torrentEvent = new TorrentEvent(this, type, this, string);
        this.dispatcher.dispatchEvent(torrentEvent);
    }

    private void dispatchEvent(TorrentEvent.Type type) {
        this.dispatchEvent(type, null);
    }

    private boolean stopState() {
        switch (this.state.get()) {
            case PAUSED: 
            case STOPPED: 
            case DISK_PROBLEM: 
            case TRACKER_FAILURE: 
            case INVALID: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pause() {
        try {
            this._hasBeenPaused = true;
            boolean bl = false;
            Object object = this.state.getLock();
            synchronized (object) {
                block9: {
                    if (this.isActive() || this.state.get() == Torrent.TorrentState.QUEUED) break block9;
                    this.state.set(Torrent.TorrentState.PAUSED);
                    return;
                }
                bl = this.isActive();
                this.state.set(Torrent.TorrentState.PAUSED);
                LOG.debug("ManagedTorrent.pause() - set state to TorrentState.PAUSED");
            }
            if (bl) {
                LOG.debug("ManagedTorrent.pause() - wasActive=true, invoking stopImpl()");
                this.stopImpl(true);
            }
        }
        finally {
            LOG.debug("TIME: " + System.currentTimeMillis() + "ManagedTorrent.pause() - The torrent state at the end was: " + (Object)((Object)this.state.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resume() {
        Object object = this.state.getLock();
        synchronized (object) {
            switch (this.state.get()) {
                case PAUSED: 
                case STOPPED: 
                case TRACKER_FAILURE: {
                    if (this._manager != null) {
                        this.state.set(Torrent.TorrentState.QUEUED);
                        this._manager.setStateWaiting();
                    }
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public void linkClosed(BTLink bTLink) {
        LOG.debug("linkClosed() invoked, doing nothing");
    }

    @Override
    public void linkInterested(BTLink bTLink) {
        if (!bTLink.isChoked()) {
            this.rechoke();
        }
    }

    @Override
    public void linkNotInterested(BTLink bTLink) {
        if (!bTLink.isChoked()) {
            this.rechoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackerRequestFailed() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.SCRAPING) {
                this.state.set(Torrent.TorrentState.WAITING_FOR_TRACKER);
            }
        }
    }

    private void initializeFolder() {
        LOG.debug("initializeFolder() invoked, doing nothing.");
    }

    @Override
    public void verificationComplete() {
        LOG.debug("verificationComplete() invoked, this should not be invoked in theory.");
        this.diskInvoker.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedTorrent.this.state.getLock();
                synchronized (object) {
                    if (ManagedTorrent.this.state.get() != Torrent.TorrentState.VERIFYING) {
                        return;
                    }
                    ManagedTorrent.this.state.set(Torrent.TorrentState.QUEUED);
                }
            }
        });
    }

    @Override
    public void chunkVerified(int n) {
    }

    @Override
    public Torrent.TorrentState getState() {
        return this.state.get();
    }

    public void addEndpoint(TorrentLocation torrentLocation) {
        LOG.debug("addEndpoint() invoked, should not be used.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopVoluntarily() {
        boolean bl = false;
        Object object = this.state.getLock();
        synchronized (object) {
            if (!this.isActive()) {
                return;
            }
            if (this.state.get() != Torrent.TorrentState.SEEDING) {
                this.state.set(Torrent.TorrentState.TRACKER_FAILURE);
                bl = true;
            }
        }
        if (bl) {
            this.stopImpl();
        }
    }

    public boolean needsMoreConnections() {
        LOG.debug("needsMoreConnections() invoked (always returning false)");
        return false;
    }

    public boolean shouldAddConnection(TorrentLocation torrentLocation) {
        LOG.debug("needsMoreConnections() invoked");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(BTLink bTLink) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add connection " + bTLink.toString());
        }
        boolean bl = false;
        Object object = this.state.getLock();
        synchronized (object) {
            switch (this.state.get()) {
                case CONNECTING: 
                case SCRAPING: 
                case WAITING_FOR_TRACKER: {
                    this.state.set(Torrent.TorrentState.DOWNLOADING);
                    this.dispatchEvent(TorrentEvent.Type.DOWNLOADING);
                }
                case DOWNLOADING: 
                case SEEDING: {
                    bl = true;
                }
            }
        }
        if (!bl) {
            return false;
        }
        this.linkManager.addLink(bTLink);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addConnection() invoked. Added connection to linkManager " + bTLink.toString());
        }
        return true;
    }

    private void addToLibrary() {
        if (this._manager == null) {
            return;
        }
        if (this._changedSaveDir) {
            try {
                this._manager.moveDataFiles(new File(this._newSaveDir));
            }
            catch (DownloadManagerException downloadManagerException) {
                downloadManagerException.printStackTrace();
            }
        }
        boolean bl = SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue();
        File file = this._manager.getSaveLocation();
        if (file.isFile()) {
            if (bl) {
                this.fileManager.addFileAlways(file);
            } else {
                this.fileManager.addFileIfShared(file);
            }
        } else if (file.isDirectory() && (bl || this.fileManager.isFileInCompletelySharedDirectory(file))) {
            this.fileManager.addSharedFolder(file);
        }
    }

    @Override
    public long getNextTrackerRequestTime() {
        return this._manager != null ? this._manager.getTrackerScrapeResponse().getNextScrapeStartTime() : 0L;
    }

    public TorrentLocation getTorrentLocation() {
        LOG.debug("getTorrentLocation() invoked, forcing null return value.");
        return null;
    }

    private void rechoke() {
        LOG.debug("rechoke() invoked, doing nothing.");
    }

    @Override
    public boolean isPaused() {
        return this.state.get() == Torrent.TorrentState.PAUSED;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManagedTorrent)) {
            return false;
        }
        ManagedTorrent managedTorrent = (ManagedTorrent)object;
        return Arrays.equals(managedTorrent.getInfoHash(), this.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.isDownloading()) {
                return true;
            }
            switch (this.state.get()) {
                case SEEDING: 
                case VERIFYING: 
                case SAVING: {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPausable() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.isDownloading()) {
                return true;
            }
            switch (this.state.get()) {
                case VERIFYING: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean isDownloading() {
        switch (this.state.get()) {
            case CONNECTING: 
            case SCRAPING: 
            case WAITING_FOR_TRACKER: 
            case DOWNLOADING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNumConnections() {
        if (this.getMeasuredBandwidth(true) > 0.0f && this.getNumSeeds() > 0) {
            return this.getNumSeeds();
        }
        return 0;
    }

    @Override
    public int getNumPeers() {
        if (this._manager == null) {
            return 0;
        }
        return this._manager.getNbPeers();
    }

    @Override
    public int getNumSeeds() {
        if (this._manager == null) {
            return 0;
        }
        return this._manager.getNbSeeds();
    }

    @Override
    public int getNumNonInterestingPeers() {
        int n = 0;
        if (this._manager != null && this._manager.getPeerManager() != null && this._manager.getPeerManager().getPeers() != null) {
            for (PEPeer pEPeer : this._manager.getPeerManager().getPeers()) {
                if (pEPeer.isInteresting()) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public int getNumChockingPeers() {
        int n = 0;
        if (this._manager != null && this._manager.getPeerManager() != null && this._manager.getPeerManager().getPeers() != null) {
            for (PEPeer pEPeer : this._manager.getPeerManager().getPeers()) {
                if (pEPeer.isChokingMe()) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public void countDownloaded(int n) {
        LOG.debug("countDownloaded() invoked... (doing nothing)");
    }

    public long getTotalUploaded() {
        if (this._manager == null) {
            return 0L;
        }
        return this._manager.getStats().getTotalDataBytesSent();
    }

    @Override
    public long getTotalDownloaded() {
        if (this._manager == null || this._manager.getStats() == null) {
            if (this._hasBeenPaused) {
                return this._totalDownloaded;
            }
            this._totalDownloaded = 0L;
            return this._totalDownloaded;
        }
        if (!this.isActive()) {
            return this._totalDownloaded;
        }
        if (this._hasBeenPaused) {
            this._totalDownloaded += this._manager.getStats().getTotalGoodDataBytesReceived();
            this._hasBeenPaused = false;
        } else {
            this._totalDownloaded = this._manager.getDiskManager() != null && this._totalDownloaded == 0L ? this._manager.getDiskManager().getTotalLength() - this._manager.getDiskManager().getRemaining() : this._manager.getStats().getTotalGoodDataBytesReceived();
        }
        return this._totalDownloaded;
    }

    @Override
    public float getRatio() {
        if (this._manager != null) {
            DownloadManagerStats downloadManagerStats = this._manager.getStats();
            return (float)((double)downloadManagerStats.getDataSendRate() / ((double)downloadManagerStats.getDataReceiveRate() + 0.01));
        }
        return 0.0f;
    }

    @Override
    public long getAmountLost() {
        if (this._manager == null) {
            return 0L;
        }
        return this._manager.getStats().getDiscarded();
    }

    public boolean hasNonBusyLocations() {
        LOG.debug("hasNonBusyLocations() invoked... (forcing true)");
        return true;
    }

    public long getNextLocationRetryTime() {
        LOG.debug("getNextLocationRetryTime() - never.");
        return Long.MAX_VALUE;
    }

    public boolean shouldStop() {
        return this.getNumConnections() == 0 && this.getNumPeers() == 0 && this.state.get() != Torrent.TorrentState.SEEDING;
    }

    public BTConnectionFetcher getFetcher() {
        LOG.debug("getFetcher() invoked forcing null");
        return null;
    }

    public ScheduledExecutorService getNetworkScheduledExecutorService() {
        LOG.debug("getNetworkScheduledExecutorService() invoked forcing null");
        return null;
    }

    @Override
    public void measureBandwidth() {
        this.linkManager.measureBandwidth();
        if (this._manager == null) {
            return;
        }
    }

    @Override
    public float getMeasuredBandwidth(boolean bl) {
        if (this._manager != null && this._manager.getStats() != null) {
            long l;
            long l2 = l = bl ? this._manager.getStats().getDataReceiveRate() : this._manager.getStats().getDataSendRate();
            if (!bl) {
                this.linkManager.getMeasuredBandwidth(bl);
            }
            return (float)l / 1024.0f;
        }
        return 0.0f;
    }

    @Override
    public int getTriedHostCount() {
        return 5;
    }

    public boolean isUploading() {
        if (this._manager == null) {
            return false;
        }
        return this._manager.getStats().getDataSendRate() > 0L;
    }

    public boolean isSuspended() {
        LOG.debug("isSuspended() invoked. forcing false.");
        return false;
    }

    public File getTorrentDataFile() {
        return this.torrentManager.getSharedTorrentMetaDataFile(this._info);
    }

    public void createTorrentFile() {
        this._torrentFile = this._info.createFileFromRawBytes(SharingSettings.DEFAULT_SAVE_DIR + File.separator + this._info.getName() + ".torrent");
    }

    public void setSaveFile(File file, String string) {
        if (this._manager == null) {
            return;
        }
        this._changedSaveDir = true;
        try {
            this._newSaveDir = file.getCanonicalPath() + File.separator + string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public File getTorrentName() {
        return new File(this._info.getName());
    }

    @Override
    public void destroy() {
        try {
            if (!this._hasBeenPaused && !this.isComplete() && this._manager != null && this._manager.getGlobalManager() != null) {
                this._manager.getGlobalManager().removeDownloadManager(this._manager);
            }
        }
        catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
            globalManagerDownloadRemovalVetoException.printStackTrace();
        }
    }

    public void removeFromAzureus() {
        if (this._manager != null && this._manager.getGlobalManager() != null) {
            try {
                this._manager.getGlobalManager().removeDownloadManager(this._manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                globalManagerDownloadRemovalVetoException.printStackTrace();
            }
        }
    }
}

