/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTDownloaderImpl;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTUploader
implements Uploader,
TorrentEventListener {
    private final ManagedTorrent _torrent;
    private final BTDownloaderImpl _btDownloader;
    private final BTMetaInfo _info;
    private long startTime;
    private long stopTime;
    private final EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher;
    private final ActivityCallback activityCallback;

    BTUploader(ManagedTorrent managedTorrent, BTMetaInfo bTMetaInfo, EventDispatcher<TorrentEvent, TorrentEventListener> eventDispatcher, ActivityCallback activityCallback, BTDownloaderImpl bTDownloaderImpl) {
        this._torrent = managedTorrent;
        this._info = bTMetaInfo;
        this._btDownloader = bTDownloaderImpl;
        this.dispatcher = eventDispatcher;
        this.activityCallback = activityCallback;
        eventDispatcher.addEventListener(this);
    }

    public ManagedTorrent getManagedTorrent() {
        return this._torrent;
    }

    @Override
    public void stop() {
        TorrentEvent torrentEvent = new TorrentEvent(this, TorrentEvent.Type.STOP_REQUESTED, this._torrent);
        this.dispatcher.dispatchEvent(torrentEvent);
    }

    @Override
    public String getFileName() {
        return this._info.getName();
    }

    @Override
    public long getFileSize() {
        return this._info.getFileSystem().getTotalSize();
    }

    @Override
    public FileDesc getFileDesc() {
        return this._info.getFileDesc();
    }

    @Override
    public int getIndex() {
        return 0 - Math.abs(this._info.getURN().hashCode());
    }

    @Override
    public long amountUploaded() {
        return this._torrent.getTotalUploaded();
    }

    @Override
    public long getTotalAmountUploaded() {
        return this._torrent.getTotalUploaded();
    }

    @Override
    public String getHost() {
        return "";
    }

    @Override
    public Uploader.UploadStatus getState() {
        if (!this._torrent.isActive() && this._torrent.isComplete() && this._torrent.getRatio() > 1.0f) {
            return Uploader.UploadStatus.COMPLETE;
        }
        if (this._torrent.isUploading()) {
            return Uploader.UploadStatus.UPLOADING;
        }
        if (this._torrent.isSuspended()) {
            return Uploader.UploadStatus.SUSPENDED;
        }
        return Uploader.UploadStatus.WAITING_REQUESTS;
    }

    @Override
    public Uploader.UploadStatus getLastTransferState() {
        return Uploader.UploadStatus.UPLOADING;
    }

    @Override
    public boolean isChatEnabled() {
        return false;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return false;
    }

    @Override
    public int getGnutellaPort() {
        return 0;
    }

    @Override
    public String getUserAgent() {
        return "";
    }

    @Override
    public int getQueuePosition() {
        return 0;
    }

    @Override
    public boolean isInactive() {
        switch (this._torrent.getState()) {
            case PAUSED: 
            case STOPPED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void measureBandwidth() {
        this._torrent.measureBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        if (!this._torrent.isActive()) {
            return 0.0f;
        }
        return this._torrent.getMeasuredBandwidth(false);
    }

    @Override
    public void handleTorrentEvent(TorrentEvent torrentEvent) {
        if (torrentEvent.getTorrent() != this._torrent) {
            return;
        }
        switch (torrentEvent.getType()) {
            case STARTED: {
                this.torrentStarted();
                break;
            }
            case STOP_APPROVED: {
                this.activityCallback.removeUpload(this);
                break;
            }
            case STOPPED: {
                this.torrentStopped();
                this.dispatcher.removeEventListener(this);
                break;
            }
        }
    }

    @Override
    public float getAverageBandwidth() {
        long l = this.stopTime > 0L ? this.stopTime : System.currentTimeMillis();
        long l2 = l - this.startTime;
        return l2 > 0L ? (float)(this.getTotalAmountUploaded() / l2) : 0.0f;
    }

    private void torrentStarted() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
        this.activityCallback.addUpload(this);
    }

    private void torrentStopped() {
        this.stopTime = System.currentTimeMillis();
    }

    @Override
    public String getCustomIconDescriptor() {
        if (this._info.getFileSystem().getFiles().size() == 1) {
            return null;
        }
        return "";
    }

    @Override
    public UploadType getUploadType() {
        return UploadType.SHARED_FILE;
    }

    @Override
    public boolean isTLSCapable() {
        return false;
    }

    @Override
    public String getAddress() {
        return "torrent upload";
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return null;
    }

    @Override
    public int getNumUploadConnections() {
        return this._torrent.getNumConnections();
    }

    public String getAddressDescription() {
        return null;
    }

    @Override
    public File getFile() {
        return this._torrent.getTorrentDataFile();
    }

    @Override
    public URN getUrn() {
        return this._torrent.getURN();
    }

    @Override
    public float getSeedRatio() {
        return this._torrent.getRatio();
    }

    public BTDownloaderImpl getBTDownloader() {
        return this._btDownloader;
    }
}

