/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.frostwire.bittorrent.AzureusStarter;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.bittorrent.BTContextFactory;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.BTUploader;
import com.limegroup.bittorrent.BTUploaderFactory;
import com.limegroup.bittorrent.FinishedTorrentDownload;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.ManagedTorrentFactory;
import com.limegroup.bittorrent.Torrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.serial.BTDownloadMemento;
import com.limegroup.gnutella.downloader.serial.BTDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NumericBuffer;
import org.limewire.io.InvalidDataException;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTDownloaderImpl
extends AbstractCoreDownloader
implements TorrentEventListener,
BTDownloader {
    private static final Log LOG = LogFactory.getLog(BTDownloaderImpl.class);
    private volatile long startTime;
    private volatile long stopTime;
    private final NumericBuffer<Float> averagedBandwidth = new NumericBuffer(10);
    private volatile boolean finished;
    private volatile Torrent torrent;
    private volatile BTMetaInfo btMetaInfo;
    private volatile TorrentContext torrentContext;
    private volatile TorrentFileSystem torrentFileSystem;
    private volatile URN urn;
    private final DownloadManager downloadManager;
    private final IncompleteFileManager incompleteFileManager;
    private final Provider<TorrentManager> torrentManager;
    private final BTUploaderFactory btUploaderFactory;
    private final ManagedTorrentFactory managedTorrentFactory;
    private final BTContextFactory btContextFactory;
    private boolean _cancelled;
    private boolean _overwrite;

    @Inject
    BTDownloaderImpl(BTContextFactory bTContextFactory, SaveLocationManager saveLocationManager, Provider<TorrentManager> provider, BTUploaderFactory bTUploaderFactory, DownloadManager downloadManager, ManagedTorrentFactory managedTorrentFactory) {
        super(saveLocationManager);
        this.downloadManager = downloadManager;
        this.torrentManager = provider;
        this.btUploaderFactory = bTUploaderFactory;
        this.incompleteFileManager = downloadManager.getIncompleteFileManager();
        this.managedTorrentFactory = managedTorrentFactory;
        this.btContextFactory = bTContextFactory;
        this.setCancelled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initBtMetaInfo(BTMetaInfo bTMetaInfo) {
        this.btMetaInfo = bTMetaInfo;
        this.torrentFileSystem = bTMetaInfo.getFileSystem();
        this.urn = bTMetaInfo.getURN();
        BTDownloaderImpl bTDownloaderImpl = this;
        synchronized (bTDownloaderImpl) {
            this.setDefaultFileName(bTMetaInfo.getName());
        }
        this.torrentContext = this.btContextFactory.createBTContext(bTMetaInfo);
        this.torrent = this.managedTorrentFactory.create(this.torrentContext, this._overwrite);
    }

    @Override
    public void stop() {
        if (this.torrent.isActive() && this.torrent.getState() != Torrent.TorrentState.SEEDING) {
            this.torrent.stop();
        } else if (this.isInactive()) {
            this.downloadManager.remove(this, true);
        }
    }

    @Override
    public void pause() {
        if (this.torrent.isPausable()) {
            this.torrent.pause();
        }
    }

    @Override
    public boolean isPaused() {
        return this.torrent.isPaused();
    }

    @Override
    public boolean isPausable() {
        return this.torrent.isPausable();
    }

    @Override
    public boolean isInactive() {
        return this.isResumable() || this.torrent.getState() == Torrent.TorrentState.QUEUED || this.torrent.getState() == Torrent.TorrentState.DISK_PROBLEM || this.torrent.getState() == Torrent.TorrentState.INVALID;
    }

    @Override
    public boolean isLaunchable() {
        return this.torrentFileSystem.getFiles().size() == 1 && this.torrentContext.getDiskManager().getLastVerifiedOffset() > 0L;
    }

    @Override
    public boolean isResumable() {
        switch (this.torrent.getState()) {
            case PAUSED: 
            case TRACKER_FAILURE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean resume() {
        return this.torrent.resume();
    }

    @Override
    public File getFile() {
        if (this.torrent.isComplete()) {
            return this.torrentFileSystem.getCompleteFile();
        }
        return this.torrentFileSystem.getBaseFile();
    }

    @Override
    public File getDownloadFragment() {
        if (!this.isLaunchable()) {
            return null;
        }
        if (this.torrent.isComplete()) {
            return this.getFile();
        }
        long l = this.torrentContext.getDiskManager().getLastVerifiedOffset();
        if (l <= 0L) {
            return null;
        }
        File file = new File(this.torrentFileSystem.getBaseFile().getParent(), "Preview-" + this.torrentFileSystem.getBaseFile().getName());
        if (FileUtils.copy(this.torrentFileSystem.getBaseFile(), l, file) <= 0L) {
            return null;
        }
        return file;
    }

    @Override
    public Downloader.DownloadStatus getState() {
        if (this.torrent.isComplete()) {
            return Downloader.DownloadStatus.COMPLETE;
        }
        switch (this.torrent.getState()) {
            case WAITING_FOR_TRACKER: {
                return Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS;
            }
            case VERIFYING: {
                return Downloader.DownloadStatus.RESUMING;
            }
            case CONNECTING: {
                return Downloader.DownloadStatus.CONNECTING;
            }
            case DOWNLOADING: {
                return Downloader.DownloadStatus.DOWNLOADING;
            }
            case SAVING: {
                return Downloader.DownloadStatus.SAVING;
            }
            case SEEDING: {
                return Downloader.DownloadStatus.COMPLETE;
            }
            case QUEUED: {
                return Downloader.DownloadStatus.QUEUED;
            }
            case PAUSED: {
                return Downloader.DownloadStatus.PAUSED;
            }
            case STOPPED: {
                return Downloader.DownloadStatus.ABORTED;
            }
            case DISK_PROBLEM: {
                return Downloader.DownloadStatus.DISK_PROBLEM;
            }
            case TRACKER_FAILURE: {
                return Downloader.DownloadStatus.WAITING_FOR_USER;
            }
            case SCRAPING: {
                return Downloader.DownloadStatus.ITERATIVE_GUESSING;
            }
            case INVALID: {
                return Downloader.DownloadStatus.INVALID;
            }
        }
        throw new IllegalStateException("unknown torrent state");
    }

    private long getTotalAmountDownloaded() {
        return this.torrent.getTotalDownloaded();
    }

    @Override
    public int getRemainingStateTime() {
        if (this.getState() != Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS) {
            return 0;
        }
        return Math.max(0, (int)(this.torrent.getNextTrackerRequestTime() - System.currentTimeMillis()) / 1000);
    }

    @Override
    public long getContentLength() {
        return this.torrentFileSystem.getTotalSize();
    }

    @Override
    public long getAmountRead() {
        if (this.btMetaInfo == null) {
            return this.getContentLength();
        }
        return this.torrent.getTotalDownloaded();
    }

    @Override
    public String getVendor() {
        return "";
    }

    @Override
    public Endpoint getChatEnabledHost() {
        return null;
    }

    @Override
    public boolean hasChatEnabledHost() {
        return false;
    }

    @Override
    public void discardCorruptDownload(boolean bl) {
    }

    @Override
    public RemoteFileDesc getBrowseEnabledHost() {
        return null;
    }

    @Override
    public boolean hasBrowseEnabledHost() {
        return false;
    }

    @Override
    public int getQueuePosition() {
        return 1;
    }

    @Override
    public int getNumberOfAlternateLocations() {
        return this.getPossibleHostCount();
    }

    @Override
    public int getNumberOfInvalidAlternateLocations() {
        return 0;
    }

    @Override
    public int getPossibleHostCount() {
        return this.torrent.getNumPeers();
    }

    @Override
    public int getBusyHostCount() {
        return this.torrent.getNumNonInterestingPeers();
    }

    @Override
    public int getQueuedHostCount() {
        return this.torrent.getNumChockingPeers();
    }

    @Override
    public GUID getQueryGUID() {
        return null;
    }

    @Override
    public boolean isCompleted() {
        switch (this.torrent.getState()) {
            case TRACKER_FAILURE: 
            case SEEDING: 
            case STOPPED: 
            case DISK_PROBLEM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBeRemoved() {
        switch (this.torrent.getState()) {
            case SEEDING: 
            case DISK_PROBLEM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public long getAmountVerified() {
        return this.torrentContext.getDiskManager().getVerifiedBlockSize();
    }

    @Override
    public int getChunkSize() {
        return this.btMetaInfo.getPieceLength();
    }

    @Override
    public long getAmountLost() {
        return this.torrent.getAmountLost();
    }

    @Override
    public void measureBandwidth() {
        this.torrent.measureBandwidth();
        this.averagedBandwidth.add(Float.valueOf(this.torrent.getMeasuredBandwidth(true)));
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        if (this.averagedBandwidth.size() < 3) {
            throw new InsufficientDataException();
        }
        return this.averagedBandwidth.average().floatValue();
    }

    @Override
    public float getAverageBandwidth() {
        long l = this.stopTime > 0L ? this.stopTime : System.currentTimeMillis();
        long l2 = l - this.startTime;
        return l2 > 0L ? (float)(this.getTotalAmountDownloaded() / l2) : 0.0f;
    }

    @Override
    public boolean isRelocatable() {
        return !this.isCompleted();
    }

    @Override
    public void setSaveFile(File file, String string, boolean bl) throws SaveLocationException {
        super.setSaveFile(file, string, bl, true);
        this.torrentFileSystem.setCompleteFile(new File(file, string));
        ((ManagedTorrent)this.torrent).setSaveFile(file, string);
    }

    @Override
    public File getSaveFile() {
        return this.torrent.getTorrentName();
    }

    @Override
    protected File getDefaultSaveFile() {
        return null;
    }

    @Override
    public URN getSha1Urn() {
        return this.urn;
    }

    @Override
    public int getAmountPending() {
        return this.torrentContext.getDiskManager().getAmountPending();
    }

    @Override
    public int getNumPeers() {
        return this.torrent.getNumPeers();
    }

    @Override
    public int getNumSeeds() {
        return this.torrent.getNumSeeds();
    }

    @Override
    public int getNumHosts() {
        return this.torrent.getNumConnections();
    }

    @Override
    public void handleTorrentEvent(TorrentEvent torrentEvent) {
        if (torrentEvent.getTorrent() != this.torrent) {
            return;
        }
        switch (torrentEvent.getType()) {
            case STARTED: {
                this.torrentStarted();
                break;
            }
            case COMPLETE: {
                this.torrentComplete();
                break;
            }
            case STOPPED: {
                this.torrentStopped(torrentEvent.getDescription());
                break;
            }
        }
    }

    private void torrentComplete() {
        this.stopTime = System.currentTimeMillis();
        this.incompleteFileManager.removeTorrentEntry(this.urn);
        this.downloadManager.remove(this, true);
    }

    private void torrentStarted() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
    }

    private void torrentStopped(String string) {
        LOG.debug("TIME: " + System.currentTimeMillis() + " torrentStopped (isResumable? before or after pause?)");
        if (this.stopTime == 0L) {
            if (string != null) {
                this.setAttribute("CIK", string, false);
            }
            this.averagedBandwidth.clear();
            boolean bl = !this.getCancelled() && !this.finished;
            this.stopTime = System.currentTimeMillis();
            this.downloadManager.remove(this, !bl);
            this.torrent.destroy();
        }
    }

    @Override
    public void initialize() {
        this.torrentManager.get().addEventListener(this);
        this.incompleteFileManager.addTorrentEntry(this.urn);
    }

    @Override
    public void addTorrentEventListener(TorrentEventListener torrentEventListener) {
        if (this.torrentManager != null) {
            this.torrentManager.get().addEventListener(torrentEventListener);
        }
    }

    @Override
    public void startDownload() {
        this.btUploaderFactory.createBTUploader((ManagedTorrent)this.torrent, this.btMetaInfo, this);
        this.torrent.start();
    }

    @Override
    public BTUploader createUploader() {
        BTUploader bTUploader = this.btUploaderFactory.createBTUploader((ManagedTorrent)this.torrent, this.btMetaInfo, this);
        this.torrent.start();
        return bTUploader;
    }

    @Override
    public void handleInactivity() {
    }

    @Override
    public boolean shouldBeRestarted() {
        return this.getState() == Downloader.DownloadStatus.QUEUED && AzureusStarter.allowNewTorrent();
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public boolean isQueuable() {
        return !this.isResumable();
    }

    @Override
    public boolean conflicts(URN uRN, long l, File ... fileArray) {
        if (this.urn.equals(uRN)) {
            return true;
        }
        for (File file : fileArray) {
            if (!this.conflictsSaveFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean conflictsSaveFile(File file) {
        return this.torrentFileSystem.conflicts(file);
    }

    @Override
    public boolean conflictsWithIncompleteFile(File file) {
        return this.torrentFileSystem.conflictsIncomplete(file);
    }

    @Override
    public synchronized void finish() {
        this.finished = true;
        this.torrentManager.get().removeEventListener(this);
        this.torrent = new FinishedTorrentDownload(this.torrent);
        this.btMetaInfo = null;
    }

    public String toString() {
        return "downloader facade for " + this.torrentFileSystem.getCompleteFile().getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Downloader)) {
            return false;
        }
        Downloader downloader = (Downloader)object;
        return this.getSha1Urn().equals(downloader.getSha1Urn());
    }

    @Override
    public int getTriedHostCount() {
        return this.torrent.getTriedHostCount();
    }

    @Override
    public String getCustomIconDescriptor() {
        if (this.torrentFileSystem.getFiles().size() == 1) {
            return null;
        }
        return "";
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.BTDOWNLOADER;
    }

    @Override
    protected DownloadMemento createMemento() {
        return new BTDownloadMementoImpl();
    }

    @Override
    protected void fillInMemento(DownloadMemento downloadMemento) {
        super.fillInMemento(downloadMemento);
        BTDownloadMemento bTDownloadMemento = (BTDownloadMemento)downloadMemento;
        bTDownloadMemento.setBtMetaInfoMemento(this.btMetaInfo.toMemento());
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        super.initFromMemento(downloadMemento);
        BTDownloadMemento bTDownloadMemento = (BTDownloadMemento)downloadMemento;
        this.initBtMetaInfo(new BTMetaInfo(bTDownloadMemento.getBtMetaInfoMemento()));
    }

    public void setCancelled(boolean bl) {
        this._cancelled = bl;
    }

    public boolean getCancelled() {
        return this._cancelled;
    }

    public void removeFromDownloadManager() {
        Torrent torrent;
        this.setCancelled(true);
        this.finished = true;
        this.torrentStopped(null);
        if (this.torrent instanceof ManagedTorrent) {
            ((ManagedTorrent)this.torrent).removeFromAzureus();
        } else if (this.torrent instanceof FinishedTorrentDownload && (torrent = ((FinishedTorrentDownload)this.torrent).getInnerTorrent()) != null && torrent instanceof ManagedTorrent) {
            ((ManagedTorrent)torrent).removeFromAzureus();
        }
    }

    @Override
    public void setOverwrite(boolean bl) {
        this._overwrite = bl;
    }

    public boolean getOverwrite() {
        return this._overwrite;
    }
}

