/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.gnutella.security.SHA1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.BEncoder;
import org.limewire.util.CommonUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTDataImpl
implements BTData {
    private final String announce;
    private byte[] pieces;
    private final Long pieceLength;
    private byte[] infoHash;
    private final String name;
    private final Long length;
    private List<BTData.BTFileData> files;
    private final Set<String> folders;
    private final boolean isPrivate;

    public BTDataImpl(List<BTData.BTFileData> list, Set<String> set, BTData bTData) throws ValueException {
        this.announce = bTData.getAnnounce();
        this.infoHash = bTData.getInfoHash();
        this.isPrivate = bTData.isPrivate();
        this.pieces = bTData.getPieces();
        this.pieceLength = bTData.getPieceLength();
        this.name = bTData.getName();
        this.length = bTData.getLength();
        this.files = list;
        this.folders = set;
    }

    public BTDataImpl(Map<?, ?> map) throws ValueException {
        Object object = map.get("announce");
        if (!(object instanceof byte[])) {
            throw new ValueException("announce missing or invalid!");
        }
        this.announce = StringUtils.getASCIIString((byte[])object);
        object = map.get("info");
        if (object == null || !(object instanceof Map)) {
            throw new ValueException("info missing or invalid!");
        }
        Map map2 = (Map)object;
        this.infoHash = this.calculateInfoHash(map2);
        object = map2.get("private");
        this.isPrivate = object instanceof Long ? ((Long)object).intValue() == 1 : false;
        object = map2.get("pieces");
        if (!(object instanceof byte[])) {
            throw new ValueException("info->piece missing!");
        }
        this.pieces = (byte[])object;
        object = map2.get("piece length");
        if (!(object instanceof Long)) {
            throw new ValueException("info->'piece length' missing!");
        }
        this.pieceLength = (Long)object;
        object = map2.get("name.utf-8");
        this.name = this.getPreferredString(map2, "name");
        if (this.name == null || this.name.length() == 0) {
            throw new ValueException("no valid name!");
        }
        if (map2.containsKey("length") == map2.containsKey("files")) {
            throw new ValueException("info->length & info.files can't both exist or not exist!");
        }
        object = map2.get("length");
        if (object instanceof Long) {
            this.length = (Long)object;
            if (this.length < 0L) {
                throw new ValueException("invalid length value");
            }
        } else {
            if (object != null) {
                throw new ValueException("info->length is non-null, but not a Long!");
            }
            this.length = null;
        }
        if ((object = map2.get("files")) instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                throw new ValueException("empty file list");
            }
            this.files = new ArrayList<BTData.BTFileData>(list.size());
            this.folders = new HashSet<String>();
            for (Object e : list) {
                if (!(e instanceof Map)) {
                    throw new ValueException("info->files[x] not a Map!");
                }
                Map map3 = (Map)e;
                object = map3.get("length");
                if (!(object instanceof Long)) {
                    throw new ValueException("info->files[x].length not a Long!");
                }
                Long l = (Long)object;
                if (l < 0L) {
                    throw new ValueException("invalid length");
                }
                boolean bl = true;
                try {
                    this.parseFiles(map3, l, this.files, this.folders, true);
                    bl = false;
                }
                catch (ValueException valueException) {
                    // empty catch block
                }
                if (!bl) continue;
                this.parseFiles(map3, l, this.files, this.folders, false);
            }
        } else {
            if (object != null) {
                throw new ValueException("info->files is non-null, but not a list!");
            }
            this.files = null;
            this.folders = null;
        }
        if (this.files == null) {
            this.files = new ArrayList<BTData.BTFileData>(1);
            this.files.add(new BTData.BTFileData(this.length, this.name));
        }
    }

    private void parseFiles(Map<?, ?> map, Long l, List<BTData.BTFileData> list, Set<String> set, boolean bl) throws ValueException {
        Object obj = map.get("path" + (bl ? ".utf-8" : ""));
        if (!(obj instanceof List)) {
            throw new ValueException("info->files[x].path[.utf-8] not a List!");
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.parseFileList((List)obj, hashSet, true);
        if (string == null) {
            throw new ValueException("info->files[x].path[-utf-8] not valid!");
        }
        set.addAll(hashSet);
        list.add(new BTData.BTFileData(l, string));
    }

    private String parseFileList(List<?> list, Set<String> set, boolean bl) throws ValueException {
        if (list.isEmpty()) {
            throw new ValueException("empty paths list");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof byte[])) {
                throw new ValueException("info->files[x]->path[.utf-8][x] not a byte[]!");
            }
            String string = bl ? StringUtils.getUTF8String((byte[])obj) : StringUtils.getASCIIString((byte[])obj);
            if (string.length() == 0) {
                throw new ValueException("empty path element");
            }
            stringBuilder.append(File.separator);
            stringBuilder.append(CommonUtils.convertFileName(string));
            if (!iterator.hasNext()) continue;
            set.add(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private String getPreferredString(Map<?, ?> map, String string) {
        String string2 = null;
        Object obj = map.get(string + ".utf-8");
        if (obj instanceof byte[]) {
            try {
                string2 = new String((byte[])obj, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string2 == null && (obj = map.get(string)) instanceof byte[]) {
            string2 = StringUtils.getASCIIString((byte[])obj);
        }
        return string2;
    }

    private byte[] calculateInfoHash(Map<?, ?> map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BEncoder.getEncoder(byteArrayOutputStream, true, false, "UTF-8").encodeDict(map);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        SHA1 sHA1 = new SHA1();
        return sHA1.digest(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String getAnnounce() {
        return this.announce;
    }

    @Override
    public List<BTData.BTFileData> getFiles() {
        return this.files;
    }

    @Override
    public Set<String> getFolders() {
        return this.folders;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public byte[] getInfoHash() {
        return this.infoHash;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public byte[] getPieces() {
        return this.pieces;
    }

    @Override
    public void clearPieces() {
        this.pieces = null;
    }
}

