/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTChannelWriter;
import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.BTLinkListener;
import com.limegroup.bittorrent.BTMessageHandler;
import com.limegroup.bittorrent.BTMessageWriter;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.PieceReadListener;
import com.limegroup.bittorrent.PieceSendListener;
import com.limegroup.bittorrent.SimpleBandwidthTracker;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import com.limegroup.bittorrent.messages.BTBitField;
import com.limegroup.bittorrent.messages.BTCancel;
import com.limegroup.bittorrent.messages.BTChoke;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.bittorrent.messages.BTInterested;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BTNotInterested;
import com.limegroup.bittorrent.messages.BTPieceMessage;
import com.limegroup.bittorrent.messages.BTRequest;
import com.limegroup.bittorrent.messages.BTUnchoke;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTMessageReader;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.uploader.UploadSlotListener;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;
import org.limewire.collection.NECallable;
import org.limewire.io.IOUtils;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ThrottleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTConnection
implements UploadSlotListener,
BTMessageHandler,
BTLink,
PieceSendListener,
PieceReadListener {
    private static final Log LOG = LogFactory.getLog(BTConnection.class);
    private static final int MAX_BLOCK_SIZE = 65536;
    private static final int MAX_REQUESTS = 4;
    private static final long MIN_RETRYABLE_LIFE_TIME = 60000L;
    private static final int CONNECTION_TIMEOUT = 125000;
    private AbstractNBSocket _socket;
    private final ChannelReadObserver _reader;
    private final BTChannelWriter _writer;
    private volatile BitSet _availableRanges;
    private volatile BitField _available;
    private final Set<BTInterval> _requesting;
    private final Set<BTInterval> _requested;
    private final TorrentContext context;
    private final TorrentLocation _endpoint;
    private final BandwidthManager bwManager;
    private final UploadSlotManager usManager;
    private boolean _isChoked;
    private volatile boolean _isChoking;
    private boolean _isInterested;
    private volatile boolean _isInteresting;
    private long _startTime;
    private int numMissing;
    private int unchokeRound;
    private volatile boolean usingSlot;
    private SimpleBandwidthTracker up;
    private SimpleBandwidthTracker downShort;
    private SimpleBandwidthTracker downLong;
    private volatile boolean closing;
    private Runnable slotReleaser;
    private Runnable slotNotifier;
    private BTLinkListener listener;
    private ScheduledExecutorService invoker;

    public BTConnection(TorrentContext torrentContext, TorrentLocation torrentLocation, BandwidthManager bandwidthManager, UploadSlotManager uploadSlotManager) {
        this._endpoint = torrentLocation;
        this.context = torrentContext;
        this.bwManager = bandwidthManager;
        this.usManager = uploadSlotManager;
        this._availableRanges = new BitSet(torrentContext.getMetaInfo().getNumBlocks());
        this._available = new BitFieldSet(this._availableRanges, torrentContext.getMetaInfo().getNumBlocks());
        this._requesting = new HashSet<BTInterval>();
        this._requested = new HashSet<BTInterval>();
        this._isChoked = true;
        this._isChoking = true;
        this._isInterested = false;
        this._isInteresting = false;
        this.up = new SimpleBandwidthTracker();
        this.downShort = new SimpleBandwidthTracker(1000);
        this.downLong = new SimpleBandwidthTracker(5000);
        this._writer = new BTMessageWriter(this, this);
        this._reader = new BTMessageReader(this, this, NIODispatcher.instance().getScheduledExecutorService(), NIODispatcher.instance().getBufferCache());
    }

    public void init(AbstractNBSocket abstractNBSocket, BTLinkListener bTLinkListener, ScheduledExecutorService scheduledExecutorService) {
        if (this.closing) {
            return;
        }
        this._socket = abstractNBSocket;
        try {
            this._socket.setSoTimeout(125000);
        }
        catch (SocketException socketException) {
            this.shutdown();
            return;
        }
        this.listener = bTLinkListener;
        this.invoker = scheduledExecutorService;
        this._startTime = System.currentTimeMillis();
        this._writer.init(scheduledExecutorService, 120000, this.bwManager);
        ThrottleReader throttleReader = new ThrottleReader(this.bwManager.getReadThrottle());
        this._reader.setReadChannel(throttleReader);
        throttleReader.interestRead(true);
        this._socket.setReadObserver(this._reader);
        this._socket.setWriteObserver(this._writer);
        if (this.context.getDiskManager().getVerifiedBlockSize() > 0L) {
            this.numMissing = this.context.getDiskManager().getNumMissing(this._available);
            this.sendBitfield();
        }
    }

    @Override
    public boolean isChoked() {
        return this._isChoked;
    }

    @Override
    public boolean isChoking() {
        return this._isChoking;
    }

    @Override
    public boolean isInterested() {
        return this._isInterested;
    }

    @Override
    public boolean shouldBeInterested() {
        return this.numMissing > 0;
    }

    @Override
    public boolean isInteresting() {
        return this._isInteresting;
    }

    @Override
    public boolean isWorthRetrying() {
        return System.currentTimeMillis() - this._startTime > 60000L;
    }

    @Override
    public TorrentLocation getEndpoint() {
        return this._endpoint;
    }

    private void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this._socket == null) {
            return;
        }
        IOUtils.close(this._socket);
        this.clearRequests();
        this.cancelSlotRequest();
        this.listener.linkClosed(this);
    }

    private void cancelSlotRequest() {
        if (this.usingSlot) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " cancelling slot request");
            }
            this.usManager.cancelRequest(this);
        }
        this.usingSlot = false;
    }

    @Override
    public float getMeasuredBandwidth(boolean bl, boolean bl2) {
        SimpleBandwidthTracker simpleBandwidthTracker = !bl ? this.up : (bl2 ? this.downShort : this.downLong);
        simpleBandwidthTracker.measureBandwidth();
        try {
            return simpleBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
    }

    @Override
    public void readBytes(int n) {
        this.downShort.count(n);
        this.downLong.count(n);
        this.listener.countDownloaded(n);
    }

    @Override
    public void wroteBytes(int n) {
        this.up.count(n);
        this.context.getMetaInfo().countUploaded(n);
    }

    @Override
    public void handleIOException(IOException iOException) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(iOException);
        }
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    public void choke() {
        this._requested.clear();
        if (!this._isChoked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " choking");
            }
            this.cancelSlotRequest();
            this._writer.enqueue(BTChoke.createMessage());
            this._isChoked = true;
        }
    }

    @Override
    public void unchoke(int n) {
        this.unchokeRound = n;
        if (this._isChoked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " unchoking, round " + n);
            }
            this._writer.enqueue(BTUnchoke.createMessage());
            this._isChoked = false;
        }
    }

    @Override
    public int getUnchokeRound() {
        return this.unchokeRound;
    }

    @Override
    public void clearUnchokeRound() {
        this.unchokeRound = -1;
    }

    private void sendInterested() {
        if (!this._isInteresting) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " we become interested");
            }
            this._writer.enqueue(BTInterested.createMessage());
            this._isInteresting = true;
        }
    }

    void sendNotInterested() {
        this.cancelAllRequests();
        if (this._isInteresting) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " we lose interest");
            }
            this._writer.enqueue(BTNotInterested.createMessage());
            this._isInteresting = false;
        }
    }

    @Override
    public void sendHave(BTHave bTHave) {
        int n = bTHave.getPieceNum();
        if (!this._available.get(n)) {
            ++this.numMissing;
            this._writer.enqueue(bTHave);
        }
        if (!this.context.getDiskManager().containsAnyWeMiss(this._available)) {
            this.sendNotInterested();
            return;
        }
        Iterator<BTInterval> iterator = this._requesting.iterator();
        while (iterator.hasNext()) {
            BTInterval bTInterval = iterator.next();
            if (bTInterval.getId() != n) continue;
            iterator.remove();
            this.sendCancel(bTInterval);
        }
        if (!this._isChoking) {
            this.request();
        }
    }

    private void sendBitfield() {
        this._writer.enqueue(BTBitField.createMessage(this.context));
    }

    private void sendCancel(BTInterval bTInterval) {
        this._writer.enqueue(new BTCancel(bTInterval));
    }

    private void cancelAllRequests() {
        for (BTInterval bTInterval : this._requesting) {
            this.sendCancel(bTInterval);
        }
        this.clearRequests();
    }

    @Override
    public void pieceSent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " piece sent");
        }
        this.usingSlot = false;
        this.usManager.requestDone(this);
        this.readyForWriting();
    }

    private void readyForWriting() {
        if (this._isChoked || this._requested.isEmpty()) {
            return;
        }
        this.usingSlot = true;
        int n = this.usManager.requestSlot(this, !this.context.getDiskManager().isComplete());
        if (n == -1) {
            this.usingSlot = false;
            this.choke();
        } else if (n == 0) {
            this.beginPieceSend();
        }
    }

    private void beginPieceSend() {
        if (this._isChoked || this._requested.isEmpty()) {
            return;
        }
        Iterator<BTInterval> iterator = this._requested.iterator();
        BTInterval bTInterval = iterator.next();
        iterator.remove();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " requesting disk read for " + bTInterval);
        }
        this.context.getDiskManager().requestPieceRead(bTInterval, this);
    }

    @Override
    public void pieceRead(final BTInterval bTInterval, final byte[] byArray) {
        this.bwManager.applyUploadRate();
        Runnable runnable = new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("disk read done for " + bTInterval);
                }
                BTConnection.this._writer.enqueue(new BTPieceMessage(bTInterval, byArray));
            }
        };
        this.invoker.execute(runnable);
    }

    @Override
    public void pieceReadFailed(BTInterval bTInterval) {
        this.cancelSlotRequest();
    }

    private void clearRequests() {
        for (BTInterval bTInterval : this._requesting) {
            this.context.getDiskManager().releaseInterval(bTInterval);
        }
        this._requesting.clear();
    }

    @Override
    public void processMessage(BTMessage bTMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " handling message " + bTMessage);
        }
        switch (bTMessage.getType()) {
            case 0: {
                this._isChoking = true;
                this.clearRequests();
                break;
            }
            case 1: {
                this._isChoking = false;
                if (!this._isInteresting) break;
                this.request();
                break;
            }
            case 2: {
                this._isInterested = true;
                this.listener.linkInterested(this);
                break;
            }
            case 3: {
                this._isInterested = false;
                this._requested.clear();
                this.listener.linkNotInterested(this);
                if (!this.context.getDiskManager().isComplete()) break;
                this.close();
                break;
            }
            case 5: {
                this.handleBitField((BTBitField)bTMessage);
                break;
            }
            case 4: {
                this.handleHave((BTHave)bTMessage);
                break;
            }
            case 6: {
                this.handleRequest((BTRequest)bTMessage);
                break;
            }
            case 8: {
                this.handleCancel((BTCancel)bTMessage);
            }
        }
    }

    private void handleCancel(BTCancel bTCancel) {
        BTInterval bTInterval = bTCancel.getInterval();
        this._requested.remove(bTInterval);
        Iterator<BTInterval> iterator = this._requested.iterator();
        while (iterator.hasNext()) {
            BTInterval bTInterval2 = iterator.next();
            if (bTInterval.getId() != bTInterval2.getId() || bTInterval.getLow() > bTInterval2.getHigh() || bTInterval2.getLow() > bTInterval.getHigh()) continue;
            iterator.remove();
        }
    }

    private void handleRequest(BTRequest bTRequest) {
        if (this._isChoked) {
            return;
        }
        BTInterval bTInterval = bTRequest.getInterval();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " got request for " + bTInterval);
        }
        if (bTInterval.getId() > this.context.getMetaInfo().getNumBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got bad request " + bTRequest);
            }
            return;
        }
        if (bTInterval.getHigh() - bTInterval.getLow() + 1L > 65536L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got long request");
            }
            return;
        }
        if (this.context.getDiskManager().hasBlock(bTInterval.getId())) {
            this._requested.add(bTInterval);
        }
        if (!this._requested.isEmpty() && !this.usingSlot) {
            this.readyForWriting();
        }
    }

    @Override
    public boolean startReceivingPiece(BTInterval bTInterval) {
        if (!this._requesting.remove(bTInterval)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received unexpected range " + bTInterval + " from " + this._socket.getInetAddress() + " expected " + this._requesting);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " starting to receive piece " + bTInterval);
        }
        return true;
    }

    @Override
    public void finishReceivingPiece() {
        this.request();
    }

    void request() {
        BTInterval bTInterval;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting ranges from " + this);
        }
        if (this._requesting.size() > 1) {
            return;
        }
        while (this._requesting.size() < 4 && (bTInterval = this.context.getDiskManager().leaseRandom(this._available, this._requesting)) != null) {
            this._requesting.add(bTInterval);
            this._writer.enqueue(new BTRequest(bTInterval));
        }
    }

    @Override
    public void handlePiece(NECallable<BTPiece> nECallable) {
        this.context.getDiskManager().writeBlock(nECallable);
    }

    private void handleBitField(BTBitField bTBitField) {
        ByteBuffer byteBuffer = bTBitField.getPayload();
        int n = this.context.getMetaInfo().getNumBlocks();
        int n2 = (n + 7) / 8;
        if (byteBuffer.remaining() != n2) {
            this.handleIOException(new BadBTMessageException("bad bitfield received! " + this._endpoint.toString()));
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(128 >>> i % 8);
            if ((by & byteBuffer.get(i / 8)) != by) continue;
            if (!bl && !this.context.getDiskManager().hasBlock(i)) {
                bl = true;
            }
            this._availableRanges.set(i);
        }
        if (this._available.cardinality() == n) {
            this._availableRanges = null;
            this._available = this.context.getFullBitField();
            this.numMissing = 0;
        } else {
            this.numMissing = this.context.getDiskManager().getNumMissing(this._available);
        }
        if (bl) {
            this.sendInterested();
        }
    }

    private void handleHave(BTHave bTHave) {
        int n = bTHave.getPieceNum();
        if (n >= this._available.maxSize()) {
            this.shutdown();
            return;
        }
        if (this._available.get(n)) {
            return;
        }
        TorrentDiskManager torrentDiskManager = this.context.getDiskManager();
        this._availableRanges.set(n);
        if (torrentDiskManager.hasBlock(n)) {
            --this.numMissing;
        } else {
            this.sendInterested();
        }
        if (this._available.cardinality() == this.context.getMetaInfo().getNumBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " now has everything");
            }
            this._availableRanges = null;
            this._available = this.context.getFullBitField();
            this.numMissing = 0;
            if (torrentDiskManager.isComplete()) {
                this.shutdown();
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BTConnection) {
            BTConnection bTConnection = (BTConnection)object;
            return bTConnection._endpoint.equals(this._endpoint);
        }
        return false;
    }

    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder(this._socket == null ? "new" : "(" + this.getHost());
        if (this.isChoked()) {
            stringBuilder.append(" Ced");
        }
        if (this.isChoking()) {
            stringBuilder.append(" Cing");
        }
        if (this.isInterested()) {
            stringBuilder.append(" Ied");
        }
        if (this.isInteresting()) {
            stringBuilder.append(" Iing");
        }
        if (this.isSeed()) {
            stringBuilder.append(" Seed");
        }
        if (this.usingSlot) {
            stringBuilder.append(" U");
        }
        if ((n2 = this._requested.size()) > 0) {
            stringBuilder.append(" Q").append(n2);
        }
        if ((n = this._requesting.size()) > 0) {
            stringBuilder.append(" D").append(n);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String getHost() {
        return this._socket.getInetAddress().getHostAddress();
    }

    @Override
    public void releaseSlot() {
        this.invoker.execute(this.getSlotReleaser());
    }

    private Runnable getSlotReleaser() {
        if (this.slotReleaser == null) {
            this.slotReleaser = new Runnable(){

                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(BTConnection.this + " releasing slot");
                    }
                    BTConnection.this.choke();
                }
            };
        }
        return this.slotReleaser;
    }

    @Override
    public void slotAvailable() {
        this.invoker.execute(this.getSlotNotifier());
    }

    private Runnable getSlotNotifier() {
        if (this.slotNotifier == null) {
            this.slotNotifier = new Runnable(){

                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(BTConnection.this + " got available slot");
                    }
                    BTConnection.this.beginPieceSend();
                }
            };
        }
        return this.slotNotifier;
    }

    @Override
    public float getAverageBandwidth() {
        return this.up.getAverageBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.up.getMeasuredBandwidth();
    }

    @Override
    public void measureBandwidth() {
        this.up.measureBandwidth();
    }

    @Override
    public boolean isSeed() {
        return this._available.cardinality() == this.context.getMetaInfo().getNumBlocks();
    }

    public boolean isBusy() {
        return !this.isInteresting();
    }

    @Override
    public boolean isUploading() {
        return this.isInterested() && !this.isChoked();
    }

    @Override
    public void suspendTraffic() {
        this.sendNotInterested();
        this.choke();
    }
}

