/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.frostwire.CoreFrostWireUtils;
import com.frostwire.bittorrent.AzureusStarter;
import com.frostwire.updates.InstallerMetaData;
import com.frostwire.updates.UpdateMessage;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.limewire.util.OSUtils;

public class InstallerUpdater
implements Runnable,
DownloadManagerListener {
    private DownloadManager _manager = null;
    private UpdateMessage _updateMessage;
    private File _executableFile;

    public InstallerUpdater(UpdateMessage updateMessage) {
        this._updateMessage = updateMessage;
    }

    public void start() {
        new Thread((Runnable)this, "InstallerUpdater").start();
    }

    public void run() {
        if (!UpdateSettings.AUTOMATIC_INSTALLER_DOWNLOAD.getValue()) {
            return;
        }
        if (this.checkIfDownloaded()) {
            this.showUpdateMessage();
        } else {
            File file = this.downloadDotTorrent();
            try {
                CoreFrostWireUtils.waitForAzureusCoreToStart();
                this._manager = CoreFrostWireUtils.startTorrentDownload(file.getAbsolutePath(), SharingUtils.APPLICATION_SPECIAL_SHARE.getAbsolutePath(), this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void showUpdateMessage() {
        if (this._executableFile == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, this._updateMessage.getMessageInstallerReady(), I18n.tr("Update"), 0, 1);
        if (n == 0) {
            try {
                if (OSUtils.isWindows()) {
                    String[] stringArray = new String[]{"CMD.EXE", "/C", this._executableFile.getAbsolutePath()};
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                    processBuilder.start();
                } else if (OSUtils.isLinux() && OSUtils.isUbuntu()) {
                    String[] stringArray = new String[]{"gdebi-gtk", this._executableFile.getAbsolutePath()};
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                    processBuilder.start();
                }
                GUIMediator.shutdown();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private File downloadDotTorrent() {
        File file = SharingUtils.APPLICATION_SPECIAL_SHARE;
        int n = this._updateMessage.getTorrent().lastIndexOf(47);
        File file2 = new File(file, this._updateMessage.getTorrent().substring(n + 1));
        if (!file.exists()) {
            file.mkdir();
            file.setWritable(true);
        }
        try {
            CoreFrostWireUtils.downloadTorrentFile(this._updateMessage.getTorrent(), file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        assert (file2.exists());
        return file2;
    }

    private final InstallerMetaData getLastInstallerMetaData() {
        InstallerMetaData installerMetaData = null;
        try {
            File file = new File(this.getInstallerDatPath());
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            installerMetaData = (InstallerMetaData)objectInputStream.readObject();
            if (installerMetaData == null) {
                return null;
            }
            System.out.println(installerMetaData);
            fileInputStream.close();
            return installerMetaData;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private boolean checkIfDownloaded() {
        InstallerMetaData installerMetaData = this.getLastInstallerMetaData();
        if (installerMetaData == null) {
            return false;
        }
        if (!installerMetaData.frostwireVersion.equals(this._updateMessage.getVersion())) {
            return false;
        }
        int n = this._updateMessage.getTorrent().lastIndexOf(47) + 1;
        int n2 = this._updateMessage.getTorrent().lastIndexOf(".torrent");
        String string = this._updateMessage.getTorrent().substring(n, n2);
        File file = new File(SharingUtils.APPLICATION_SPECIAL_SHARE, string);
        if (!file.exists()) {
            return false;
        }
        this._executableFile = file;
        try {
            return CoreFrostWireUtils.checkMD5(file, this._updateMessage.getRemoteMD5());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void completionChanged(DownloadManager downloadManager, boolean bl) {
    }

    public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
    }

    public void positionChanged(DownloadManager downloadManager, int n, int n2) {
    }

    public void stateChanged(DownloadManager downloadManager, int n) {
        if (this._manager == null && downloadManager != null) {
            this._manager = downloadManager;
        }
        CoreFrostWireUtils.printDiskManagerPieces(downloadManager.getDiskManager());
        CoreFrostWireUtils.printDownloadManagerStatus(downloadManager);
        if (this.torrentDataDownloadedToDisk()) {
            return;
        }
        System.out.println("InstallerUpdater.stateChanged() - " + n + " completed: " + downloadManager.isDownloadComplete(false));
        if (n == 60) {
            System.out.println("InstallerUpdater.stateChanged() - SEEDING!");
            return;
        }
        if (n == 100) {
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.out.println(this._manager.getErrorDetails());
            System.out.println("InstallerUpdater: ERROR - stopIt, startDownload!");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            try {
                AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager, false, true);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                globalManagerDownloadRemovalVetoException.printStackTrace();
            }
        } else if (n == 50) {
            System.out.println("stateChanged(STATE_DOWNLOADING)");
        } else if (n == 40) {
            System.out.println("stateChanged(STATE_READY)");
            downloadManager.startDownload();
        }
    }

    public void downloadComplete(DownloadManager downloadManager) {
        System.out.println("InstallerUpdater.downloadComplete()!!!!");
        CoreFrostWireUtils.printDownloadManagerStatus(this._manager);
        this.saveMetaData();
        this.cleanupOldUpdates();
    }

    private void cleanupOldUpdates() {
        final Pattern pattern = Pattern.compile("^frostwire-([0-9]+[0-9]?\\.[0-9]+[0-9]?\\.[0-9]+[0-9]?)\\.windows\\.exe(\\.torrent)?$");
        for (File file : SharingUtils.APPLICATION_SPECIAL_SHARE.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    return !matcher.group(1).equals(InstallerUpdater.this._updateMessage.getVersion());
                }
                return false;
            }
        })) {
            file.delete();
        }
    }

    private final String getInstallerDatPath() {
        return CoreFrostWireUtils.getPreferencesFolder().getAbsolutePath() + File.separator + "installer.dat";
    }

    private void saveMetaData() {
        try {
            String string = this.getInstallerDatPath();
            InstallerMetaData installerMetaData = new InstallerMetaData();
            installerMetaData.frostwireVersion = this._updateMessage.getVersion();
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(installerMetaData);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean torrentDataDownloadedToDisk() {
        if (this._manager == null || this._manager.getDiskManager() == null) {
            return false;
        }
        String string = SharingUtils.APPLICATION_SPECIAL_SHARE.getAbsolutePath();
        File file = new File(string);
        System.out.println(file.length());
        DiskManager diskManager = this._manager.getDiskManager();
        int n = diskManager.getPercentDone();
        long l = diskManager.getTotalLength();
        int n2 = diskManager.getCompleteRecheckStatus();
        return file.exists() && file.length() == l && n == 1000 && n2 == -1;
    }
}

