/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.sponsors;

import com.frostwire.ImageCache;
import com.frostwire.gnutella.gui.sponsors.BannerContainer;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JLabel;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SponsorBanner
extends JLabel {
    private static final long serialVersionUID = -2074000214262216103L;
    private SponsorLoader _sponsorLoader = new SponsorLoader();
    private static NetworkManager networkManager = null;
    public static String ipAddress = "0.0.0.0";
    private String url;
    private String imageSrc;
    private int width;
    private int height;
    private int duration;
    private Set<String> ipRanges = null;
    private String type = null;
    private HashMap<String, String> countries = null;
    private String language = null;
    private String locale = null;
    private String version = null;

    public static void fetchIpAddress() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string;
                LimeWireCore limeWireCore = GuiCoreMediator.getCore();
                SponsorBanner.networkManager = limeWireCore.getNetworkManager();
                byte[] byArray = networkManager.getExternalAddress();
                int n = 20;
                while (!GUIMediator.isConstructed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    byArray = networkManager.getExternalAddress();
                    if (--n != 0) continue;
                }
                ipAddress = string = SponsorBanner.ipBytesToString(byArray);
            }
        });
        thread.start();
    }

    public static String ipBytesToString(byte[] byArray) {
        if (byArray == null) {
            return new String("0.0.0.0");
        }
        int n = 0;
        String string = new String();
        while (n < byArray.length) {
            string = byArray[n] < 0 ? string + Integer.toString(256 + Integer.parseInt(Byte.toString(byArray[n]))) : string + Byte.toString(byArray[n]);
            if (++n >= byArray.length) continue;
            string = string + ".";
        }
        return string;
    }

    public Set<SponsorBanner> getBannersFromServer(BannerContainer bannerContainer) {
        SponsorLoader sponsorLoader = this.getSponsorLoader();
        if (bannerContainer != null) {
            sponsorLoader.set_bannerContainer(bannerContainer);
        }
        return sponsorLoader.loadBanners();
    }

    public SponsorLoader getSponsorLoader() {
        return this._sponsorLoader;
    }

    public SponsorBanner() {
    }

    public SponsorBanner(String string, String string2, int n, int n2, int n3, Set<String> set, String string3, HashMap<String, String> hashMap, String string4, String string5) {
        this.setUrl(string);
        this.setImageSrc(string2);
        this.setWidth(n);
        this.setHeight(n2);
        this.setDuration(n3);
        this.setIpRanges(set);
        this.setVersion(string5);
        this.setType(string3);
        if (hashMap != null) {
            this.setCountries(hashMap);
        }
        if (string4 != null) {
            this.setLanguage(string4);
        }
        URL uRL = null;
        try {
            uRL = new URL(this.getImageSrc());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ImageCache.getInstance().getImage(uRL, new ImageCache.OnLoadedListener(){

            public void onLoaded(URL uRL, BufferedImage bufferedImage, boolean bl) {
                SponsorBanner.this.setBannerLabelHtml(ImageCache.getInstance().getCachedFileURL(uRL));
            }
        });
    }

    public void setBannerLabelHtml(URL uRL) {
        String string = null;
        try {
            string = uRL.toURI().toURL().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setText("<html><img src=\"" + string + "\" width=\"" + this.getWidth() + "\" height=\"" + this.getHeight() + "\" border=\"0\"/></html>");
        this.setSize(new Dimension(this.getWidth(), this.getHeight()));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SponsorBanner.this.getType() == null || SponsorBanner.this.getType().equals("web")) {
                    GUIMediator.openURL(SponsorBanner.this.getUrl());
                    return;
                }
                if (SponsorBanner.this.getType().equals("torrent")) {
                    String string = SponsorBanner.this.getUrl();
                    try {
                        URI uRI = new URI(string);
                        String string2 = uRI.getScheme();
                        if (string2 == null || !string2.equalsIgnoreCase("http")) {
                            return;
                        }
                        String string3 = uRI.getAuthority();
                        if (string3 == null || string3.equals("") || string3.indexOf(32) != -1) {
                            return;
                        }
                        GUIMediator.instance().openTorrentURI(uRI);
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                    return;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                SponsorBanner.this.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SponsorBanner.this.setCursor(new Cursor(0));
            }
        });
    }

    public String getUrl() {
        return this.url;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    @Override
    public int getWidth() {
        if (this.width <= 0) {
            return 120;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height <= 0) {
            return 600;
        }
        return this.height;
    }

    public int getDuration() {
        if (this.duration <= 0) {
            return 300;
        }
        return this.duration;
    }

    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getBannerLocale() {
        return this.locale;
    }

    public void addCountry(String string) {
        if (string == null) {
            return;
        }
        if (this.countries == null) {
            this.countries = new HashMap();
        }
        this.countries.put(string, string);
    }

    public boolean hasCountry(String string) {
        if (this.countries == null || string == null) {
            return false;
        }
        return this.countries.containsKey(string);
    }

    public void setCountries(HashMap<String, String> hashMap) {
        this.countries = hashMap;
    }

    public HashMap<String, String> getCountries() {
        return this.countries;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSystemCountry() {
        String string = System.getProperty("user.country");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getSystemLanguage() {
        if (this.language == null) {
            this.language = "";
        }
        return this.language;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setImageSrc(String string) {
        this.imageSrc = string;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public void setIpRanges(Set<String> set) {
        if (set != null && set.size() == 0) {
            set = null;
        }
        this.ipRanges = set;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setType(String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        this.type = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setBannerLocale(String string) {
        this.locale = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SponsorLoader
    implements ContentHandler {
        private boolean _status = false;
        private Set<SponsorBanner> _result = new LinkedHashSet<SponsorBanner>();
        private BannerContainer _bannerContainer = null;

        private SponsorLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<SponsorBanner> loadBanners() {
            HttpURLConnection httpURLConnection = null;
            InputSource inputSource = null;
            try {
                httpURLConnection = (HttpURLConnection)new URL("http://sponsors.frostwire.com/").openConnection();
                String string = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getFrostWireVersion();
                httpURLConnection.setRequestProperty("User-Agent", string);
                inputSource = new InputSource(httpURLConnection.getInputStream());
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                xMLReader.setContentHandler(this);
                xMLReader.parse(inputSource);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                System.out.println("SponsorLoader.loadBanners() SAX exception " + sAXException.toString());
                sAXException.printStackTrace();
            }
            finally {
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    httpURLConnection.disconnect();
                }
            }
            return this._result;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String string, String string2, String string3) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ((string2 = string2.toLowerCase()).equals("sponsors")) {
                String string4 = attributes.getValue("status").toLowerCase();
                this._status = false;
                if (string4 != null && (string4.equals("on") || string4.equals("true") || string4.equals("1"))) {
                    this._status = true;
                }
            } else if (string2.equals("banners") && this._status) {
                String string5 = attributes.getValue("refreshrate");
                if (string5 != null) {
                    if (string5.equals("0") || string5.equals("-1") || string5.equalsIgnoreCase("no") || string5.equalsIgnoreCase("none") || string5.equalsIgnoreCase("false") || string5.equalsIgnoreCase("off")) {
                        this.get_bannerContainer().setupBannerRefreshTask(-1);
                    } else {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string5);
                            n = Math.abs(n);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n > 0) {
                            this.get_bannerContainer().setupBannerRefreshTask(n);
                        }
                    }
                }
            } else if (string2.equals("banner") && this._status) {
                Object object;
                Object object2;
                String string6;
                String string7 = new String(attributes.getValue("src"));
                String string8 = new String(attributes.getValue("href"));
                int n = Integer.parseInt(attributes.getValue("width"));
                int n2 = Integer.parseInt(attributes.getValue("height"));
                int n3 = Integer.parseInt(attributes.getValue("duration"));
                HashSet<String> hashSet = new HashSet<String>();
                if (attributes.getValue("ipranges") != null) {
                    string6 = attributes.getValue("ipranges");
                    string6 = string6.replaceAll("\\s", "");
                    for (String string9 : object2 = string6.split(",")) {
                        hashSet.add(string9);
                    }
                } else {
                    hashSet = null;
                }
                string6 = null;
                if (attributes.getValue("type") != null) {
                    string6 = new String(attributes.getValue("type"));
                }
                object2 = null;
                if (attributes.getValue("countries") != null) {
                    String[] stringArray;
                    object2 = new HashMap();
                    object = new String(attributes.getValue("countries"));
                    object = ((String)object).trim();
                    for (String string10 : stringArray = ((String)object).split(",")) {
                        ((HashMap)object2).put(string10.toUpperCase(), string10.toUpperCase());
                    }
                }
                object = null;
                if (attributes.getValue("language") != null) {
                    object = new String(attributes.getValue("language"));
                }
                String string11 = null;
                if (attributes.getValue("version") != null) {
                    string11 = new String(attributes.getValue("version"));
                }
                SponsorBanner sponsorBanner = new SponsorBanner(string8, string7, n, n2, n3, hashSet, string6, (HashMap<String, String>)object2, (String)object, string11);
                if (string11 != null && !this.frostWireMatchesVersion(string11)) {
                    return;
                }
                if (object2 != null && !sponsorBanner.hasCountry(sponsorBanner.getSystemCountry())) {
                    return;
                }
                if (object != null && !((String)object).equals("") && !sponsorBanner.getSystemLanguage().equals(sponsorBanner.getLanguage())) {
                    return;
                }
                this._result.add(sponsorBanner);
            }
        }

        public boolean frostWireMatchesVersion(String string) {
            String string2 = "4.17.5";
            if (string == null || string.equals("")) {
                return false;
            }
            String[] stringArray = string2.split("\\.");
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            String[] stringArray2 = string.split("\\.");
            String string6 = stringArray2[0];
            String string7 = stringArray2[1];
            String string8 = stringArray2[2];
            if (!string6.equals("*") && !string3.equals(string6)) {
                return false;
            }
            if (!string7.equals("*") && !string4.equals(string7)) {
                return false;
            }
            return string8.equals("*") || string5.equals(string8);
        }

        @Override
        public void skippedEntity(String string) {
        }

        @Override
        public void processingInstruction(String string, String string2) {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
        }

        @Override
        public void endPrefixMapping(String string) {
        }

        public BannerContainer get_bannerContainer() {
            return this._bannerContainer;
        }

        public void set_bannerContainer(BannerContainer bannerContainer) {
            this._bannerContainer = bannerContainer;
        }
    }
}

