/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.chat;

import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatItem
implements Comparable<ChatItem> {
    public static final String ALBUM = "Album";
    public static final String ARTIST = "Artist";
    public static final String BITRATE = "BitRate";
    public static final String COMMENT = "Comment";
    public static final String GENRE = "Genre";
    public static final String LENGTH = "Length";
    public static final String TIME = "Time";
    public static final String SIZE = "Size";
    public static final String TITLE = "Title";
    public static final String TRACK = "Track";
    public static final String TYPE = "Type";
    public static final String YEAR = "Year";
    public static final String VBR = "VBR";
    private final URI uri = null;
    private final String name = "";
    private final boolean isLocal = true;
    private final boolean isStorePreview = false;
    private final Map<String, String> properties = null;
    private String[] toolTips = null;

    public void ChatItem(File file) {
        System.out.println("Chat item was called without params");
    }

    public String getName() {
        return "";
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.properties.get(string);
        return string3 != null ? string3 : string2;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isStorePreview() {
        return false;
    }

    public String[] getToolTips() {
        if (this.toolTips == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this.getName());
            if (this.properties.get(TITLE) != null) {
                linkedList.add(I18n.tr(TITLE) + ": " + this.properties.get(TITLE));
            }
            if (this.properties.get(ARTIST) != null) {
                linkedList.add(I18n.tr(ARTIST) + ": " + this.properties.get(ARTIST));
            }
            if (this.properties.get(ALBUM) != null) {
                linkedList.add(I18n.tr(ALBUM) + ": " + this.properties.get(ALBUM));
            }
            if (this.properties.get(GENRE) != null) {
                linkedList.add(I18n.tr(GENRE) + ": " + this.properties.get(GENRE));
            }
            if (this.properties.get(TRACK) != null) {
                linkedList.add(I18n.tr(TRACK) + ": " + this.properties.get(TRACK));
            }
            if (this.properties.get(YEAR) != null) {
                linkedList.add(I18n.tr(YEAR) + ": " + this.properties.get(YEAR));
            }
            if (this.properties.get(TIME) != null) {
                linkedList.add(I18n.tr(LENGTH) + ": " + this.properties.get(TIME));
            }
            if (this.properties.get(BITRATE) != null) {
                linkedList.add(I18n.tr("Bitrate") + ": " + this.properties.get(BITRATE) + " kbps" + (this.properties.get(VBR).equals("true") ? " (VBR)" : ""));
            }
            this.toolTips = linkedList.toArray(new String[linkedList.size()]);
        }
        return this.toolTips;
    }

    @Override
    public int compareTo(ChatItem chatItem) {
        return 0;
    }
}

