/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.GraphicPanel;
import com.frostwire.gnutella.gui.HintTextField;
import com.frostwire.gnutella.gui.SlideshowPanel;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.BrowseFileTypeButton;
import com.frostwire.gnutella.gui.android.BrowseTask;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceListTransferHandler;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.FileDescriptorListModel;
import com.frostwire.gnutella.gui.android.FileDescriptorRenderer;
import com.frostwire.gnutella.gui.android.Finger;
import com.frostwire.gnutella.gui.android.RedispatchMouseListener;
import com.frostwire.gnutella.gui.android.Task;
import com.frostwire.gnutella.gui.android.UITool;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceExplorer
extends JPanel {
    private static final long serialVersionUID = -6716798921645948528L;
    private static final String SLIDESHOW_JSON_URL = "http://update.frostwire.com/no.devices.slides.php";
    private static final String DEVICE = "device";
    private static final String NO_DEVICE = "no-device";
    private FileDescriptorListModel _model = new FileDescriptorListModel();
    private Device _device;
    private int _selectedFileType;
    private JPanel _panelDevice;
    private JPanel _panelNoDevice;
    private JList _list;
    private JScrollPane _scrollPane;
    private BrowseFileTypeButton _buttonApplications;
    private BrowseFileTypeButton _buttonDocuments;
    private BrowseFileTypeButton _buttonPictures;
    private BrowseFileTypeButton _buttonVideos;
    private BrowseFileTypeButton _buttonRingtones;
    private BrowseFileTypeButton _buttonAudio;
    private JRadioButton _invisibleRadioButton;
    private ButtonGroup _buttonGroup;
    private HintTextField _textFilter;
    private JLabel _labelLoading;
    private Thread _searchThread;

    public DeviceExplorer() {
        this.setupUI();
        this.setPanelDevice(false);
    }

    public Device getDevice() {
        return this._device;
    }

    public void setDevice(Device device) {
        this._device = device;
        this._model.clear();
        this._invisibleRadioButton.setSelected(true);
        this.setPanelDevice(device != null);
    }

    public void setPanelDevice(boolean bl) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show(this, bl ? DEVICE : NO_DEVICE);
        if (bl) {
            this.refreshHeader();
        }
    }

    public void refreshHeader() {
        if (this._device == null) {
            return;
        }
        Finger finger = this._device.getFinger();
        this.refreshBrowseButton(this._buttonApplications, finger.numSharedApplicationFiles);
        this.refreshBrowseButton(this._buttonDocuments, finger.numSharedDocumentFiles);
        this.refreshBrowseButton(this._buttonPictures, finger.numSharedPictureFiles);
        this.refreshBrowseButton(this._buttonVideos, finger.numSharedVideoFiles);
        this.refreshBrowseButton(this._buttonRingtones, finger.numSharedRingtoneFiles);
        this.refreshBrowseButton(this._buttonAudio, finger.numSharedAudioFiles);
    }

    public FileDescriptorListModel getModel() {
        return this._model;
    }

    public List<FileDescriptor> getSelectedFileDescriptors() {
        Object[] objectArray = this._list.getSelectedValues();
        if (objectArray == null) {
            return new ArrayList<FileDescriptor>();
        }
        ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add((FileDescriptor)objectArray[i]);
        }
        return arrayList;
    }

    public int getSelectedFileType() {
        return this._selectedFileType;
    }

    protected void setupUI() {
        this.setLayout(new CardLayout());
        this._panelDevice = this.setupPanelDevice();
        this._panelNoDevice = new SlideshowPanel(SLIDESHOW_JSON_URL);
        this._panelNoDevice.setBackground(Color.BLACK);
        this.add((Component)this._panelDevice, DEVICE);
        this.add((Component)this._panelNoDevice, NO_DEVICE);
    }

    protected void textFilter_keyTyped(KeyEvent keyEvent) {
        if (this._searchThread != null && !this._searchThread.isInterrupted()) {
            this._searchThread.interrupt();
        }
        String string = this._textFilter.getText();
        char c = keyEvent.getKeyChar();
        if (Character.isLetterOrDigit(c)) {
            string = string + c;
        }
        final String string2 = string;
        this._searchThread = new Thread(new Runnable(){

            public void run() {
                DeviceExplorer.this._model.filter(string2);
            }
        });
        this._searchThread.setDaemon(true);
        this._searchThread.start();
    }

    private JPanel setupPanelDevice() {
        JPanel jPanel = new JPanel(new BorderLayout());
        GraphicPanel graphicPanel = new GraphicPanel();
        graphicPanel.setImage(new UITool().loadImage("device_explorer_background.jpg"));
        graphicPanel.setLayout(new GridBagLayout());
        this._buttonApplications = this.setupButtonType(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        graphicPanel.add((Component)this._buttonApplications, gridBagConstraints);
        this._buttonDocuments = this.setupButtonType(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        graphicPanel.add((Component)this._buttonDocuments, gridBagConstraints);
        this._buttonPictures = this.setupButtonType(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        graphicPanel.add((Component)this._buttonPictures, gridBagConstraints);
        this._buttonVideos = this.setupButtonType(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        graphicPanel.add((Component)this._buttonVideos, gridBagConstraints);
        this._buttonRingtones = this.setupButtonType(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        graphicPanel.add((Component)this._buttonRingtones, gridBagConstraints);
        this._buttonAudio = this.setupButtonType(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        graphicPanel.add((Component)this._buttonAudio, gridBagConstraints);
        this._buttonGroup = new ButtonGroup();
        this._buttonGroup.add(this._buttonApplications);
        this._buttonGroup.add(this._buttonDocuments);
        this._buttonGroup.add(this._buttonPictures);
        this._buttonGroup.add(this._buttonVideos);
        this._buttonGroup.add(this._buttonRingtones);
        this._buttonGroup.add(this._buttonAudio);
        this._invisibleRadioButton = new JRadioButton();
        this._buttonGroup.add(this._invisibleRadioButton);
        this._textFilter = new HintTextField("Type here to search");
        this._textFilter.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                DeviceExplorer.this.textFilter_keyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 6;
        graphicPanel.add((Component)this._textFilter, gridBagConstraints);
        jPanel.add((Component)graphicPanel, "First");
        this._list = new JList(this._model);
        this._list.setCellRenderer(new FileDescriptorRenderer());
        this._list.addMouseListener(new RedispatchMouseListener(this._list));
        this._list.setLayoutOrientation(0);
        this._list.setDragEnabled(true);
        this._list.setTransferHandler(new DeviceListTransferHandler());
        this._list.setPrototypeCellValue(new FileDescriptor(0, 0, "", "", "", "", "", 0L));
        this._list.setVisibleRowCount(-1);
        this._scrollPane = new JScrollPane(this._list);
        jPanel.add((Component)this._scrollPane, "Center");
        this._labelLoading = new JLabel();
        this._labelLoading.setSize(32, 32);
        this._labelLoading.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/loading.gif"))));
        this._labelLoading.setVisible(false);
        this._list.add((Component)this._labelLoading, "Center");
        return jPanel;
    }

    private BrowseFileTypeButton setupButtonType(final int n) {
        UITool uITool = new UITool();
        BrowseFileTypeButton browseFileTypeButton = new BrowseFileTypeButton();
        browseFileTypeButton.setIcon(new ImageIcon(uITool.loadImage(uITool.getImageNameByFileType(n))));
        browseFileTypeButton.setPressedIcon(new ImageIcon(uITool.loadImage(uITool.getImageNameByFileType(n) + "_checked")));
        browseFileTypeButton.setSelectedIcon(new ImageIcon(uITool.loadImage(uITool.getImageNameByFileType(n) + "_checked")));
        browseFileTypeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DeviceExplorer.this.buttonType_mouseClicked(mouseEvent, n);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                String string = "Application";
                switch (n) {
                    case 0: {
                        string = "Audio";
                        break;
                    }
                    case 3: {
                        string = "Document";
                        break;
                    }
                    case 1: {
                        string = "Picture";
                        break;
                    }
                    case 5: {
                        string = "Ringtone";
                        break;
                    }
                    case 2: {
                        string = "Video";
                    }
                }
                DeviceExplorer.this._textFilter.setHint("Type here to filter " + string + " files");
                DeviceExplorer.this._textFilter.focusLost(null);
                DeviceExplorer.this._textFilter.clear();
            }
        });
        Font font = browseFileTypeButton.getFont();
        browseFileTypeButton.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize() + 4));
        return browseFileTypeButton;
    }

    private void buttonType_mouseClicked(MouseEvent mouseEvent, int n) {
        this._selectedFileType = n;
        this._textFilter.clear();
        this._model.clear();
        int n2 = (this._scrollPane.getWidth() - this._labelLoading.getWidth()) / 2;
        int n3 = (this._scrollPane.getHeight() - this._labelLoading.getHeight()) / 2 - 10;
        this._labelLoading.setLocation(n2, n3);
        this._labelLoading.setVisible(true);
        BrowseTask browseTask = new BrowseTask(this._device, this._model, n);
        browseTask.addOnChangedListener(new Task.OnChangedListener(){

            public void onChanged(Task task) {
                if (!task.isRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeviceExplorer.this._labelLoading.setVisible(false);
                        }
                    });
                }
            }
        });
        AndroidMediator.addTask(browseTask);
    }

    private void refreshBrowseButton(BrowseFileTypeButton browseFileTypeButton, int n) {
        browseFileTypeButton.setText(String.valueOf(n));
        if (n == 0 && browseFileTypeButton.isSelected() && this._model.getSize() > 0) {
            this._model.clear();
        }
    }
}

