/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceButton;
import com.frostwire.gnutella.gui.android.UITool;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeviceBar
extends JPanel {
    private static final long serialVersionUID = -6886611714952957959L;
    private Map<Device, DeviceButton> _buttons = new HashMap<Device, DeviceButton>();
    private ButtonGroup _buttonGroup = new ButtonGroup();
    private MyOnActionFailedListener _deviceListener = new MyOnActionFailedListener();
    private MyMouseAdapter _mouseAdapter = new MyMouseAdapter();
    private Device _selectedDevice;
    private BufferedImage _imageLeftBorder;
    private BufferedImage _imageRightBorder;
    private BufferedImage _imageBackground;
    private BufferedImage _imageNoDevice;

    public DeviceBar() {
        this.buildImages();
        this.setupUI();
    }

    public void handleNewDevice(Device device) {
        this.handleDeviceStale(device);
        DeviceButton deviceButton = new DeviceButton(device);
        deviceButton.addMouseListener(this._mouseAdapter);
        this._buttons.put(device, deviceButton);
        this._buttonGroup.add(deviceButton);
        this.add(deviceButton);
        this.repaint();
        device.setOnActionFailedListener(this._deviceListener);
    }

    public void handleDeviceAlive(Device device) {
        DeviceButton deviceButton = this._buttons.get(device);
        if (deviceButton == null) {
            return;
        }
        deviceButton.refresh();
        this.revalidate();
        if (deviceButton.getDevice().equals(this._selectedDevice) && this._selectedDevice != null) {
            AndroidMediator.instance().getDeviceExplorer().refreshHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDeviceStale(Device device) {
        Map<Device, DeviceButton> map = this._buttons;
        synchronized (map) {
            DeviceButton deviceButton = this._buttons.remove(device);
            if (deviceButton == null) {
                return;
            }
            deviceButton.setVisible(false);
            this._buttonGroup.remove(deviceButton);
            this.remove(deviceButton);
            this.revalidate();
            if (this._buttons.size() == 0 || device.equals(this._selectedDevice)) {
                this.repaint();
                AndroidMediator.instance().getDeviceExplorer().setPanelDevice(false);
            }
        }
    }

    public Device getSelectedDevice() {
        return this._selectedDevice;
    }

    protected void setupUI() {
        this.setLayout(new FlowLayout());
        this.setPreferredSize(new Dimension(300, 140));
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        int n2 = this.getWidth() / this._imageBackground.getWidth() + 1;
        for (n = 0; n < n2; ++n) {
            graphics.drawImage(this._imageBackground, n * this._imageBackground.getWidth(), 0, null);
        }
        graphics.drawImage(this._imageLeftBorder, 0, 0, null);
        graphics.drawImage(this._imageRightBorder, this.getWidth() - this._imageRightBorder.getWidth(), 0, null);
        if (this._buttons.size() == 0) {
            n = (this.getWidth() - this._imageNoDevice.getWidth()) / 2;
            int n3 = (this.getHeight() - this._imageNoDevice.getHeight()) / 2 - 5;
            if (n >= 0 && n3 >= 0) {
                graphics.drawImage(this._imageNoDevice, n, n3, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildImages() {
        BufferedImage bufferedImage = new UITool().loadImage("device_bar_background");
        this._imageLeftBorder = bufferedImage.getSubimage(0, 0, 15, bufferedImage.getHeight());
        this._imageRightBorder = new BufferedImage(this._imageLeftBorder.getWidth(), this._imageLeftBorder.getHeight(), 1);
        Graphics2D graphics2D = null;
        try {
            graphics2D = this._imageRightBorder.createGraphics();
            graphics2D.drawImage((Image)this._imageLeftBorder, 0, 0, null);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
            affineTransform.translate(-this._imageLeftBorder.getWidth(), 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            this._imageRightBorder = affineTransformOp.filter(this._imageRightBorder, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        this._imageBackground = bufferedImage.getSubimage(15, 0, bufferedImage.getWidth() - 15, bufferedImage.getHeight());
        this._imageNoDevice = this.buildTextImage(I18n.tr("No devices nearby"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage buildTextImage(String string) {
        Font font = this.getFont();
        font = new Font(font.getFamily(), 1, font.getSize() + 20);
        Graphics graphics = null;
        Graphics graphics2 = null;
        Graphics graphics3 = null;
        BufferedImage bufferedImage = null;
        try {
            BufferedImage bufferedImage2 = new BufferedImage(300, 120, 2);
            graphics = bufferedImage2.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string) + 20;
            int n2 = fontMetrics.getHeight();
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            graphics2 = bufferedImage3.createGraphics();
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            TextLayout textLayout = new TextLayout(string, font, ((Graphics2D)graphics2).getFontRenderContext());
            ((Graphics2D)graphics2).setPaint(Color.BLACK);
            textLayout.draw((Graphics2D)graphics2, 11.0f, 34.0f);
            graphics2.dispose();
            float f = 0.11111111f;
            float[] fArray = new float[]{f, f, f, f, f, f, f, f, f};
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray), 1, null);
            BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage3, null);
            graphics3 = bufferedImage4.createGraphics();
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ((Graphics2D)graphics3).setPaint(Color.WHITE);
            textLayout.draw((Graphics2D)graphics3, 10.0f, 33.0f);
            bufferedImage = bufferedImage4;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (graphics != null) {
                graphics2.dispose();
            }
            if (graphics != null) {
                graphics3.dispose();
            }
        }
        return bufferedImage;
    }

    private final class MyOnActionFailedListener
    implements Device.OnActionFailedListener {
        private MyOnActionFailedListener() {
        }

        public void onActionFailed(Device device, int n, Exception exception) {
            JComponent jComponent = AndroidMediator.instance().getComponent();
            if (n == Device.ACTION_UPLOAD) {
                JOptionPane.showMessageDialog(jComponent, I18n.tr("You are not authorized to upload files to this device"), I18n.tr("From ") + device.getName(), 1);
            } else {
                DeviceBar.this.handleDeviceStale(device);
                JOptionPane.showMessageDialog(jComponent, I18n.tr("Error connecting to device: ") + (exception != null ? exception.getMessage() : I18n.tr("undefined")), I18n.tr("From ") + device.getName(), 0);
            }
        }
    }

    private final class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DeviceButton deviceButton = (DeviceButton)mouseEvent.getComponent();
            DeviceBar.this._selectedDevice = deviceButton.getDevice();
            AndroidMediator.instance().getDeviceExplorer().setDevice(DeviceBar.this._selectedDevice);
        }
    }
}

