/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.DesktopExplorer;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceBar;
import com.frostwire.gnutella.gui.android.DeviceExplorer;
import com.frostwire.gnutella.gui.android.PeerDiscoveryClerk;
import com.frostwire.gnutella.gui.android.ProgressPanel;
import com.frostwire.gnutella.gui.android.Task;
import com.frostwire.gnutella.gui.android.TaskProcessor;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class AndroidMediator
implements ThemeObserver {
    private static AndroidMediator INSTANCE;
    private JPanel MAIN_PANEL;
    private DeviceBar DEVICE_BAR;
    private DesktopExplorer DESKTOP_EXPLORER;
    private DeviceExplorer DEVICE_EXPLORER;
    private ProgressPanel PROGRESS_PANEL;
    private TaskProcessor TASK_PROCESSOR;
    private JPanel EXPLORERS_CONTAINER;
    private JSplitPane SPLIT_PANE;

    public static AndroidMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new AndroidMediator();
        }
        return INSTANCE;
    }

    private AndroidMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading phones and tablets..."));
        ThemeMediator.addThemeObserver(this);
        this.TASK_PROCESSOR = new TaskProcessor();
        this.TASK_PROCESSOR.start();
        this.setupUI();
    }

    protected void setupUI() {
        this.DEVICE_BAR = new DeviceBar();
        this.DESKTOP_EXPLORER = new DesktopExplorer();
        this.DEVICE_EXPLORER = new DeviceExplorer();
        this.PROGRESS_PANEL = new ProgressPanel();
        this.MAIN_PANEL = new JPanel(new BorderLayout());
        this.MAIN_PANEL.add((Component)this.DEVICE_BAR, "First");
        this.EXPLORERS_CONTAINER = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.EXPLORERS_CONTAINER.add((Component)this.DESKTOP_EXPLORER, gridBagConstraints);
        this.SPLIT_PANE = new JSplitPane(0);
        this.SPLIT_PANE.setAutoscrolls(true);
        this.SPLIT_PANE.setDividerSize(4);
        this.SPLIT_PANE.add(this.DEVICE_EXPLORER);
        this.SPLIT_PANE.add(this.PROGRESS_PANEL);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.EXPLORERS_CONTAINER.add((Component)this.SPLIT_PANE, gridBagConstraints);
        this.MAIN_PANEL.add((Component)this.EXPLORERS_CONTAINER, "Center");
        this.SPLIT_PANE.setDividerLocation(300);
    }

    public void updateTheme() {
    }

    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public static void handleNewDevice(Device device) {
        AndroidMediator.INSTANCE.DEVICE_BAR.handleNewDevice(device);
    }

    public static void handleDeviceAlive(Device device) {
        AndroidMediator.INSTANCE.DEVICE_BAR.handleDeviceAlive(device);
    }

    public static void handleDeviceStale(Device device) {
        AndroidMediator.INSTANCE.DEVICE_BAR.handleDeviceStale(device);
    }

    public static void addTask(Task task) {
        AndroidMediator.INSTANCE.PROGRESS_PANEL.addTask(task);
        AndroidMediator.INSTANCE.TASK_PROCESSOR.addTask(task);
    }

    public DeviceBar getDeviceBar() {
        return this.DEVICE_BAR;
    }

    public DesktopExplorer getDesktopExplorer() {
        return this.DESKTOP_EXPLORER;
    }

    public DeviceExplorer getDeviceExplorer() {
        return this.DEVICE_EXPLORER;
    }

    public ProgressPanel getProgressPanel() {
        return this.PROGRESS_PANEL;
    }

    public static void startAndroidClerk() {
        PeerDiscoveryClerk peerDiscoveryClerk = new PeerDiscoveryClerk();
        peerDiscoveryClerk.start();
    }

    public static void main(String[] stringArray) {
        AndroidMediator.startAndroidClerk();
        AndroidMediator androidMediator = AndroidMediator.instance();
        JFrame jFrame = new JFrame();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setSize((int)((double)dimension.width * 0.6), 600);
        jFrame.getContentPane().add(androidMediator.getComponent());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

