/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class HintTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = -3191287673317585610L;
    private String _hint;
    private Color _color;
    private Color _hintColor;

    public HintTextField(String string) {
        super(string);
        this._hint = string;
        this._color = Color.BLACK;
        this._hintColor = Color.LIGHT_GRAY;
        this.setForeground(this._hintColor);
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getText().length() == 0) {
            this.setForeground(this._color);
            super.setText("");
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.getText().length() == 0) {
            this.clear();
        }
    }

    public String getText() {
        String string = super.getText();
        return string.equals(this._hint) ? "" : string;
    }

    public void clear() {
        if (this.isFocusOwner()) {
            this.setForeground(this._color);
            super.setText("");
        } else {
            this.setForeground(this._hintColor);
            super.setText(this._hint);
        }
    }

    public void setHint(String string) {
        this._hint = string;
        this.repaint();
    }
}

