/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.SystemProperties;

public final class AzureusStarter {
    private static final Log LOG = LogFactory.getLog(AzureusStarter.class);
    private static AzureusCore AZUREUS_CORE;

    public static final void start() {
        AzureusStarter.azureusInit();
    }

    public static AzureusCore getAzureusCore() {
        if (AZUREUS_CORE != null && AZUREUS_CORE.isStarted()) {
            return AZUREUS_CORE;
        }
        AzureusStarter.azureusInit();
        return AZUREUS_CORE;
    }

    private static synchronized void azureusInit() {
        try {
            if (AZUREUS_CORE != null && AZUREUS_CORE.isStarted()) {
                LOG.debug("azureusInit(): core already started. skipping.");
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!AzureusCoreFactory.isCoreAvailable()) {
            block9: {
                SystemProperties.APPLICATION_NAME = "azureus";
                SystemProperties.setUserPath(LimeWireUtils.getRequestedUserSettingsLocation() + File.separator + "azureus" + File.separator);
                try {
                    AZUREUS_CORE = AzureusCoreFactory.create();
                }
                catch (AzureusCoreException azureusCoreException) {
                    if (AZUREUS_CORE != null) break block9;
                    AZUREUS_CORE = AzureusCoreFactory.getSingleton();
                }
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            AZUREUS_CORE.addLifecycleListener(new AzureusCoreLifecycleListener(){

                public boolean syncInvokeRequired() {
                    return false;
                }

                public void stopping(AzureusCore azureusCore) {
                    azureusCore.getGlobalManager().pauseDownloads();
                }

                public void stopped(AzureusCore azureusCore) {
                }

                public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public void started(AzureusCore azureusCore) {
                    countDownLatch.countDown();
                }

                public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                    return false;
                }

                public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                }
            });
            if (!AZUREUS_CORE.isStarted() && !AZUREUS_CORE.isRestarting()) {
                AZUREUS_CORE.start();
            }
            AZUREUS_CORE.getGlobalManager().resumeDownloads();
            LOG.debug("azureusInit(): core.start() waiting...");
            try {
                countDownLatch.await();
                LOG.debug("azureusInit(): core started...");
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static float getLastMeasuredUploadBandwidth() {
        if (AZUREUS_CORE == null || !AZUREUS_CORE.isStarted() || AZUREUS_CORE.getGlobalManager() == null || AZUREUS_CORE.getGlobalManager().getStats() == null) {
            return 0.0f;
        }
        return AZUREUS_CORE.getGlobalManager().getStats().getDataSendRate() / 1000;
    }

    public ConfigurationManager getConfigManager() {
        return ConfigurationManager.getInstance();
    }

    public static boolean allowNewTorrent() {
        List list = AZUREUS_CORE.getGlobalManager().getDownloadManagers();
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DownloadManager downloadManager = (DownloadManager)list.get(i);
            int n3 = downloadManager.getState();
            if (n3 != 0 && n3 != 5 && n3 != 10 && n3 != 20 && n3 != 30 && n3 != 40 && n3 != 50 && n3 != 65) continue;
            ++n2;
        }
        return n2 < BittorrentSettings.TORRENT_MAX_ACTIVE_DOWNLOADS.getValue();
    }
}

