/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.limewire.util.OSUtils;

public class ImageCache {
    private static ImageCache INSTANCE;

    private ImageCache() {
    }

    public static synchronized ImageCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageCache();
        }
        return INSTANCE;
    }

    public BufferedImage getImage(URL uRL, OnLoadedListener onLoadedListener) {
        if (this.isCached(uRL)) {
            BufferedImage bufferedImage = this.loadFromCache(uRL);
            onLoadedListener.onLoaded(uRL, bufferedImage, true);
            return bufferedImage;
        }
        if (!uRL.getProtocol().equals("http")) {
            return this.loadFromResource(uRL);
        }
        this.loadFromUrl(uRL, onLoadedListener);
        return null;
    }

    private File getCacheFile(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getPath();
        if (string == null || string.length() == 0) {
            string = "localhost";
            string2 = new File(string2).getName();
        }
        return new File(SharingSettings.getImageCacheDirectory(), File.separator + string + File.separator + string2);
    }

    public URL getCachedFileURL(URL uRL) {
        if (this.isCached(uRL)) {
            try {
                return this.getCacheFile(uRL).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private boolean isCached(URL uRL) {
        File file = this.getCacheFile(uRL);
        long l = System.currentTimeMillis();
        return file.exists() && l - file.lastModified() < 2592000000L;
    }

    private BufferedImage loadFromCache(URL uRL) {
        try {
            File file = this.getCacheFile(uRL);
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private BufferedImage loadFromResource(URL uRL) {
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.saveToCache(uRL, bufferedImage, 0L);
            return bufferedImage;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadFromUrl(final URL uRL, final OnLoadedListener onLoadedListener) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    BufferedImage bufferedImage = null;
                    String string = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getFrostWireVersion();
                    HttpFetcher httpFetcher = new HttpFetcher(uRL.toURI(), string);
                    Object[] objectArray = httpFetcher.fetch(false);
                    if (objectArray == null) {
                        throw new IOException("HttpFetcher.fetch() got nothing at " + uRL.toString());
                    }
                    byte[] byArray = (byte[])objectArray[0];
                    long l = (Long)objectArray[1];
                    if (byArray != null) {
                        bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                        ImageCache.this.saveToCache(uRL, bufferedImage, l);
                    }
                    if (onLoadedListener != null && bufferedImage != null) {
                        onLoadedListener.onLoaded(uRL, bufferedImage, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }

    private void saveToCache(URL uRL, BufferedImage bufferedImage, long l) {
        try {
            File file = this.getCacheFile(uRL);
            if (file.exists() && file.lastModified() < l) {
                file.delete();
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            String string3 = ImageIO.getImageReadersBySuffix(string2).next().getFormatName();
            if (file.mkdirs()) {
                ImageIO.write((RenderedImage)bufferedImage, string3, file);
                file.setLastModified(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface OnLoadedListener {
        public void onLoaded(URL var1, BufferedImage var2, boolean var3);
    }
}

