/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.contrib;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CircleLayout
extends AbstractLayout {
    private static final Object CIRCLE_KEY = "jung.Circle_Visualization_Key";
    private Pair key = new Pair(this, CIRCLE_KEY);
    private double radius;

    public CircleLayout(Graph g) {
        super(g);
    }

    public String getStatus() {
        return "CircleLayout";
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean incrementsAreDone() {
        return true;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void orderVertices(Vertex[] vertices) {
        List<Vertex> list = Arrays.asList(vertices);
        Collections.shuffle(list);
    }

    public Object getKey() {
        if (this.key == null) {
            this.key = new Pair(this, CIRCLE_KEY);
        }
        return this.key;
    }

    protected void initialize_local_vertex(Vertex v) {
        if (v.getUserDatum(this.getKey()) == null) {
            v.addUserDatum(this.getKey(), new CircleVertexData(), UserData.REMOVE);
        }
    }

    protected void initialize_local() {
    }

    protected void initializeLocations() {
        super.initializeLocations();
        Vertex[] vertices = this.getVisibleVertices().toArray(new Vertex[0]);
        this.orderVertices(vertices);
        Dimension d = this.getCurrentSize();
        double height = d.getHeight();
        double width = d.getWidth();
        if (this.radius <= 0.0) {
            this.radius = 0.45 * (height < width ? height : width);
        }
        for (int i = 0; i < vertices.length; ++i) {
            Coordinates coord = this.getCoordinates(vertices[i]);
            double angle = Math.PI * 2 * (double)i / (double)vertices.length;
            coord.setX(Math.cos(angle) * this.radius + width / 2.0);
            coord.setY(Math.sin(angle) * this.radius + height / 2.0);
            CircleVertexData data = this.getCircleData(vertices[i]);
            data.setAngle(angle);
        }
    }

    public CircleVertexData getCircleData(Vertex v) {
        return (CircleVertexData)v.getUserDatum(this.getKey());
    }

    public void advancePositions() {
    }

    public static class CircleVertexData {
        private double angle;

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public String toString() {
            return "CircleVertexData: angle=" + this.angle;
        }
    }
}

