/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.Iterator;
import java.util.Set;

public abstract class RelativeAuthorityRanker
extends AbstractRanker {
    private Set mPriors;
    public static final String PRIOR_KEY = "jung.algorithms.importance.RelativeAuthorityRanker.PriorRankScore";

    protected void finalizeIterations() {
        super.finalizeIterations();
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            currentVertex.removeUserDatum(PRIOR_KEY);
        }
    }

    protected String getPriorRankScoreKey() {
        return PRIOR_KEY;
    }

    protected double getPriorRankScore(Vertex v) {
        return ((MutableDouble)v.getUserDatum(PRIOR_KEY)).doubleValue();
    }

    public void setPriorRankScore(Vertex v, double value) {
        MutableDouble doubleVal = (MutableDouble)v.getUserDatum(PRIOR_KEY);
        if (doubleVal == null) {
            doubleVal = new MutableDouble(value);
        } else {
            doubleVal.setDoubleValue(value);
        }
        v.setUserDatum(PRIOR_KEY, doubleVal, UserData.SHARED);
    }

    protected Set getPriors() {
        return this.mPriors;
    }

    protected void setPriors(Set priors) {
        this.mPriors = priors;
    }
}

