/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;
import org.limewire.mojito.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vendor
implements Serializable,
Comparable<Vendor> {
    private static final long serialVersionUID = 1607453128714814318L;
    private static final Vendor[] VENDORS = new Vendor[10];
    public static final Vendor UNKNOWN = new Vendor(0);
    public static final int LENGTH = 4;
    private final int vendorId;

    private Vendor(int n) {
        this.vendorId = n;
    }

    public int intValue() {
        return this.vendorId;
    }

    public int hashCode() {
        return this.vendorId;
    }

    @Override
    public int compareTo(Vendor vendor) {
        return this.vendorId - vendor.vendorId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vendor)) {
            return false;
        }
        return this.vendorId == ((Vendor)object).vendorId;
    }

    public String toString() {
        return ArrayUtils.toString(this.vendorId);
    }

    public static synchronized Vendor valueOf(int n) {
        int n2 = (n & Integer.MAX_VALUE) % VENDORS.length;
        Vendor vendor = VENDORS[n2];
        if (vendor == null || vendor.vendorId != n) {
            Vendor.VENDORS[n2] = vendor = new Vendor(n);
        }
        return vendor;
    }

    public static Vendor valueOf(String string) {
        return Vendor.valueOf(ArrayUtils.toInteger(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            int n = (this.vendorId & Integer.MAX_VALUE) % VENDORS.length;
            Vendor vendor = VENDORS[n];
            if (vendor == null || vendor.vendorId != this.vendorId) {
                Vendor.VENDORS[n] = vendor = this;
            }
            return vendor;
        }
    }
}

