/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.AsyncFutureTask;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.FutureEvent;
import org.limewire.listener.EventListener;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.util.EventUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTFutureTask<V>
extends AsyncFutureTask<V>
implements DHTFuture<V> {
    private static final ScheduledExecutorService WATCHDOG = Executors.newSingleThreadScheduledExecutor(ExecutorsHelper.defaultThreadFactory((String)"WatchdogThread"));
    private final Context context;
    private final DHTTask<V> task;
    private final long timeout;
    private final TimeUnit unit;
    private ScheduledFuture<?> watchdog;
    private boolean wasTimeout = false;

    public DHTFutureTask(Context context, DHTTask<V> dHTTask) {
        this.context = context;
        this.task = dHTTask;
        this.timeout = dHTTask.getWaitOnLockTimeout();
        this.unit = TimeUnit.MILLISECONDS;
    }

    public Context getContext() {
        return this.context;
    }

    protected synchronized void doRun() {
        if (!this.isDone()) {
            this.watchdog();
            this.start();
        }
    }

    protected synchronized void start() {
        this.task.start(this);
    }

    private synchronized boolean watchdog() {
        if (this.timeout == -1L || this.isDone()) {
            return false;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTFutureTask dHTFutureTask = DHTFutureTask.this;
                synchronized (dHTFutureTask) {
                    if (!DHTFutureTask.this.isDone()) {
                        DHTFutureTask.this.wasTimeout = true;
                        DHTFutureTask.this.handleTimeout(DHTFutureTask.this.timeout, DHTFutureTask.this.unit);
                    }
                }
            }
        };
        this.watchdog = WATCHDOG.schedule(runnable, this.timeout, this.unit);
        return true;
    }

    protected void handleTimeout(long l, TimeUnit timeUnit) {
        this.setException(new TimeoutException(l + " " + (Object)((Object)timeUnit)));
    }

    @Override
    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeout, this.unit);
    }

    @Override
    public long getTimeoutInMillis() {
        return this.getTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized boolean isTimeout() {
        return this.wasTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void done() {
        DHTFutureTask dHTFutureTask = this;
        synchronized (dHTFutureTask) {
            if (this.watchdog != null) {
                this.watchdog.cancel(true);
            }
        }
        this.done0();
    }

    protected void done0() {
    }

    protected boolean isEventThread() {
        return EventUtils.isEventThread();
    }

    protected void fireOperationComplete(final EventListener<FutureEvent<V>>[] eventListenerArray, final FutureEvent<V> futureEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                DHTFutureTask.super.fireOperationComplete(eventListenerArray, futureEvent);
            }
        };
        EventUtils.fireEvent(runnable);
    }
}

