/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.Serializable;
import java.util.Map;
import org.limewire.mojito.util.FixedSizeHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCode
implements Serializable,
Comparable<StatusCode> {
    private static final long serialVersionUID = 948952689527998250L;
    private static final Map<Integer, StatusCode> CODES = new FixedSizeHashMap<Integer, StatusCode>(16, 0.75f, true, 32);
    private final int code;
    private final String description;

    private StatusCode(int n, String string) {
        this.code = n;
        this.description = string;
    }

    public int shortValue() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(StatusCode statusCode) {
        return this.code - statusCode.code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatusCode)) {
            return false;
        }
        return this.compareTo((StatusCode)object) == 0;
    }

    public String toString() {
        return this.code + ": " + this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusCode valueOf(int n, String string) {
        if (string == null) {
            throw new NullPointerException("description must not be null, code: " + n);
        }
        Integer n2 = n & 0xFFFF;
        StatusCode statusCode = null;
        Map<Integer, StatusCode> map = CODES;
        synchronized (map) {
            statusCode = CODES.get(n2);
            if (statusCode == null || !statusCode.description.equals(string)) {
                statusCode = new StatusCode(n, string);
                CODES.put(n2, statusCode);
            }
        }
        return statusCode;
    }
}

