/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Contact;

public class EntityKey {
    private final Contact node;
    private final KUID primaryKey;
    private final KUID secondaryKey;
    private final DHTValueType valueType;
    private final int hashCode;

    public static EntityKey createEntityKey(KUID kUID, DHTValueType dHTValueType) {
        if (kUID == null) {
            throw new NullPointerException("PrimaryKey is null");
        }
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return new EntityKey(null, kUID, null, dHTValueType);
    }

    public static EntityKey createEntityKey(Contact contact, KUID kUID, KUID kUID2, DHTValueType dHTValueType) {
        if (contact == null) {
            throw new NullPointerException("Contact is null");
        }
        if (kUID == null) {
            throw new NullPointerException("PrimaryKey is null");
        }
        if (kUID2 == null) {
            throw new NullPointerException("SecondaryKey is null");
        }
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return new EntityKey(contact, kUID, kUID2, dHTValueType);
    }

    private EntityKey(Contact contact, KUID kUID, KUID kUID2, DHTValueType dHTValueType) {
        this.node = contact;
        this.primaryKey = kUID;
        this.secondaryKey = kUID2;
        this.valueType = dHTValueType;
        int n = kUID.hashCode() ^ dHTValueType.hashCode();
        if (kUID2 != null) {
            n ^= kUID2.hashCode();
        }
        this.hashCode = n;
    }

    public boolean isLookupKey() {
        return this.secondaryKey == null;
    }

    public Contact getContact() {
        return this.node;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public KUID getSecondaryKey() {
        return this.secondaryKey;
    }

    public DHTValueType getDHTValueType() {
        return this.valueType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EntityKey)) {
            return false;
        }
        EntityKey entityKey = (EntityKey)object;
        if (this.isLookupKey() != entityKey.isLookupKey()) {
            return false;
        }
        if (this.isLookupKey()) {
            return this.primaryKey.equals(entityKey.primaryKey) && this.valueType.equals(entityKey.valueType);
        }
        return this.primaryKey.equals(entityKey.primaryKey) && this.secondaryKey.equals(entityKey.secondaryKey) && this.valueType.equals(entityKey.valueType);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Contact: ").append(this.getContact()).append("\n");
        stringBuilder.append("PrimaryKey: ").append(this.getPrimaryKey()).append("\n");
        stringBuilder.append("SecondaryKey: ").append(this.getSecondaryKey()).append("\n");
        stringBuilder.append("DHTValueType: ").append(this.getDHTValueType()).append("\n");
        stringBuilder.append("IsLookupKey: ").append(this.isLookupKey()).append("\n");
        return stringBuilder.toString();
    }
}

