/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.RoundRobinQueue;
import org.limewire.concurrent.ExecutorsHelper;

public class RRProcessingQueue {
    private static final Log LOG = LogFactory.getLog(RRProcessingQueue.class);
    private final ThreadFactory FACTORY;
    private Thread _runner = null;
    private final Map<Object, NamedQueue> queues = new HashMap<Object, NamedQueue>();
    private final RoundRobinQueue<NamedQueue> lists = new RoundRobinQueue();
    private int size;

    public RRProcessingQueue(String string) {
        this.FACTORY = ExecutorsHelper.daemonThreadFactory((String)string);
    }

    public synchronized void execute(Runnable runnable, Object object) {
        NamedQueue namedQueue = this.queues.get(object);
        if (namedQueue == null) {
            namedQueue = new NamedQueue(new LinkedList<Runnable>(), object);
            this.queues.put(object, namedQueue);
            this.lists.enqueue(namedQueue);
        }
        namedQueue.list.add(runnable);
        ++this.size;
        this.notifyAndStart();
    }

    protected synchronized void notifyAndStart() {
        this.notify();
        if (this._runner == null) {
            this.startRunner();
        }
    }

    private synchronized void startRunner() {
        this._runner = this.FACTORY.newThread(new Processor());
        this._runner.setDaemon(true);
        this._runner.start();
    }

    protected synchronized boolean moreTasks() {
        return this.size > 0;
    }

    protected synchronized Runnable next() {
        Runnable runnable = null;
        while (this.lists.size() > 0) {
            NamedQueue namedQueue = this.lists.next();
            runnable = namedQueue.next();
            if (runnable == null || namedQueue.list.isEmpty()) {
                this.lists.removeAllOccurences(namedQueue);
                this.queues.remove(namedQueue.name);
            }
            if (runnable == null) continue;
            --this.size;
            return runnable;
        }
        return null;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void clear() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing all " + this.size + " jobs from " + this.queues.size() + " queues"));
        }
        this.queues.clear();
        this.lists.clear();
        this.size = 0;
    }

    public synchronized void clear(Object object) {
        NamedQueue namedQueue = this.queues.remove(object);
        if (namedQueue == null) {
            return;
        }
        this.lists.removeAllOccurences(namedQueue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + namedQueue.list.size() + " jobs out of " + this.size));
        }
        this.size -= namedQueue.list.size();
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                while (true) {
                    if ((object = RRProcessingQueue.this.next()) != null) {
                        object.run();
                    }
                    RRProcessingQueue rRProcessingQueue = RRProcessingQueue.this;
                    synchronized (rRProcessingQueue) {
                        if (RRProcessingQueue.this.moreTasks()) {
                            continue;
                        }
                        try {
                            RRProcessingQueue.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!RRProcessingQueue.this.moreTasks()) return;
                    }
                }
            }
            finally {
                object = RRProcessingQueue.this;
                synchronized (object) {
                    if (RRProcessingQueue.this.moreTasks()) {
                        RRProcessingQueue.this.startRunner();
                    } else {
                        RRProcessingQueue.this._runner = null;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedQueue {
        final List<Runnable> list;
        final Object name;

        NamedQueue(List<Runnable> list, Object object) {
            this.list = list;
            this.name = object;
        }

        Runnable next() {
            return this.list.isEmpty() ? null : this.list.remove(0);
        }
    }
}

